/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.manyideas_core.elements.commands.givedb;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.geheimagentnr1.manyideas_core.elements.block_state_properties.Color;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

class ColorParser {
    @NotNull
    private static final DynamicCommandExceptionType COLOR_INVALID = new DynamicCommandExceptionType(function -> Component.m_237110_((String)"argument.color.invalid", (Object[])new Object[]{function}));
    @NotNull
    private static final Set<String> COLORS = ColorParser.getItemKeySet();
    @NotNull
    private final StringReader reader;
    private Color dyeColor;
    private Function<SuggestionsBuilder, CompletableFuture<Suggestions>> suggestionsBuilder;

    ColorParser(@NotNull StringReader _reader) {
        this.reader = _reader;
    }

    @NotNull
    private static Set<String> getItemKeySet() {
        TreeSet<String> keySet = new TreeSet<String>();
        for (Color dyeColor : Color.values()) {
            keySet.add(dyeColor.m_7912_());
        }
        return keySet;
    }

    public Color getColor() {
        return this.dyeColor;
    }

    private void readColor() throws CommandSyntaxException {
        int cursor = this.reader.getCursor();
        ResourceLocation resourceLocation = ResourceLocation.m_135818_((StringReader)this.reader);
        this.dyeColor = this.getItemForRegistry(resourceLocation).orElseThrow(() -> {
            this.reader.setCursor(cursor);
            return COLOR_INVALID.createWithContext((ImmutableStringReader)this.reader, (Object)resourceLocation.toString());
        });
    }

    @NotNull
    private Optional<Color> getItemForRegistry(@NotNull ResourceLocation resourceLocation) {
        for (Color dye_color : Color.values()) {
            if (!dye_color.name().equals(resourceLocation.m_135815_().toUpperCase(Locale.ENGLISH))) continue;
            return Optional.of(dye_color);
        }
        return Optional.empty();
    }

    @NotNull
    ColorParser parse() throws CommandSyntaxException {
        this.suggestionsBuilder = this::suggestColor;
        this.readColor();
        this.suggestionsBuilder = this::suggestColorFuture;
        return this;
    }

    @NotNull
    private CompletableFuture<Suggestions> suggestColorFuture(@NotNull SuggestionsBuilder builder) {
        return builder.buildFuture();
    }

    @NotNull
    private CompletableFuture<Suggestions> suggestColor(@NotNull SuggestionsBuilder builder) {
        return SharedSuggestionProvider.m_82970_(COLORS, (SuggestionsBuilder)builder);
    }

    @NotNull
    CompletableFuture<Suggestions> fillSuggestions(@NotNull SuggestionsBuilder builder) {
        return this.suggestionsBuilder.apply(builder.createOffset(this.reader.getCursor()));
    }
}

