/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.manyideas_core.elements.blocks.template_blocks.doors;

import de.geheimagentnr1.manyideas_core.elements.block_state_properties.ModBlockStateProperties;
import de.geheimagentnr1.manyideas_core.elements.block_state_properties.OpenedBy;
import de.geheimagentnr1.manyideas_core.elements.blocks.template_blocks.multi_block.MultiBlock;
import de.geheimagentnr1.manyideas_core.elements.items.ModItemsRegisterFactory;
import de.geheimagentnr1.manyideas_core.elements.items.tools.redstone_key.interfaces.RedstoneKeyable;
import de.geheimagentnr1.manyideas_core.elements.items.tools.redstone_key.models.Option;
import de.geheimagentnr1.manyideas_core.util.doors.BigDoorsHelper;
import de.geheimagentnr1.manyideas_core.util.doors.BlockData;
import de.geheimagentnr1.manyideas_core.util.doors.DoorsHelper;
import de.geheimagentnr1.manyideas_core.util.doors.OpenedByHelper;
import de.geheimagentnr1.manyideas_core.util.voxel_shapes.VoxelShapeMemory;
import de.geheimagentnr1.manyideas_core.util.voxel_shapes.VoxelShapeVector;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public abstract class BigDoor
extends MultiBlock
implements RedstoneKeyable {
    @NotNull
    private static final VoxelShapeMemory DOORS_SHAPES = VoxelShapeMemory.createHorizontalVoxelShapes(Direction.SOUTH, VoxelShapeVector.create(0.0, 0.0, 0.0, 16.0, 16.0, 3.0));
    @NotNull
    private final BlockSetType type;
    private boolean[][][] hasBlockstateAtPos;
    private final boolean doubleDoorActive;

    protected BigDoor(@NotNull BlockBehaviour.Properties _properties, @NotNull BlockSetType _type, @NotNull OpenedBy openedBy, boolean _doubleDoorActive) {
        super(_properties.m_60955_().m_60971_((state, level, pos) -> false));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61446_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(false))).m_61124_(ModBlockStateProperties.OPENED_BY, (Comparable)((Object)openedBy)));
        this.type = _type;
        this.doubleDoorActive = _doubleDoorActive;
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61446_)).booleanValue()) {
            int z = (Integer)state.m_61143_((Property)this.Z_SIZE);
            if (state.m_61143_((Property)BlockStateProperties.f_61394_) == DoorHingeSide.LEFT) {
                if (z == 0) {
                    return DOORS_SHAPES.getShapeFromHorizontalFacing(facing.m_122427_());
                }
            } else if (z == this.getZSize() - 1) {
                return DOORS_SHAPES.getShapeFromHorizontalFacing(facing.m_122428_());
            }
        } else if ((Integer)state.m_61143_((Property)this.X_SIZE) == 0) {
            return DOORS_SHAPES.getShapeFromHorizontalFacing(facing);
        }
        return Shapes.m_83040_();
    }

    @Override
    protected boolean[][][] hasBlockStatesAtPos() {
        if (this.hasBlockstateAtPos == null) {
            this.hasBlockstateAtPos = new boolean[this.getXSize()][this.getYSize()][this.getZSize()];
            for (int x = 0; x < this.getXSize(); ++x) {
                for (int y = 0; y < this.getYSize(); ++y) {
                    for (int z = 0; z < this.getZSize(); ++z) {
                        this.hasBlockstateAtPos[x][y][z] = true;
                    }
                }
            }
        }
        return this.hasBlockstateAtPos;
    }

    @Override
    @NotNull
    protected BlockState getDefaultState(boolean left_sided) {
        return (BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61394_, (Comparable)(left_sided ? DoorHingeSide.LEFT : DoorHingeSide.RIGHT));
    }

    @NotNull
    protected BlockPos getZeroPos(@NotNull BlockData blockData) {
        return this.getZeroPos(blockData.getState(), blockData.getPos());
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        if (player.m_21120_(hand).m_41720_() != ModItemsRegisterFactory.RESTONE_KEY && OpenedByHelper.canBeOpened(state, true)) {
            BlockData neighbor;
            boolean open = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61446_) == false;
            Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
            BlockPos zeroPos = this.getZeroPos(state, pos);
            this.runForBlocks(level, zeroPos, facing, (x, y, z, blockPos) -> level.m_7731_(blockPos, (BlockState)level.m_8055_(blockPos).m_61124_((Property)BlockStateProperties.f_61446_, (Comparable)Boolean.valueOf(open)), 3), true);
            DoorsHelper.playDoorSound(level, pos, this.type, player, open);
            if (this.doubleDoorActive && BigDoorsHelper.isNeighbor(state, neighbor = BigDoorsHelper.getNeighborBlock(level, zeroPos, state, this.getZSize(), this::getZeroPos))) {
                this.runForBlocks(level, neighbor.getZeroPos(), facing, (x, y, z, blockPos) -> level.m_7731_(blockPos, (BlockState)level.m_8055_(blockPos).m_61124_((Property)BlockStateProperties.f_61446_, (Comparable)Boolean.valueOf(open)), 3), true);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void m_6861_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Block block, @NotNull BlockPos fromPos, boolean isMoving) {
        if (block != this && OpenedByHelper.canBeOpened(state, false)) {
            boolean isDoorPowered;
            BlockPos zeroPos = this.getZeroPos(state, pos);
            Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
            BlockData neighbor = BigDoorsHelper.getNeighborBlock(level, zeroPos, state, this.getZSize(), this::getZeroPos);
            boolean isNeighbor = BigDoorsHelper.isNeighbor(state, neighbor);
            boolean bl = isDoorPowered = this.isPowered(level, zeroPos, facing) || isNeighbor && this.isPowered(level, neighbor.getZeroPos(), facing);
            if (isDoorPowered != (Boolean)state.m_61143_((Property)BlockStateProperties.f_61448_)) {
                if ((Boolean)state.m_61143_((Property)BlockStateProperties.f_61446_) != isDoorPowered) {
                    DoorsHelper.playDoorSound(level, pos, this.type, null, isDoorPowered);
                }
                this.runForBlocks(level, zeroPos, facing, (x, y, z, blockPos) -> level.m_7731_(blockPos, (BlockState)((BlockState)level.m_8055_(blockPos).m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(isDoorPowered))).m_61124_((Property)BlockStateProperties.f_61446_, (Comparable)Boolean.valueOf(isDoorPowered)), 3), true);
                if (this.doubleDoorActive && isNeighbor) {
                    this.runForBlocks(level, neighbor.getZeroPos(), facing, (x, y, z, blockPos) -> level.m_7731_(blockPos, (BlockState)((BlockState)level.m_8055_(blockPos).m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(isDoorPowered))).m_61124_((Property)BlockStateProperties.f_61446_, (Comparable)Boolean.valueOf(isDoorPowered)), 3), true);
                }
            }
        }
    }

    @Deprecated
    public boolean m_7357_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull PathComputationType type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case PathComputationType.LAND, PathComputationType.AIR -> state.m_60808_(level, pos).m_83281_();
            case PathComputationType.WATER -> false;
        };
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{BlockStateProperties.f_61394_, BlockStateProperties.f_61446_, BlockStateProperties.f_61448_, ModBlockStateProperties.OPENED_BY});
    }

    @Override
    public Component getTitle() {
        return OpenedByHelper.OPEN_BY_CONTAINER_TITLE;
    }

    @Override
    public ResourceLocation getIconTextures() {
        return OpenedByHelper.ICON_TEXTURES;
    }

    @Override
    public List<Option> getOptions() {
        return OpenedByHelper.buildOptions();
    }

    @Override
    public int getStateIndex(BlockState state) {
        return OpenedByHelper.getStateIndex(state);
    }

    @Override
    public void setBlockStateValue(Level level, BlockState state, BlockPos pos, int stateIndex, Player player) {
        OpenedBy[] openedByValues = OpenedBy.values();
        if (stateIndex >= 0 && stateIndex < openedByValues.length) {
            OpenedBy openedBy = openedByValues[stateIndex];
            BlockPos zeroPos = this.getZeroPos(state, pos);
            Direction facing = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
            this.runForBlocks(level, zeroPos, facing, (x, y, z, blockPos) -> level.m_7731_(blockPos, (BlockState)level.m_8055_(blockPos).m_61124_(ModBlockStateProperties.OPENED_BY, (Comparable)((Object)openedBy)), 3), true);
            BlockData neighbor = BigDoorsHelper.getNeighborBlock(level, zeroPos, state, this.getZSize(), this::getZeroPos);
            if (this.doubleDoorActive && BigDoorsHelper.isNeighbor(state, neighbor)) {
                this.runForBlocks(level, neighbor.getZeroPos(), facing, (x, y, z, blockPos) -> level.m_7731_(blockPos, (BlockState)level.m_8055_(blockPos).m_61124_(ModBlockStateProperties.OPENED_BY, (Comparable)((Object)openedBy)), 3), true);
            }
        }
    }
}

