/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.blocks.greenhouse;

import com.eerussianguy.firmalife.common.FLTags;
import com.eerussianguy.firmalife.common.blocks.greenhouse.GreenhousePanelRoofBlock;
import com.eerussianguy.firmalife.common.blocks.greenhouse.GreenhouseWallBlock;
import java.util.function.Supplier;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class GreenhousePanelWallBlock
extends GreenhouseWallBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final VoxelShape[] SHAPES = Helpers.computeHorizontalShapes(d -> Helpers.rotateShape((Direction)d, (double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0));

    public GreenhousePanelWallBlock(ExtendedProperties properties, @Nullable Supplier<? extends Block> next) {
        super(properties, next);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPES[((Direction)state.m_61143_((Property)FACING)).m_122416_()];
    }

    @Override
    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockState state = super.m_5573_(ctx);
        if (state != null) {
            Level level = ctx.m_43725_();
            BlockState below = level.m_8055_(ctx.m_8083_().m_7495_());
            if (below.m_60734_() instanceof GreenhousePanelWallBlock) {
                return Helpers.copyProperties((BlockState)state, (BlockState)below);
            }
            return (BlockState)state.m_61124_((Property)FACING, (Comparable)ctx.m_8125_().m_122424_());
        }
        return null;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        super.m_6810_(state, level, pos, newState, isMoving);
        this.fixPanelRoofs((LevelAccessor)level, pos);
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        this.fixPanelRoofs(level, currentPos);
        return super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
    }

    private void fixPanelRoofs(LevelAccessor level, BlockPos pos) {
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            BlockPos relativePos = pos.m_7494_().m_121945_(dir);
            BlockState relativeState = level.m_8055_(relativePos);
            if (!(relativeState.m_60734_() instanceof GreenhousePanelRoofBlock)) continue;
            level.m_186460_(relativePos, relativeState.m_60734_(), 1);
        }
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_((StateDefinition.Builder<Block, BlockState>)builder.m_61104_(new Property[]{FACING}));
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    @Override
    public boolean connects(BlockState adjacent) {
        return Helpers.isBlock((BlockState)adjacent, FLTags.Blocks.GREENHOUSE_PANEL_WALLS);
    }
}

