/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.blocks;

import com.eerussianguy.firmalife.common.FLHelpers;
import com.eerussianguy.firmalife.common.blockentities.FLBlockEntities;
import com.eerussianguy.firmalife.common.blockentities.JarbnetBlockEntity;
import com.eerussianguy.firmalife.common.blocks.FourWayDeviceBlock;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.devices.DeviceBlock;
import net.dries007.tfc.common.items.CandleBlockItem;
import net.dries007.tfc.common.items.JugItem;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class JarbnetBlock
extends FourWayDeviceBlock {
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    public static final BooleanProperty LIT = BlockStateProperties.f_61443_;
    public static final VoxelShape NORTH_SHAPE = JarbnetBlock.m_49796_((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape WEST_SHAPE = Helpers.rotateShape((Direction)Direction.WEST, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape EAST_SHAPE = Helpers.rotateShape((Direction)Direction.EAST, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0, (double)16.0);
    public static final VoxelShape SOUTH_SHAPE = Helpers.rotateShape((Direction)Direction.SOUTH, (double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)16.0, (double)16.0);

    public static boolean isItemAllowed(ItemStack stack) {
        Item item = stack.m_41720_();
        return Helpers.isItem((Item)item, (TagKey)TFCTags.Items.JARS) || item instanceof JugItem || item instanceof CandleBlockItem;
    }

    private static void addParticlesAndSound(Level level, double x, double y, double z, RandomSource rand) {
        float value = rand.m_188501_();
        if (value < 0.3f) {
            level.m_7106_((ParticleOptions)ParticleTypes.f_123762_, x, y, z, 0.0, 0.0, 0.0);
            if (value < 0.17f) {
                level.m_7785_(x + 0.5, y + 0.5, z + 0.5, SoundEvents.f_144096_, SoundSource.BLOCKS, 1.0f + rand.m_188501_(), rand.m_188501_() * 0.7f + 0.3f, false);
            }
        }
        level.m_7106_((ParticleOptions)ParticleTypes.f_175834_, x, y, z, 0.0, 0.0, 0.0);
    }

    public JarbnetBlock(ExtendedProperties properties) {
        super(properties, DeviceBlock.InventoryRemoveBehavior.DROP);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(true))).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
            Direction dir = (Direction)state.m_61143_((Property)FACING);
            int dx = Mth.m_14040_((int)dir.m_122429_());
            int dz = Mth.m_14040_((int)dir.m_122431_());
            double x = (double)pos.m_123341_() + 0.5 * (double)random.m_188501_() + 0.5 * (double)dx;
            double y = (float)pos.m_123342_() + (random.m_188501_() * 0.15f + (random.m_188499_() ? 0.33f : 0.66f));
            double z = (double)pos.m_123343_() + 0.5 * (double)random.m_188501_() + 0.5 * (double)dz;
            JarbnetBlock.addParticlesAndSound(level, x, y, z, random);
        }
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)LIT)).booleanValue() && !((Boolean)state.m_61143_((Property)OPEN)).booleanValue()) {
            return (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false));
        }
        return state;
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof JarbnetBlockEntity) {
            JarbnetBlockEntity jarbnet = (JarbnetBlockEntity)blockEntity;
            if (((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
                int ct = (Integer)TFCConfig.SERVER.candleTicks.get();
                if (jarbnet.getTicksSinceUpdate() > (long)ct && ct != -1) {
                    level.m_46597_(pos, (BlockState)state.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false)));
                }
            }
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        ItemStack held = player.m_21120_(hand);
        if (held.m_41619_()) {
            if (player.m_6144_()) {
                boolean open = (Boolean)state.m_61143_((Property)OPEN);
                BlockState newState = (BlockState)state.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(!open));
                if (open) {
                    if (((Boolean)state.m_61143_((Property)LIT)).booleanValue()) {
                        Helpers.playSound((Level)level, (BlockPos)pos, (SoundEvent)SoundEvents.f_11937_);
                        newState = (BlockState)newState.m_61124_((Property)LIT, (Comparable)Boolean.valueOf(false));
                    }
                    Helpers.playSound((Level)level, (BlockPos)pos, (SoundEvent)SoundEvents.f_12628_);
                } else {
                    Helpers.playSound((Level)level, (BlockPos)pos, (SoundEvent)SoundEvents.f_12629_);
                }
                level.m_46597_(pos, newState);
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            return FLHelpers.consumeInventory(level, pos, FLBlockEntities.JARBNET, (jar, inv) -> FLHelpers.takeOneAny(level, 0, 5, inv, player));
        }
        if (JarbnetBlock.isItemAllowed(held)) {
            return FLHelpers.consumeInventory(level, pos, FLBlockEntities.JARBNET, (jar, inv) -> FLHelpers.insertOneAny(level, held, 0, 5, inv, player));
        }
        return InteractionResult.PASS;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_((StateDefinition.Builder<Block, BlockState>)builder.m_61104_(new Property[]{OPEN, LIT}));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext pContext) {
        return switch ((Direction)state.m_61143_((Property)FACING)) {
            case Direction.NORTH -> NORTH_SHAPE;
            case Direction.SOUTH -> SOUTH_SHAPE;
            case Direction.WEST -> WEST_SHAPE;
            default -> EAST_SHAPE;
        };
    }
}

