/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.blockentities;

import com.eerussianguy.firmalife.common.blockentities.FLBlockEntities;
import com.eerussianguy.firmalife.common.blockentities.LargePlanterBlockEntity;
import com.eerussianguy.firmalife.common.blockentities.QuadPlanterBlockEntity;
import com.eerussianguy.firmalife.common.blocks.greenhouse.LargePlanterBlock;
import com.eerussianguy.firmalife.config.FLConfig;
import net.dries007.tfc.common.blockentities.TickableBlockEntity;
import net.dries007.tfc.common.blockentities.rotation.RotationSinkBlockEntity;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.rotation.NetworkAction;
import net.dries007.tfc.util.rotation.Node;
import net.dries007.tfc.util.rotation.SinkNode;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class SweeperBlockEntity
extends TickableBlockEntity
implements RotationSinkBlockEntity {
    private final Node node;

    public static void serverTick(Level level, BlockPos pos, BlockState state, SweeperBlockEntity sweeper) {
        BlockEntity blockEntity;
        sweeper.checkForLastTickSync();
        float angle = sweeper.getRotationAngle(0.0f) * 57.295776f - 90.0f;
        if (!sweeper.getRotationNode().isConnectedToNetwork()) {
            if (((Boolean)FLConfig.SERVER.mechanicalPowerCheatMode.get()).booleanValue() && level.m_276867_(pos)) {
                angle = 360.0f - (float)(level.m_46467_() % 80L) / 80.0f * 360.0f - 90.0f;
            } else {
                return;
            }
        }
        if (angle < 0.0f) {
            angle += 360.0f;
        }
        int x = 0;
        int z = 0;
        if (angle > 0.0f && angle < 5.0f) {
            x = 1;
        } else if (angle > 40.0f && angle < 45.0f) {
            x = 1;
            z = -1;
        }
        if (angle > 85.0f && angle < 90.0f) {
            z = -1;
        }
        if (angle > 130.0f && angle < 135.0f) {
            x = -1;
            z = -1;
        }
        if (angle > 175.0f && angle < 180.0f) {
            x = -1;
        }
        if (angle > 220.0f && angle < 225.0f) {
            x = -1;
            z = 1;
        }
        if (angle > 265.0f && angle < 270.0f) {
            z = 1;
        }
        if (angle > 310.0f && angle < 315.0f) {
            x = 1;
            z = 1;
        }
        if ((blockEntity = level.m_7702_(pos.m_7918_(x, 0, z))) instanceof LargePlanterBlockEntity) {
            LargePlanterBlockEntity planter = (LargePlanterBlockEntity)blockEntity;
            if (planter instanceof QuadPlanterBlockEntity) {
                return;
            }
            for (int i = 0; i < planter.slots(); ++i) {
                LargePlanterBlock.takeSlot(level, planter, i, item -> Helpers.spawnItem((Level)level, (BlockPos)pos, (ItemStack)item));
            }
        }
    }

    public SweeperBlockEntity(final BlockPos pos, BlockState state) {
        super((BlockEntityType)FLBlockEntities.SWEEPER.get(), pos, state);
        this.node = new SinkNode(pos, Direction.DOWN){

            public String toString() {
                return "SinkNode[pos=%s]".formatted(pos);
            }
        };
    }

    protected void onLoadAdditional() {
        this.performNetworkAction(NetworkAction.ADD);
    }

    protected void onUnloadAdditional() {
        this.performNetworkAction(NetworkAction.REMOVE);
    }

    public Node getRotationNode() {
        return this.node;
    }
}

