/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.blockentities;

import com.eerussianguy.firmalife.common.blockentities.FLBlockEntities;
import com.eerussianguy.firmalife.common.blockentities.QuadPlanterBlockEntity;
import com.eerussianguy.firmalife.common.blocks.greenhouse.LargePlanterBlock;
import net.dries007.tfc.common.blockentities.TickableBlockEntity;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class PickerBlockEntity
extends TickableBlockEntity {
    private boolean justPushed = false;
    private long lastPushed = 0L;

    public static void tick(Level level, BlockPos pos, BlockState state, PickerBlockEntity picker) {
        picker.checkForLastTickSync();
        if (picker.justPushed && level.m_46467_() - picker.lastPushed > 10L) {
            picker.pick();
            picker.justPushed = false;
        }
    }

    public PickerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)FLBlockEntities.PICKER.get(), pos, state);
    }

    public float getExtensionLength() {
        if (this.f_58857_ == null) {
            return 0.0f;
        }
        int time = (int)(this.f_58857_.m_46467_() - this.lastPushed);
        if (time < 10) {
            return (float)time * 0.05f;
        }
        return time < 20 ? (float)(20 - time) * 0.05f : 0.0f;
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128356_("pushed", this.lastPushed);
        tag.m_128379_("justPushed", this.justPushed);
    }

    protected void loadAdditional(CompoundTag tag) {
        super.loadAdditional(tag);
        this.lastPushed = tag.m_128454_("pushed");
        this.justPushed = tag.m_128471_("justPushed");
    }

    public long getLastPushed() {
        return this.lastPushed;
    }

    public void push() {
        assert (this.f_58857_ != null);
        if (this.justPushed) {
            return;
        }
        this.lastPushed = this.f_58857_.m_46467_();
        this.justPushed = true;
        this.markForSync();
    }

    public void pick() {
        assert (this.f_58857_ != null);
        if (this.f_58857_.f_46443_) {
            return;
        }
        BlockPos pickPos = this.f_58858_.m_7495_();
        BlockEntity blockEntity = this.f_58857_.m_7702_(pickPos);
        if (blockEntity instanceof QuadPlanterBlockEntity) {
            QuadPlanterBlockEntity planter = (QuadPlanterBlockEntity)blockEntity;
            for (int i = 0; i < planter.slots(); ++i) {
                LargePlanterBlock.takeSlot(this.f_58857_, planter, i, item -> Helpers.spawnItem((Level)this.f_58857_, (BlockPos)this.f_58858_, (ItemStack)item));
            }
        }
    }
}

