/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.blockentities;

import com.eerussianguy.firmalife.common.FLHelpers;
import com.eerussianguy.firmalife.common.blockentities.ApplianceBlockEntity;
import com.eerussianguy.firmalife.common.blockentities.FLBlockEntities;
import com.eerussianguy.firmalife.common.blockentities.OvenLike;
import com.eerussianguy.firmalife.common.blocks.ICure;
import com.eerussianguy.firmalife.common.blocks.OvenTopBlock;
import com.eerussianguy.firmalife.common.items.FLFoodTraits;
import com.eerussianguy.firmalife.common.recipes.WrappedHeatingRecipe;
import net.dries007.tfc.common.blockentities.InventoryBlockEntity;
import net.dries007.tfc.common.capabilities.PartialItemHandler;
import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.common.capabilities.food.FoodTrait;
import net.dries007.tfc.common.capabilities.heat.HeatCapability;
import net.dries007.tfc.common.capabilities.heat.IHeat;
import net.dries007.tfc.common.recipes.inventory.ItemStackInventory;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.calendar.ICalendarTickable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.IItemHandlerModifiable;

public class OvenTopBlockEntity
extends ApplianceBlockEntity<ApplianceBlockEntity.ApplianceInventory>
implements ICalendarTickable,
OvenLike {
    public static final int SLOTS = 4;
    public static final int SLOT_INPUT_END = 3;
    public static final int SLOT_INPUT_START = 0;
    public static final int TARGET_TEMPERATURE_STABILITY_TICKS = 400;
    private boolean needsRecipeUpdate;
    private final WrappedHeatingRecipe[] cachedRecipes = new WrappedHeatingRecipe[4];
    private int[] cookTicks = new int[]{0, 0, 0, 0};
    private int cureTicks = 0;
    private boolean isInsulated = false;

    public static void cure(Level level, BlockState oldState, BlockState newState, BlockPos pos) {
        BlockState placeState = Helpers.copyProperties((BlockState)newState, (BlockState)oldState);
        level.m_141902_(pos, (BlockEntityType)FLBlockEntities.OVEN_TOP.get()).ifPresent(oven -> {
            float temperature = oven.temperature;
            float targetTemperature = oven.targetTemperature;
            int targetTemperatureStabilityTicks = oven.targetTemperatureStabilityTicks;
            NonNullList items = Helpers.extractAllItems((IItemHandlerModifiable)oven.inventory);
            level.m_46597_(pos, placeState);
            level.m_141902_(pos, (BlockEntityType)FLBlockEntities.OVEN_TOP.get()).ifPresent(newOven -> {
                newOven.temperature = temperature;
                newOven.targetTemperature = targetTemperature;
                newOven.targetTemperatureStabilityTicks = targetTemperatureStabilityTicks;
                Helpers.insertAllItems((IItemHandlerModifiable)newOven.inventory, (NonNullList)items);
                newOven.markForSync();
            });
        });
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, OvenTopBlockEntity oven) {
        ICure cure;
        if (oven.needsRecipeUpdate) {
            oven.needsRecipeUpdate = false;
            oven.updateCaches();
        }
        oven.checkForLastTickSync();
        oven.checkForCalendarUpdate();
        Block block = state.m_60734_();
        boolean cured = block instanceof ICure && (cure = (ICure)block).isCured();
        int updateInterval = 40;
        if (level.m_46467_() % 40L == 0L) {
            OvenLike.regularBlockUpdate(level, pos, state, oven, cured, 40);
            oven.isInsulated = ((OvenTopBlock)state.m_60734_()).isInsulated((LevelAccessor)level, pos, state);
        }
        oven.tickTemperature();
        if ((level.m_46467_() + 20L) % 40L == 0L) {
            oven.spreadHeat();
        }
        if (!cured) {
            return;
        }
        for (int i = 0; i <= 3; ++i) {
            WrappedHeatingRecipe recipe;
            float targetTemp;
            IHeat cap;
            int slot = i;
            ItemStack inputStack = ((ApplianceBlockEntity.ApplianceInventory)oven.inventory).getStackInSlot(i);
            if (inputStack.m_41619_() || (cap = HeatCapability.get((ItemStack)inputStack)) == null) continue;
            float f = targetTemp = oven.isInsulated ? oven.temperature : oven.temperature * 0.5f;
            if (cap.getTemperature() < targetTemp) {
                float modifier = FoodCapability.hasTrait((ItemStack)inputStack, (FoodTrait)FLFoodTraits.OVEN_BAKED) ? 2.0f : 2.0f + targetTemp * 0.0025f;
                HeatCapability.addTemp((IHeat)cap, (float)targetTemp, (float)modifier);
            }
            if ((recipe = oven.cachedRecipes[slot]) == null || !recipe.isValidTemperature(cap.getTemperature())) continue;
            int n = slot;
            int n2 = oven.cookTicks[n];
            oven.cookTicks[n] = n2 + 1;
            if (n2 <= recipe.duration()) continue;
            ItemStackInventory inventory = new ItemStackInventory(inputStack);
            ItemStack outputItem = recipe.assemble(inventory, level.m_9598_());
            outputItem.getCapability(HeatCapability.CAPABILITY).ifPresent(outputCap -> outputCap.setTemperature(oven.temperature));
            FoodCapability.applyTrait((ItemStack)outputItem, (FoodTrait)FLFoodTraits.OVEN_BAKED);
            FoodCapability.setCreationDate((ItemStack)outputItem, (long)FoodCapability.getRoundedCreationDate());
            ((ApplianceBlockEntity.ApplianceInventory)oven.inventory).setStackInSlot(slot, outputItem);
            oven.markForSync();
            oven.needsRecipeUpdate = true;
        }
    }

    public OvenTopBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)FLBlockEntities.OVEN_TOP.get(), pos, state, OvenInventory::new, FLHelpers.blockEntityName("oven_top"));
        this.sidedInventory.on((Object)new PartialItemHandler(this.inventory).insert(new int[]{0, 1, 2, 3}), new Direction[]{Direction.UP}).on((Object)new PartialItemHandler(this.inventory).extract(new int[]{0, 1, 2, 3}), d -> d != Direction.UP);
    }

    @Override
    public void loadAdditional(CompoundTag nbt) {
        this.cookTicks = nbt.m_128465_("cookTicks");
        this.cureTicks = nbt.m_128451_("cureTicks");
        this.isInsulated = nbt.m_128471_("isInsulated");
        this.needsRecipeUpdate = true;
        super.loadAdditional(nbt);
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        nbt.m_128385_("cookTicks", this.cookTicks);
        nbt.m_128405_("cureTicks", this.cureTicks);
        nbt.m_128379_("isInsulated", this.isInsulated);
        super.m_183515_(nbt);
    }

    @Override
    public void tickTemperature() {
        if (this.temperature != this.targetTemperature && this.targetTemperature <= 0.0f) {
            this.ranOutDueToCalendar();
        }
        super.tickTemperature();
    }

    @Override
    public int getCureTicks() {
        return this.cureTicks;
    }

    @Override
    public void addCureTicks(int ticks) {
        this.cureTicks += ticks;
    }

    @Override
    public void ranOutDueToCalendar() {
        for (int i = 0; i < 4; ++i) {
            this.cookTicks[i] = 0;
        }
    }

    public void spreadHeat() {
        assert (this.f_58857_ != null);
        for (Direction d : Direction.Plane.HORIZONTAL) {
            BlockEntity blockEntity = this.f_58857_.m_7702_(this.m_58899_().m_121945_(d));
            if (!(blockEntity instanceof OvenTopBlockEntity)) continue;
            OvenTopBlockEntity otherOven = (OvenTopBlockEntity)blockEntity;
            otherOven.getCapability(HeatCapability.BLOCK_CAPABILITY).ifPresent(cap -> cap.setTemperatureIfWarmer(this.temperature - 100.0f));
        }
    }

    public void setAndUpdateSlots(int slot) {
        super.setAndUpdateSlots(slot);
        this.singleRecipeUpdate(slot, true);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return Helpers.mightHaveCapability((ItemStack)stack, (Capability)HeatCapability.CAPABILITY);
    }

    public int getSlotStackLimit(int slot) {
        return 1;
    }

    private void updateCaches() {
        for (int slot = 0; slot <= 3; ++slot) {
            this.singleRecipeUpdate(slot, false);
        }
    }

    private void singleRecipeUpdate(int slot, boolean wipe) {
        WrappedHeatingRecipe previous = this.cachedRecipes[slot];
        this.cachedRecipes[slot] = WrappedHeatingRecipe.getRecipe(((ApplianceBlockEntity.ApplianceInventory)this.inventory).getStackInSlot(slot));
        if (wipe && previous != this.cachedRecipes[slot] || this.cachedRecipes[slot] == null) {
            this.cookTicks[slot] = 0;
        }
    }

    public void extinguish() {
        for (int i = 0; i < 3; ++i) {
            this.cookTicks[i] = 0;
            this.cachedRecipes[i] = null;
        }
        this.temperature = 0.0f;
        this.targetTemperature = 0.0f;
        this.targetTemperatureStabilityTicks = 0;
    }

    public void setInsulated(boolean insulated) {
        this.isInsulated = insulated;
    }

    public int getTicksLeft(int slot) {
        assert (this.f_58857_ != null);
        if (this.cookTicks[slot] == 0) {
            return -1;
        }
        if (this.cachedRecipes[slot] == null && this.f_58857_.f_46443_) {
            this.singleRecipeUpdate(slot, true);
        }
        if (this.cachedRecipes[slot] != null) {
            return this.cachedRecipes[slot].duration() - this.cookTicks[slot];
        }
        return -1;
    }

    public static class OvenInventory
    extends ApplianceBlockEntity.ApplianceInventory {
        public OvenInventory(InventoryBlockEntity<?> entity) {
            super(entity, 4);
        }
    }
}

