/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.blockentities;

import com.eerussianguy.firmalife.common.FLHelpers;
import com.eerussianguy.firmalife.common.blockentities.FLBlockEntities;
import com.eerussianguy.firmalife.common.blockentities.QuadPlanterBlockEntity;
import com.eerussianguy.firmalife.common.blockentities.SprinklerBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;

public class HydroponicPlanterBlockEntity
extends QuadPlanterBlockEntity {
    private boolean hasPipe = false;

    public static void hydroponicServerTick(Level level, BlockPos pos, BlockState state, HydroponicPlanterBlockEntity planter) {
        planter.checkForCalendarUpdate();
        planter.checkForLastTickSync();
        if (level.m_46467_() % (long)(80 + pos.m_123343_() % 4) == 0L && planter.isClimateValid()) {
            boolean valid;
            Fluid fluid = SprinklerBlockEntity.searchForFluid(level, pos, Direction.DOWN, false);
            boolean bl = valid = fluid != null;
            if (valid != planter.hasPipe) {
                planter.hasPipe = valid;
                planter.markForSync();
            }
        }
    }

    public HydroponicPlanterBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)FLBlockEntities.HYDROPONIC_PLANTER.get(), pos, state, FLHelpers.blockEntityName("hydroponic_planter"));
    }

    @Override
    public void loadAdditional(CompoundTag nbt) {
        super.loadAdditional(nbt);
        this.hasPipe = nbt.m_128471_("hasPipe");
    }

    @Override
    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128379_("hasPipe", this.hasPipe);
    }

    @Override
    @Nullable
    public Component getInvalidReason() {
        if (!this.hasPipe()) {
            return Component.m_237115_((String)"firmalife.greenhouse.needs_pipe");
        }
        return super.getInvalidReason();
    }

    @Override
    public float getWater() {
        assert (this.f_58857_ != null);
        return this.hasPipe() ? 1.0f : 0.0f;
    }

    public boolean hasPipe() {
        assert (this.f_58857_ != null);
        return this.hasPipe;
    }

    @Override
    public boolean addWater(float amount, @Nullable Direction direction) {
        return false;
    }

    @Override
    public void drainWater(float amount) {
    }
}

