/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.blockentities;

import com.eerussianguy.firmalife.common.FLHelpers;
import com.eerussianguy.firmalife.common.blockentities.FLBlockEntities;
import com.eerussianguy.firmalife.common.blockentities.SimpleItemRecipeBlockEntity;
import com.eerussianguy.firmalife.common.recipes.DryingRecipe;
import com.eerussianguy.firmalife.config.FLConfig;
import java.util.function.Supplier;
import net.dries007.tfc.common.recipes.inventory.ItemStackInventory;
import net.dries007.tfc.util.EnvironmentHelpers;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class DryingMatBlockEntity
extends SimpleItemRecipeBlockEntity<DryingRecipe> {
    public static DryingMatBlockEntity dryingMat(BlockPos pos, BlockState state) {
        return new DryingMatBlockEntity((BlockEntityType<DryingMatBlockEntity>)((BlockEntityType)FLBlockEntities.DRYING_MAT.get()), pos, state, (Supplier<Integer>)FLConfig.SERVER.dryingTicks);
    }

    public static DryingMatBlockEntity solarDrier(BlockPos pos, BlockState state) {
        return new DryingMatBlockEntity((BlockEntityType<DryingMatBlockEntity>)((BlockEntityType)FLBlockEntities.SOLAR_DRIER.get()), pos, state, (Supplier<Integer>)FLConfig.SERVER.solarDryingTicks);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, DryingMatBlockEntity mat) {
        if (mat.needsRecipeUpdate) {
            mat.updateCache();
        }
        if (level.m_46467_() % 60L == 0L && EnvironmentHelpers.isRainingOrSnowing((Level)level, (BlockPos)pos) && level.m_45527_(pos)) {
            mat.resetCounter();
        }
        if (level.m_46467_() % 100L == 0L) {
            AABB bounds = new AABB((double)pos.m_123341_() - 0.2, (double)pos.m_123342_() - 0.2, (double)pos.m_123343_() - 0.2, (double)pos.m_123341_() + 1.2, (double)pos.m_123342_() + 0.3, (double)pos.m_123343_() + 1.2);
            Helpers.gatherAndConsumeItems((Level)level, (AABB)bounds, (IItemHandler)mat.inventory, (int)0, (int)0);
        }
        if (mat.cachedRecipe != null && level.m_46467_() % 20L == 0L) {
            if (!((DryingRecipe)mat.cachedRecipe).matches(new ItemStackInventory(((ItemStackHandler)mat.inventory).getStackInSlot(0)), level)) {
                mat.cachedRecipe = null;
                mat.resetCounter();
            } else if (mat.getTicksLeft() <= 0L) {
                mat.finish();
            }
        }
    }

    public DryingMatBlockEntity(BlockEntityType<DryingMatBlockEntity> type, BlockPos pos, BlockState state, Supplier<Integer> dryTicks) {
        super(type, pos, state, FLHelpers.blockEntityName("drying_mat"), dryTicks);
    }

    @Override
    public void setAndUpdateSlots(int slot) {
        super.setAndUpdateSlots(slot);
        this.markForSync();
        if (slot == 0) {
            this.resetCounter();
        }
    }

    public void ejectItem(Direction d) {
        ItemStack item = ((ItemStackHandler)this.inventory).getStackInSlot(0);
        if (!item.m_41619_()) {
            item = ((ItemStackHandler)this.inventory).extractItem(0, 64, false);
            this.f_58857_.m_7967_((Entity)new ItemEntity(this.f_58857_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5, item, (double)d.m_122429_() * 0.3, 0.2, (double)d.m_122431_() * 0.3));
            this.markForSync();
        }
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        assert (this.f_58857_ != null);
        return DryingRecipe.getRecipe(this.f_58857_, new ItemStackInventory(stack)) != null;
    }

    @Override
    public void updateCache() {
        assert (this.f_58857_ != null);
        this.cachedRecipe = DryingRecipe.getRecipe(this.f_58857_, new ItemStackInventory(this.readStack()));
        this.needsRecipeUpdate = false;
    }
}

