/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.common.blockentities;

import com.eerussianguy.firmalife.common.FLHelpers;
import com.eerussianguy.firmalife.common.blockentities.FLBlockEntities;
import com.eerussianguy.firmalife.common.container.BigBarrelContainer;
import net.dries007.tfc.common.TFCTags;
import net.dries007.tfc.common.blockentities.BarrelInventoryCallback;
import net.dries007.tfc.common.blockentities.InventoryBlockEntity;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.common.capabilities.DelegateFluidHandler;
import net.dries007.tfc.common.capabilities.DelegateItemHandler;
import net.dries007.tfc.common.capabilities.FluidTankCallback;
import net.dries007.tfc.common.capabilities.InventoryFluidTank;
import net.dries007.tfc.common.capabilities.InventoryItemHandler;
import net.dries007.tfc.common.capabilities.PartialFluidHandler;
import net.dries007.tfc.common.capabilities.SidedHandler;
import net.dries007.tfc.common.capabilities.size.ItemSizeManager;
import net.dries007.tfc.common.capabilities.size.Size;
import net.dries007.tfc.common.container.ISlotCallback;
import net.dries007.tfc.common.fluids.FluidHelpers;
import net.dries007.tfc.common.items.BarrelBlockItem;
import net.dries007.tfc.common.recipes.inventory.EmptyInventory;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BigBarrelBlockEntity
extends InventoryBlockEntity<BigBarrelInventory>
implements BarrelInventoryCallback {
    public static final int SLOTS = 38;
    public static final int SLOT_FLUID_CONTAINER_IN = 36;
    public static final int SLOT_FLUID_CONTAINER_OUT = 37;
    public static final int CAPACITY = 80000;
    private final SidedHandler.Builder<IFluidHandler> sidedFluidInventory;

    public BigBarrelBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)FLBlockEntities.BIG_BARREL.get(), pos, state, BigBarrelInventory::new, FLHelpers.blockEntityName("big_barrel"));
        this.sidedFluidInventory = new SidedHandler.Builder((Object)((IFluidHandler)this.inventory));
        this.sidedFluidInventory.on((Object)new PartialFluidHandler((IFluidHandler)this.inventory).insert(), d -> d.m_122434_().m_122479_()).on((Object)new PartialFluidHandler((IFluidHandler)this.inventory).extract(), d -> d.m_122434_().m_122478_());
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        if (slot == 36) {
            return Helpers.mightHaveCapability((ItemStack)stack, (Capability)Capabilities.FLUID_ITEM);
        }
        if (slot == 37) {
            return true;
        }
        return ItemSizeManager.get((ItemStack)stack).getSize(stack).isSmallerThan(Size.VERY_LARGE) && !(stack.m_41720_() instanceof BarrelBlockItem);
    }

    public boolean canModify() {
        return true;
    }

    public void setAndUpdateSlots(int slot) {
        super.setAndUpdateSlots(slot);
        if (slot == 36) {
            this.updateFluidIOSlots();
        }
    }

    public void fluidTankChanged() {
        this.m_6596_();
    }

    private void updateFluidIOSlots() {
        assert (this.f_58857_ != null);
        ItemStack input = ((BigBarrelInventory)this.inventory).getStackInSlot(36);
        if (!input.m_41619_() && ((BigBarrelInventory)this.inventory).getStackInSlot(37).m_41619_()) {
            FluidHelpers.transferBetweenBlockEntityAndItem((ItemStack)input, (BlockEntity)this, (Level)this.f_58857_, (BlockPos)this.f_58858_, (newOriginalStack, newContainerStack) -> {
                if (newContainerStack.m_41619_()) {
                    ((BigBarrelInventory)this.inventory).setStackInSlot(36, ItemStack.f_41583_);
                    ((BigBarrelInventory)this.inventory).setStackInSlot(37, newOriginalStack);
                } else {
                    ((BigBarrelInventory)this.inventory).setStackInSlot(36, newOriginalStack);
                    ((BigBarrelInventory)this.inventory).setStackInSlot(37, newContainerStack);
                }
            });
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == Capabilities.FLUID) {
            return this.sidedFluidInventory.getSidedHandler(side).cast();
        }
        return super.getCapability(cap, side);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int containerId, Inventory inventory, Player player) {
        return BigBarrelContainer.create(this, player.m_150109_(), containerId);
    }

    public static class BigBarrelInventory
    implements EmptyInventory,
    DelegateItemHandler,
    INBTSerializable<CompoundTag>,
    DelegateFluidHandler,
    FluidTankCallback {
        private final InventoryItemHandler inventory;
        private final InventoryFluidTank tank;

        BigBarrelInventory(InventoryBlockEntity<?> inventory) {
            this((BarrelInventoryCallback)inventory);
        }

        BigBarrelInventory(BarrelInventoryCallback inventory) {
            this.inventory = new InventoryItemHandler((ISlotCallback)inventory, 38);
            this.tank = new InventoryFluidTank(80000, stack -> Helpers.isFluid((Fluid)stack.getFluid(), (TagKey)TFCTags.Fluids.USABLE_IN_BARREL), (FluidTankCallback)this);
        }

        public IFluidHandler getFluidHandler() {
            return this.tank;
        }

        public IItemHandlerModifiable getItemHandler() {
            return this.inventory;
        }

        public CompoundTag serializeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128365_("inventory", (Tag)this.inventory.serializeNBT());
            nbt.m_128365_("tank", (Tag)this.tank.writeToNBT(new CompoundTag()));
            return nbt;
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.inventory.deserializeNBT(nbt.m_128469_("inventory"));
            this.tank.readFromNBT(nbt.m_128469_("tank"));
        }
    }
}

