/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.client.render;

import com.eerussianguy.firmalife.common.FLHelpers;
import com.eerussianguy.firmalife.common.blockentities.CompostTumblerBlockEntity;
import com.eerussianguy.firmalife.common.blocks.CompostTumblerBlock;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.rotation.Rotation;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;

public class CompostTumblerBlockEntityRenderer
implements BlockEntityRenderer<CompostTumblerBlockEntity> {
    public static final ResourceLocation CLOSED_MODEL = FLHelpers.identifier("block/compost_tumbler_closed");
    public static final ResourceLocation OPEN_MODEL = FLHelpers.identifier("block/compost_tumbler_open");
    private static final ResourceLocation NORMAL_TEXTURE = Helpers.identifier((String)"block/devices/composter/normal");
    private static final ResourceLocation READY_TEXTURE = Helpers.identifier((String)"block/devices/composter/ready");
    private static final ResourceLocation ROTTEN_TEXTURE = Helpers.identifier((String)"block/devices/composter/rotten");

    public void render(CompostTumblerBlockEntity composter, float partialTicks, PoseStack poseStack, MultiBufferSource buffers, int combinedLight, int combinedOverlay) {
        Level level = composter.m_58904_();
        BlockPos pos = composter.m_58899_();
        BlockState state = composter.m_58900_();
        if (level == null || !(state.m_60734_() instanceof CompostTumblerBlock)) {
            return;
        }
        Direction facing = (Direction)state.m_61143_((Property)CompostTumblerBlock.FACING);
        boolean isRotating = composter.isRotating();
        Rotation rotation = composter.getRotationNode().rotation();
        float angle = isRotating ? (rotation != null ? rotation.angle(partialTicks) : ((float)level.m_46467_() + partialTicks) * 0.1f % ((float)Math.PI * 2)) : 0.0f;
        poseStack.m_85836_();
        poseStack.m_252880_(0.5f, 0.5f, 0.5f);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f - 90.0f * (float)facing.m_122416_()));
        poseStack.m_252880_(-0.5f, -0.5f, -0.5f);
        if (isRotating) {
            poseStack.m_252880_(0.5f, 0.5f, 0.5f);
            poseStack.m_252781_(Axis.f_252403_.m_252961_(-angle));
            poseStack.m_252880_(-0.5f, -0.5f, -0.5f);
        }
        ModelBlockRenderer modelRenderer = Minecraft.m_91087_().m_91289_().m_110937_();
        BakedModel baked = Minecraft.m_91087_().m_91304_().getModel(!isRotating ? OPEN_MODEL : CLOSED_MODEL);
        VertexConsumer buffer = buffers.m_6299_(RenderType.m_110463_());
        if (!isRotating) {
            modelRenderer.tesselateWithAO((BlockAndTintGetter)level, baked, state, pos, poseStack, buffer, true, RandomSource.m_216327_(), (long)combinedLight, combinedOverlay, ModelData.EMPTY, RenderType.m_110463_());
            ResourceLocation texture = NORMAL_TEXTURE;
            if (composter.isRotten()) {
                texture = ROTTEN_TEXTURE;
            } else if (composter.isReady()) {
                texture = READY_TEXTURE;
            }
            TextureAtlasSprite sprite = RenderHelpers.blockTexture((ResourceLocation)texture);
            int total = composter.getTotal();
            float height = 0.0f;
            if (total > 0) {
                height = 8.0f * (float)total / 32.0f;
            } else {
                ItemStack compost;
                IItemHandler inv = (IItemHandler)Helpers.getCapability((ICapabilityProvider)composter, (Capability)Capabilities.ITEM);
                if (inv != null && !(compost = inv.getStackInSlot(0)).m_41619_()) {
                    height = 8.0f * (float)compost.m_41613_() / 3.0f;
                }
            }
            if (height > 0.0f) {
                RenderHelpers.renderTexturedCuboid((PoseStack)poseStack, (VertexConsumer)buffer, (TextureAtlasSprite)sprite, (int)combinedLight, (int)combinedOverlay, (float)0.25f, (float)0.1875f, (float)0.25f, (float)0.75f, (float)((height + 3.0f) / 16.0f), (float)0.9375f);
            }
        } else {
            modelRenderer.renderModel(poseStack.m_85850_(), buffer, state, baked, 1.0f, 1.0f, 1.0f, combinedLight, combinedOverlay, ModelData.EMPTY, RenderType.m_110463_());
        }
        poseStack.m_85849_();
    }
}

