/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.client.model;

import com.eerussianguy.firmalife.client.model.SimpleDynamicBlockModel;
import com.eerussianguy.firmalife.common.FLHelpers;
import com.eerussianguy.firmalife.common.blockentities.FLBlockEntities;
import com.eerussianguy.firmalife.common.blockentities.JarbnetBlockEntity;
import com.eerussianguy.firmalife.common.blocks.JarbnetBlock;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.dries007.tfc.common.items.CandleBlockItem;
import net.dries007.tfc.common.items.JarItem;
import net.dries007.tfc.common.items.JugItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.data.ModelData;

public class JarbnetBlockModel
extends SimpleDynamicBlockModel<JarbnetBlockEntity> {
    public static final ResourceLocation JUG_LOCATION = FLHelpers.identifier("block/jar_jug");
    private static final int[] CANDLE_AMOUNTS = new int[]{3, 1, 2, 2, 3, 1};

    public JarbnetBlockModel(boolean isAmbientOcclusion, boolean isGui3d, boolean isSideLit, ItemOverrides overrides, BakedModel baseModel) {
        super(isAmbientOcclusion, isGui3d, isSideLit, overrides, baseModel);
    }

    @Override
    public void render(JarbnetBlockEntity jarbnet, PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay) {
        if (jarbnet.m_58900_().m_60734_() instanceof JarbnetBlock && jarbnet.m_58904_() != null) {
            int angle;
            Minecraft mc = Minecraft.m_91087_();
            Direction facing = (Direction)jarbnet.m_58900_().m_61143_((Property)JarbnetBlock.FACING);
            switch (facing) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case SOUTH: {
                    int n = 0;
                    break;
                }
                case EAST: {
                    int n = 90;
                    break;
                }
                case WEST: 
                case DOWN: 
                case UP: {
                    int n = 270;
                    break;
                }
                case NORTH: {
                    int n = angle = 180;
                }
            }
            if (((Boolean)jarbnet.m_58900_().m_61143_((Property)JarbnetBlock.OPEN)).booleanValue()) {
                jarbnet.getCapability(Capabilities.ITEM).ifPresent(inv -> {
                    poseStack.m_85836_();
                    poseStack.m_85837_(0.5, 0.5, 0.5);
                    poseStack.m_85841_(0.8f, 0.8f, 0.8f);
                    poseStack.m_252781_(Axis.f_252436_.m_252977_((float)angle));
                    ModelBlockRenderer modelRenderer = mc.m_91289_().m_110937_();
                    for (int i = 0; i < 6; ++i) {
                        Item item = inv.getStackInSlot(i).m_41720_();
                        boolean isJug = item instanceof JugItem;
                        boolean isCandle = item instanceof CandleBlockItem;
                        boolean isJar = item instanceof JarItem;
                        poseStack.m_85836_();
                        int dx = i > 2 ? i - 3 : i;
                        poseStack.m_252880_((float)dx * -0.35f - 0.4f, i > 2 ? -0.53f : 0.02f, -0.65f);
                        if (isCandle) {
                            poseStack.m_252880_(0.3f, 0.0f, 0.0f);
                        }
                        if (item instanceof BlockItem) {
                            BlockItem bi = (BlockItem)item;
                            BlockState state = bi.m_40614_().m_49966_();
                            if (isCandle) {
                                state = (BlockState)state.m_61124_((Property)CandleBlock.f_152790_, (Comparable)Integer.valueOf(CANDLE_AMOUNTS[i]));
                                if (((Boolean)jarbnet.m_58900_().m_61143_((Property)JarbnetBlock.LIT)).booleanValue()) {
                                    state = (BlockState)state.m_61124_((Property)CandleBlock.f_152791_, (Comparable)Boolean.valueOf(true));
                                }
                            }
                            modelRenderer.tesselateWithAO((BlockAndTintGetter)jarbnet.m_58904_(), mc.m_91289_().m_110910_(state), state, jarbnet.m_58899_(), poseStack, buffer, false, RandomSource.m_216327_(), 4L, packedOverlay, ModelData.EMPTY, RenderType.m_110463_());
                        } else if (isJug) {
                            baked = mc.m_91304_().getModel(JUG_LOCATION);
                            modelRenderer.tesselateWithAO((BlockAndTintGetter)jarbnet.m_58904_(), baked, jarbnet.m_58900_(), jarbnet.m_58899_(), poseStack, buffer, false, RandomSource.m_216327_(), 4L, packedOverlay, ModelData.EMPTY, RenderType.m_110463_());
                        } else if (isJar) {
                            poseStack.m_252880_(0.5f, 0.0f, 0.25f);
                            baked = mc.m_91304_().getModel(((JarItem)item).getModel());
                            modelRenderer.tesselateWithAO((BlockAndTintGetter)jarbnet.m_58904_(), baked, jarbnet.m_58900_(), jarbnet.m_58899_(), poseStack, buffer, false, RandomSource.m_216327_(), 4L, packedOverlay, ModelData.EMPTY, RenderType.m_110463_());
                        }
                        poseStack.m_85849_();
                    }
                    poseStack.m_85849_();
                });
            }
        }
    }

    @Override
    public BlockEntityType<JarbnetBlockEntity> type() {
        return (BlockEntityType)FLBlockEntities.JARBNET.get();
    }
}

