/*
 * Decompiled with CFR 0.152.
 */
package com.eerussianguy.firmalife.client.model;

import com.eerussianguy.firmalife.client.model.SimpleDynamicBlockModel;
import com.eerussianguy.firmalife.common.blockentities.FLBlockEntities;
import com.eerussianguy.firmalife.common.blockentities.FoodShelfBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.dries007.tfc.common.capabilities.Capabilities;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.properties.Property;

public class FoodShelfBlockModel
extends SimpleDynamicBlockModel<FoodShelfBlockEntity> {
    public FoodShelfBlockModel(boolean isAmbientOcclusion, boolean isGui3d, boolean isSideLit, ItemOverrides overrides, BakedModel baseModel) {
        super(isAmbientOcclusion, isGui3d, isSideLit, overrides, baseModel);
    }

    @Override
    protected void render(FoodShelfBlockEntity shelf, PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay) {
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        ItemStack stack = shelf.getCapability(Capabilities.ITEM).map(cap -> cap.getStackInSlot(0)).orElse(ItemStack.f_41583_);
        if (stack.m_41619_() || shelf.m_58904_() == null) {
            return;
        }
        int totalDraws = Math.min(stack.m_41613_(), 16);
        int maxStackSize = Mth.m_14045_((int)stack.m_41720_().getMaxStackSize(stack), (int)1, (int)64);
        float filled = (float)stack.m_41613_() / (float)maxStackSize;
        Direction facing = (Direction)shelf.m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_);
        int angle = switch (facing) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.SOUTH -> 0;
            case Direction.EAST -> 90;
            case Direction.WEST, Direction.DOWN, Direction.UP -> 270;
            case Direction.NORTH -> 180;
        };
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.5, 0.5);
        poseStack.m_85841_(0.45f, 0.45f, 0.45f);
        poseStack.m_252781_(Axis.f_252436_.m_252977_((float)angle));
        int currentDraws = 0;
        for (int i = 0; i < 4 && !((float)currentDraws >= filled * (float)totalDraws); ++i) {
            poseStack.m_85836_();
            poseStack.m_252880_(-0.5f, -0.35f, -1.1f);
            poseStack.m_252880_(i % 2 == 0 ? 0.45f : -0.45f, i < 2 ? 0.45f : -0.45f, 0.0f);
            for (int j = 0; j < 4 && !((float)currentDraws >= filled * (float)totalDraws); ++j) {
                ++currentDraws;
                poseStack.m_252880_(0.0f, 0.0f, 0.175f);
                BakedModel model = itemRenderer.m_174264_(stack, shelf.m_58904_(), null, 42);
                poseStack.m_85836_();
                poseStack.m_85841_(0.9f, 0.9f, 0.9f);
                itemRenderer.m_115189_(model, stack, packedLight, packedOverlay, poseStack, buffer);
                poseStack.m_85849_();
            }
            poseStack.m_85849_();
        }
        poseStack.m_85849_();
    }

    @Override
    protected BlockEntityType<FoodShelfBlockEntity> type() {
        return (BlockEntityType)FLBlockEntities.FOOD_SHELF.get();
    }
}

