/*
 * Decompiled with CFR 0.152.
 */
package com.alekiponi.firmaciv.events;

import com.alekiponi.alekiships.common.block.AlekiShipsBlocks;
import com.alekiponi.alekiships.common.block.CleatBlock;
import com.alekiponi.alekiships.common.block.OarlockBlock;
import com.alekiponi.alekiships.common.entity.AlekiShipsEntities;
import com.alekiponi.alekiships.common.item.AlekiShipsItems;
import com.alekiponi.firmaciv.common.block.FirmacivBlocks;
import com.alekiponi.firmaciv.common.entity.FirmacivEntities;
import com.alekiponi.firmaciv.common.item.AbstractNavItem;
import com.alekiponi.firmaciv.events.config.FirmacivConfig;
import com.alekiponi.firmaciv.util.FirmacivCommands;
import com.alekiponi.firmaciv.util.TFCWood;
import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.MissingMappingsEvent;

@Mod.EventBusSubscriber(modid="firmaciv", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class ForgeEventHandler {
    @SubscribeEvent
    public static void onWorldLoad(LevelEvent.Load event) {
        LevelAccessor levelAccessor = event.getLevel();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)levelAccessor;
        ((GameRules.BooleanValue)level.m_46469_().m_46170_(GameRules.f_46145_)).m_46246_(((Boolean)FirmacivConfig.SERVER.forceReducedDebugInfo.get()).booleanValue(), level.m_7654_());
        if (level.m_6042_().f_63858_()) {
            AbstractNavItem.updateScales(level);
        }
    }

    @SubscribeEvent
    public static void registerCommands(RegisterCommandsEvent event) {
        FirmacivCommands.registerCommands((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext());
    }

    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        if (!(event.getTarget() instanceof Boat)) {
            return;
        }
        if (!((Boolean)FirmacivConfig.SERVER.disableVanillaBoatFunctionality.get()).booleanValue()) {
            return;
        }
        event.setCancellationResult(InteractionResult.FAIL);
        event.setCanceled(true);
    }

    @SubscribeEvent
    public static void onMissingMapping(MissingMappingsEvent event) {
        for (MissingMappingsEvent.Mapping entityTypeMapping : event.getMappings(Registries.f_256939_, "firmaciv")) {
            String entityName = entityTypeMapping.getKey().m_135815_();
            if (!entityName.equals("compartment_tfcchest")) continue;
            entityTypeMapping.remap((Object)((EntityType)FirmacivEntities.TFC_CHEST_COMPARTMENT_ENTITY.get()));
        }
        for (MissingMappingsEvent.Mapping blockMapping : event.getMappings(Registries.f_256747_, "firmaciv")) {
            String blockName = blockMapping.getKey().m_135815_();
            for (TFCWood tfcWood : TFCWood.values()) {
                if (blockName.equals("wood/watercraft_frame_angled/" + tfcWood.m_7912_())) {
                    blockMapping.remap((Object)((Block)FirmacivBlocks.WOODEN_BOAT_FRAME_ANGLED.get(tfcWood).get()));
                }
                if (!blockName.equals("wood/watercraft_frame_flat/" + tfcWood.m_7912_())) continue;
                blockMapping.remap((Object)((Block)FirmacivBlocks.WOODEN_BOAT_FRAME_FLAT.get(tfcWood).get()));
            }
        }
        ForgeEventHandler.remapToAlekiShips(event);
    }

    private static void remapToAlekiShips(MissingMappingsEvent event) {
        for (MissingMappingsEvent.Mapping entityTypeMapping : event.getMappings(Registries.f_256939_, "firmaciv")) {
            String entityName = entityTypeMapping.getKey().m_135815_();
            if (entityName.equals("compartment_empty")) {
                entityTypeMapping.remap((Object)((EntityType)AlekiShipsEntities.EMPTY_COMPARTMENT_ENTITY.get()));
            }
            if (entityName.equals("compartment_block")) {
                entityTypeMapping.remap((Object)((EntityType)AlekiShipsEntities.BLOCK_COMPARTMENT_ENTITY.get()));
            }
            if (entityName.equals("compartment_barrel")) {
                entityTypeMapping.remap((Object)((EntityType)AlekiShipsEntities.BARREL_COMPARTMENT_ENTITY.get()));
            }
            if (entityName.equals("compartment_chest")) {
                entityTypeMapping.remap((Object)((EntityType)AlekiShipsEntities.CHEST_COMPARTMENT_ENTITY.get()));
            }
            if (entityName.equals("compartment_ender_chest")) {
                entityTypeMapping.remap((Object)((EntityType)AlekiShipsEntities.ENDER_CHEST_COMPARTMENT_ENTITY.get()));
            }
            if (entityName.equals("compartment_shulker_box")) {
                entityTypeMapping.remap((Object)((EntityType)AlekiShipsEntities.SHULKER_BOX_COMPARTMENT_ENTITY.get()));
            }
            if (entityName.equals("compartment_furnace")) {
                entityTypeMapping.remap((Object)((EntityType)AlekiShipsEntities.FURNACE_COMPARTMENT_ENTITY.get()));
            }
            if (entityName.equals("compartment_blast_furnace")) {
                entityTypeMapping.remap((Object)((EntityType)AlekiShipsEntities.BLAST_FURNACE_COMPARTMENT_ENTITY.get()));
            }
            if (entityName.equals("compartment_smoker")) {
                entityTypeMapping.remap((Object)((EntityType)AlekiShipsEntities.SMOKER_COMPARTMENT_ENTITY.get()));
            }
            if (entityName.equals("compartment_workbench")) {
                entityTypeMapping.remap((Object)((EntityType)AlekiShipsEntities.WORKBENCH_COMPARTMENT_ENTITY.get()));
            }
            if (entityName.equals("compartment_stonecutter")) {
                entityTypeMapping.remap((Object)((EntityType)AlekiShipsEntities.STONECUTTER_COMPARTMENT_ENTITY.get()));
            }
            if (entityName.equals("compartment_cartography_table")) {
                entityTypeMapping.remap((Object)((EntityType)AlekiShipsEntities.CARTOGRAPHY_TABLE_COMPARTMENT_ENTITY.get()));
            }
            if (entityName.equals("compartment_smithing_table")) {
                entityTypeMapping.remap((Object)((EntityType)AlekiShipsEntities.SMITHING_TABLE_COMPARTMENT_ENTITY.get()));
            }
            if (entityName.equals("compartment_grindstone")) {
                entityTypeMapping.remap((Object)((EntityType)AlekiShipsEntities.GRINDSTONE_COMPARTMENT_ENTITY.get()));
            }
            if (entityName.equals("compartment_loom")) {
                entityTypeMapping.remap((Object)((EntityType)AlekiShipsEntities.LOOM_COMPARTMENT_ENTITY.get()));
            }
            if (entityName.equals("compartment_anvil")) {
                entityTypeMapping.remap((Object)((EntityType)AlekiShipsEntities.BLOCK_COMPARTMENT_ENTITY.get()));
            }
            if (entityName.equals("vehicle_part_boat")) {
                entityTypeMapping.remap((Object)((EntityType)AlekiShipsEntities.VEHICLE_PART.get()));
            }
            if (entityName.equals("vehicle_construction")) {
                entityTypeMapping.remap((Object)((EntityType)AlekiShipsEntities.CONSTRUCTION_ENTITY.get()));
            }
            if (entityName.equals("vehicle_part_construction")) {
                entityTypeMapping.remap((Object)((EntityType)AlekiShipsEntities.VEHICLE_PART.get()));
            }
            if (entityName.equals("vehicle_cleat")) {
                entityTypeMapping.remap((Object)((EntityType)AlekiShipsEntities.VEHICLE_CLEAT_ENTITY.get()));
            }
            if (entityName.equals("vehicle_collider")) {
                entityTypeMapping.remap((Object)((EntityType)AlekiShipsEntities.VEHICLE_COLLIDER_ENTITY.get()));
            }
            if (entityName.equals("vehicle_switch_sail")) {
                entityTypeMapping.remap((Object)((EntityType)AlekiShipsEntities.SAIL_SWITCH_ENTITY.get()));
            }
            if (entityName.equals("vehicle_anchor")) {
                entityTypeMapping.remap((Object)((EntityType)AlekiShipsEntities.ANCHOR_ENTITY.get()));
            }
            if (entityName.equals("vehicle_switch_windlass")) {
                entityTypeMapping.remap((Object)((EntityType)AlekiShipsEntities.WINDLASS_SWITCH_ENTITY.get()));
            }
            if (entityName.equals("cannonball")) {
                entityTypeMapping.remap((Object)((EntityType)AlekiShipsEntities.CANNONBALL_ENTITY.get()));
            }
            if (entityName.equals("cannon")) {
                entityTypeMapping.remap((Object)((EntityType)AlekiShipsEntities.CANNON_ENTITY.get()));
            }
            if (!entityName.equals("vehicle_mast")) continue;
            entityTypeMapping.remap((Object)((EntityType)AlekiShipsEntities.MAST_ENTITY.get()));
        }
        for (MissingMappingsEvent.Mapping blockMapping : event.getMappings(Registries.f_256747_, "firmaciv")) {
            String blockName = blockMapping.getKey().m_135815_();
            if (blockName.equals("oarlock")) {
                blockMapping.remap((Object)((Block)AlekiShipsBlocks.OARLOCK.get()));
            }
            if (!blockName.equals("cleat")) continue;
            blockMapping.remap((Object)((Block)AlekiShipsBlocks.CLEAT.get()));
        }
        for (MissingMappingsEvent.Mapping itemMapping : event.getMappings(Registries.f_256913_, "firmaciv")) {
            String itemName = itemMapping.getKey().m_135815_();
            if (itemName.equals("cannonball")) {
                itemMapping.remap((Object)((Item)AlekiShipsItems.CANNONBALL.get()));
            }
            if (itemName.equals("cannon")) {
                itemMapping.remap((Object)((Item)AlekiShipsItems.CANNON.get()));
            }
            if (itemName.equals("oar")) {
                itemMapping.remap((Object)((Item)AlekiShipsItems.OAR.get()));
            }
            if (itemName.equals("anchor")) {
                itemMapping.remap((Object)((Item)AlekiShipsItems.ANCHOR.get()));
            }
            if (itemName.equals("oarlock")) {
                itemMapping.remap((Object)((OarlockBlock)AlekiShipsBlocks.OARLOCK.get()).m_5456_());
            }
            if (!itemName.equals("cleat")) continue;
            itemMapping.remap((Object)((CleatBlock)AlekiShipsBlocks.CLEAT.get()).m_5456_());
        }
    }
}

