/*
 * Decompiled with CFR 0.152.
 */
package com.alekiponi.firmaciv.events;

import com.alekiponi.firmaciv.Firmaciv;
import com.alekiponi.firmaciv.common.block.CanoeComponentBlock;
import com.alekiponi.firmaciv.common.blockentity.CanoeComponentBlockEntity;
import com.alekiponi.firmaciv.events.config.FirmacivConfig;
import com.alekiponi.firmaciv.util.FirmacivTags;
import net.dries007.tfc.util.events.StartFireEvent;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="firmaciv", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class BlockEventHandler {
    private BlockEventHandler() {
    }

    @SubscribeEvent
    public static void registerFireStarterEvents(StartFireEvent event) {
        BlockEntity blockEntity;
        if (event.getState().m_204336_(FirmacivTags.Blocks.CANOE_COMPONENT_BLOCKS) && (Integer)event.getState().m_61143_((Property)CanoeComponentBlock.CANOE_CARVED) == 11 && (blockEntity = event.getPlayer().m_9236_().m_7702_(event.getPos())) instanceof CanoeComponentBlockEntity) {
            CanoeComponentBlockEntity ccBlockEntity = (CanoeComponentBlockEntity)blockEntity;
            ccBlockEntity.light();
        }
    }

    @SubscribeEvent
    public static void registerToolModificationEvents(BlockEvent.BlockToolModificationEvent event) {
        if (event.getToolAction() == ToolActions.AXE_STRIP && (event.getState().m_204336_(FirmacivTags.Blocks.CAN_MAKE_CANOE) || !((Boolean)FirmacivConfig.SERVER.canoeWoodRestriction.get()).booleanValue() && event.getState().m_204336_(FirmacivTags.Blocks.CAN_MAKE_CANOE_UNRESTRICTED)) && event.getPlayer() != null && event.getPlayer().m_21120_(event.getPlayer().m_7655_()).m_204117_(FirmacivTags.Items.SAWS) && ((Direction.Axis)event.getState().m_61143_((Property)BlockStateProperties.f_61365_)).m_122479_()) {
            BlockEventHandler.convertLogToCanoeComponent(event);
        }
        if (event.getToolAction() == ToolActions.AXE_STRIP && event.getState().m_204336_(FirmacivTags.Blocks.CANOE_COMPONENT_BLOCKS) && ((Direction.Axis)event.getState().m_61143_((Property)BlockStateProperties.f_61365_)).m_122479_()) {
            BlockEventHandler.processCanoeComponent(event);
        }
    }

    private static void processCanoeComponent(BlockEvent.BlockToolModificationEvent event) {
        Block canoeComponentBlock = event.getState().m_60734_();
        BlockState canoeComponentBlockState = event.getState();
        BlockPos thisBlockPos = event.getPos();
        LevelAccessor world = event.getLevel();
        Direction.Axis axis = (Direction.Axis)event.getState().m_61143_(CanoeComponentBlock.AXIS);
        int nextCanoeCarvedState = (Integer)event.getState().m_61143_((Property)CanoeComponentBlock.CANOE_CARVED) + 1;
        if ((Integer)canoeComponentBlockState.m_61143_((Property)CanoeComponentBlock.CANOE_CARVED) < 5 && event.getPlayer() != null && event.getPlayer().m_21120_(event.getPlayer().m_7655_()).m_204117_(FirmacivTags.Items.SAWS)) {
            event.getPlayer().m_6674_(event.getPlayer().m_7655_());
            world.m_7731_(thisBlockPos, (BlockState)event.getState().m_61124_((Property)CanoeComponentBlock.CANOE_CARVED, (Comparable)Integer.valueOf(nextCanoeCarvedState)), 2);
            event.getPlayer().m_9236_().m_142052_(thisBlockPos, canoeComponentBlockState);
            event.getPlayer().m_21120_(event.getContext().m_43724_()).m_41780_();
            world.m_5594_(event.getPlayer(), thisBlockPos, SoundEvents.f_11688_, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (nextCanoeCarvedState == 5) {
                Block.m_49892_((BlockState)canoeComponentBlockState, (LevelAccessor)world, (BlockPos)thisBlockPos.m_7494_(), null);
            }
        } else if ((Integer)canoeComponentBlockState.m_61143_((Property)CanoeComponentBlock.CANOE_CARVED) >= 5 && (Integer)canoeComponentBlockState.m_61143_((Property)CanoeComponentBlock.CANOE_CARVED) < 11 && event.getPlayer() != null && event.getPlayer().m_21120_(event.getPlayer().m_7655_()).m_204117_(FirmacivTags.Items.AXES)) {
            event.getPlayer().m_6674_(event.getPlayer().m_7655_());
            BlockPos blockPos1 = thisBlockPos.m_5487_(axis, -2);
            boolean flag = false;
            int row = 0;
            for (int i = -2; i <= 2; ++i) {
                blockPos1 = thisBlockPos.m_5487_(axis, i);
                if (world.m_8055_(blockPos1).m_60713_(canoeComponentBlock) && (Integer)world.m_8055_(blockPos1).m_61143_((Property)CanoeComponentBlock.CANOE_CARVED) >= 5) {
                    flag = ++row >= 3;
                    continue;
                }
                row = 0;
            }
            if (flag) {
                world.m_7731_(thisBlockPos, (BlockState)event.getState().m_61124_((Property)CanoeComponentBlock.CANOE_CARVED, (Comparable)Integer.valueOf(nextCanoeCarvedState)), 2);
                event.getPlayer().m_9236_().m_142052_(thisBlockPos, canoeComponentBlockState);
                event.getPlayer().m_21120_(event.getContext().m_43724_()).m_41780_();
                world.m_5594_(event.getPlayer(), thisBlockPos, SoundEvents.f_11688_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    private static void convertLogToCanoeComponent(BlockEvent.BlockToolModificationEvent event) {
        Block block = event.getState().m_60734_();
        if (!(block instanceof RotatedPillarBlock)) {
            return;
        }
        RotatedPillarBlock strippedLogBlock = (RotatedPillarBlock)block;
        BlockPos thisBlockPos = event.getPos();
        LevelAccessor world = event.getLevel();
        Level level = event.getPlayer().m_9236_();
        if (CanoeComponentBlock.isValidCanoeShape(world, strippedLogBlock, thisBlockPos)) {
            world.m_5594_(event.getPlayer(), thisBlockPos, SoundEvents.f_11688_, SoundSource.BLOCKS, 1.0f, 1.0f);
            event.getPlayer().m_6674_(event.getPlayer().m_7655_());
            event.getPlayer().m_9236_().m_142052_(thisBlockPos, event.getState());
            CanoeComponentBlock canoeComponentBlock = CanoeComponentBlock.getCanoeComponent(strippedLogBlock);
            if (canoeComponentBlock == null) {
                Firmaciv.LOGGER.warn("{} does not map to a canoe component block!", (Object)strippedLogBlock);
                return;
            }
            canoeComponentBlock.m_49966_().m_61124_(CanoeComponentBlock.AXIS, (Comparable)Direction.Axis.Z);
            Direction.Axis axis = (Direction.Axis)event.getState().m_61143_(CanoeComponentBlock.AXIS);
            world.m_7731_(thisBlockPos, CanoeComponentBlock.getStateForPlacement(level, strippedLogBlock, thisBlockPos), 2);
            BlockPos blockPos1 = thisBlockPos.m_5487_(axis, 1);
            BlockPos blockPos2 = thisBlockPos.m_5487_(axis, -1);
            if (world.m_8055_(blockPos1).m_60713_((Block)canoeComponentBlock) && world.m_8055_(blockPos2).m_60713_((Block)canoeComponentBlock)) {
                CanoeComponentBlock.setEndPieces(event.getPlayer().m_9236_(), thisBlockPos, (Block)canoeComponentBlock, true);
                CanoeComponentBlock.setEndPieces(event.getPlayer().m_9236_(), thisBlockPos.m_5487_(axis, -1), (Block)canoeComponentBlock, false);
            } else if (level.m_8055_(blockPos1).m_60713_((Block)canoeComponentBlock)) {
                CanoeComponentBlock.setEndPieces(level, blockPos1, (Block)canoeComponentBlock, true);
            } else {
                CanoeComponentBlock.setEndPieces(level, blockPos2, (Block)canoeComponentBlock, false);
            }
        }
    }
}

