/*
 * Decompiled with CFR 0.152.
 */
package com.alekiponi.firmaciv.compat.jei.transfer;

import com.alekiponi.firmaciv.common.menu.BarrelCompartmentMenu;
import com.alekiponi.firmaciv.common.menu.FirmacivMenus;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandlerHelper;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import org.jetbrains.annotations.Nullable;

public class BarrelTransferInfo<R>
implements IRecipeTransferInfo<BarrelCompartmentMenu, R> {
    private final IRecipeTransferHandlerHelper transferHelper;
    private final RecipeType<R> recipeType;

    public BarrelTransferInfo(IRecipeTransferHandlerHelper transferHelper, RecipeType<R> recipeType) {
        this.transferHelper = transferHelper;
        this.recipeType = recipeType;
    }

    public Class<? extends BarrelCompartmentMenu> getContainerClass() {
        return BarrelCompartmentMenu.class;
    }

    public Optional<MenuType<BarrelCompartmentMenu>> getMenuType() {
        return Optional.of((MenuType)FirmacivMenus.BARREL_COMPARTMENT_MENU.get());
    }

    public RecipeType<R> getRecipeType() {
        return this.recipeType;
    }

    public boolean canHandle(BarrelCompartmentMenu container, R recipe) {
        return container.getBarrelCompartment().canModify();
    }

    @Nullable
    public IRecipeTransferError getHandlingError(BarrelCompartmentMenu container, R recipe) {
        return this.transferHelper.createUserErrorWithTooltip((Component)Component.m_237115_((String)"firmaciv.jei.transfer.error.barrel_sealed"));
    }

    public List<Slot> getRecipeSlots(BarrelCompartmentMenu container, R recipe) {
        return List.of(container.m_38853_(2));
    }

    public List<Slot> getInventorySlots(BarrelCompartmentMenu container, R recipe) {
        return IntStream.range(3, 39).mapToObj(arg_0 -> ((BarrelCompartmentMenu)container).m_38853_(arg_0)).collect(Collectors.toList());
    }
}

