/*
 * Decompiled with CFR 0.152.
 */
package com.alekiponi.firmaciv.common.entity.compartment;

import com.alekiponi.alekiships.common.entity.vehiclehelper.CompartmentType;
import com.alekiponi.alekiships.common.entity.vehiclehelper.compartment.AbstractCompartmentEntity;
import com.alekiponi.alekiships.common.entity.vehiclehelper.compartment.BlockCompartment;
import com.alekiponi.alekiships.common.entity.vehiclehelper.compartment.CompartmentCloneable;
import com.alekiponi.alekiships.common.entity.vehiclehelper.compartment.SimpleBlockMenuCompartment;
import com.alekiponi.alekiships.util.CommonHelper;
import com.alekiponi.firmaciv.common.menu.LargeVesselCompartmentMenu;
import javax.annotation.Nullable;
import net.dries007.tfc.client.TFCSounds;
import net.dries007.tfc.common.blocks.LargeVesselBlock;
import net.dries007.tfc.common.capabilities.PartialItemHandler;
import net.dries007.tfc.common.capabilities.SidedHandler;
import net.dries007.tfc.common.capabilities.food.FoodCapability;
import net.dries007.tfc.common.capabilities.food.FoodTrait;
import net.dries007.tfc.common.capabilities.food.FoodTraits;
import net.dries007.tfc.common.capabilities.size.ItemSizeManager;
import net.dries007.tfc.common.capabilities.size.Size;
import net.dries007.tfc.config.TFCConfig;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuConstructor;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public class LargeVesselCompartmentEntity
extends AbstractCompartmentEntity
implements BlockCompartment,
CompartmentCloneable,
SimpleBlockMenuCompartment,
MenuConstructor,
Container {
    private static final EntityDataAccessor<BlockState> DATA_ID_DISPLAY_BLOCK = SynchedEntityData.m_135353_(LargeVesselCompartmentEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135034_);
    private final VesselInventory inventory = new VesselInventory(this);
    private final SidedHandler.Builder<IItemHandler> sidedInventory = new SidedHandler.Builder((Object)this.inventory);
    private final NonNullList<ItemStack> itemStacks = NonNullList.m_122780_((int)9, (Object)ItemStack.f_41583_);

    public LargeVesselCompartmentEntity(CompartmentType<? extends LargeVesselCompartmentEntity> compartmentType, Level level) {
        super(compartmentType, level);
        if (((Boolean)TFCConfig.SERVER.largeVesselEnableAutomation.get()).booleanValue()) {
            this.sidedInventory.on((Object)new PartialItemHandler((IItemHandlerModifiable)this.inventory).insert(new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8}), d -> d != Direction.DOWN);
            this.sidedInventory.on((Object)new PartialItemHandler((IItemHandlerModifiable)this.inventory).extract(new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8}), new Direction[]{Direction.DOWN});
        }
    }

    public LargeVesselCompartmentEntity(CompartmentType<? extends LargeVesselCompartmentEntity> compartmentType, Level level, ItemStack itemStack) {
        this(compartmentType, level);
        CompoundTag blockEntityTag;
        Item item = itemStack.m_41720_();
        if (!(item instanceof BlockItem)) {
            throw new IllegalArgumentException("Cannot construct a Vessel compartment from something that isn't a block");
        }
        BlockItem blockItem = (BlockItem)item;
        this.setDisplayBlockState(blockItem.m_40614_().m_49966_());
        if (itemStack.m_41788_()) {
            this.m_6593_(itemStack.m_41786_());
        }
        if ((blockEntityTag = BlockItem.m_186336_((ItemStack)itemStack)) != null) {
            this.readContents(blockEntityTag);
            this.setDisplayBlockState((BlockState)this.getDisplayBlockState().m_61124_((Property)LargeVesselBlock.SEALED, (Comparable)Boolean.valueOf(true)));
        }
    }

    public static void toggleSeal(LargeVesselCompartmentEntity vesselCompartment) {
        boolean previousSealed = vesselCompartment.isSealed();
        if (previousSealed) {
            vesselCompartment.onUnseal();
        } else {
            vesselCompartment.onSeal();
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ID_DISPLAY_BLOCK, (Object)Blocks.f_50016_.m_49966_());
    }

    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        if (player.m_6144_()) {
            LargeVesselCompartmentEntity.toggleSeal(this);
            return InteractionResult.SUCCESS;
        }
        if (!this.m_9236_().f_46443_ && player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)this.getMenuProvider(), friendlyByteBuf -> friendlyByteBuf.m_130130_(this.m_19879_()));
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    protected void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        this.saveContents(compoundTag);
        BlockCompartment.saveBlockstate((BlockCompartment)this, (CompoundTag)compoundTag);
    }

    protected void saveContents(CompoundTag compoundTag) {
        compoundTag.m_128365_("inventory", (Tag)this.inventory.serializeNBT());
    }

    protected void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.readContents(compoundTag);
        BlockCompartment.readBlockstate((BlockCompartment)this, (CompoundTag)compoundTag);
    }

    protected void readContents(CompoundTag compoundTag) {
        this.inventory.deserializeNBT(compoundTag.m_128469_("inventory"));
    }

    protected ItemStack getDropStack() {
        ItemStack dropStack = new ItemStack((ItemLike)this.getDisplayBlockState().m_60734_());
        if (!this.isSealed()) {
            return dropStack;
        }
        CompoundTag compoundTag = new CompoundTag();
        this.saveContents(compoundTag);
        if (!compoundTag.m_128456_()) {
            dropStack.m_41700_("BlockEntityTag", (Tag)compoundTag);
        }
        return dropStack;
    }

    protected void destroy(DamageSource damageSource) {
        if (this.isSealed()) {
            super.destroy(damageSource);
            return;
        }
        CommonHelper.dropContents((Level)this.m_9236_(), (double)this.m_20185_(), (double)CommonHelper.maxHeightOfCollidableEntities((Entity)this), (double)this.m_20189_(), (Container)this);
        super.destroy(damageSource);
    }

    @Nullable
    public ItemStack m_142340_() {
        return new ItemStack((ItemLike)this.getDisplayBlockState().m_60734_());
    }

    protected void onBreak() {
        BlockCompartment.playBreakSound((BlockCompartment)this);
    }

    protected void onPlaced() {
        BlockCompartment.playPlaceSound((BlockCompartment)this);
    }

    protected void onHurt(DamageSource damageSource) {
        BlockCompartment.playHitSound((BlockCompartment)this);
    }

    public BlockState getDisplayBlockState() {
        return (BlockState)this.f_19804_.m_135370_(DATA_ID_DISPLAY_BLOCK);
    }

    public void setDisplayBlockState(BlockState blockState) {
        this.f_19804_.m_135381_(DATA_ID_DISPLAY_BLOCK, (Object)blockState);
    }

    public final boolean isSealed() {
        return (Boolean)this.getDisplayBlockState().m_61143_((Property)LargeVesselBlock.SEALED);
    }

    public void onUnseal() {
        for (int slotIndex = 0; slotIndex < 9; ++slotIndex) {
            this.m_6836_(slotIndex, FoodCapability.removeTrait((ItemStack)this.m_8020_(slotIndex).m_41777_(), (FoodTrait)FoodTraits.PRESERVED));
        }
        this.setDisplayBlockState((BlockState)this.getDisplayBlockState().m_61124_((Property)LargeVesselBlock.SEALED, (Comparable)Boolean.valueOf(false)));
        this.playSound((SoundEvent)TFCSounds.OPEN_VESSEL.get(), SoundSource.BLOCKS, 1.0f + this.f_19796_.m_188501_(), this.f_19796_.m_188501_() + 0.7f + 0.3f);
    }

    public void onSeal() {
        for (int slotIndex = 0; slotIndex < 9; ++slotIndex) {
            this.m_6836_(slotIndex, FoodCapability.applyTrait((ItemStack)this.m_8020_(slotIndex).m_41777_(), (FoodTrait)FoodTraits.PRESERVED));
        }
        this.setDisplayBlockState((BlockState)this.getDisplayBlockState().m_61124_((Property)LargeVesselBlock.SEALED, (Comparable)Boolean.valueOf(true)));
        this.playSound((SoundEvent)TFCSounds.CLOSE_VESSEL.get(), SoundSource.BLOCKS, 1.0f + this.f_19796_.m_188501_(), this.f_19796_.m_188501_() + 0.7f + 0.3f);
    }

    public final CompoundTag saveForItemStack() {
        CompoundTag compoundTag = new CompoundTag();
        this.saveContents(compoundTag);
        if (this.m_8077_()) {
            compoundTag.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.m_7770_()));
        }
        return compoundTag;
    }

    @Nullable
    public MenuProvider getMenuProvider() {
        return new SimpleMenuProvider((MenuConstructor)this, this.m_5446_());
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player player) {
        return new LargeVesselCompartmentMenu(id, playerInventory, this);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (this.m_6084_() && capability == ForgeCapabilities.ITEM_HANDLER) {
            return this.sidedInventory.getSidedHandler(facing).cast();
        }
        return super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.sidedInventory.invalidate();
    }

    public void reviveCaps() {
        super.reviveCaps();
        if (((Boolean)TFCConfig.SERVER.largeVesselEnableAutomation.get()).booleanValue()) {
            this.sidedInventory.on((Object)new PartialItemHandler((IItemHandlerModifiable)this.inventory).insert(new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8}), d -> d != Direction.DOWN);
            this.sidedInventory.on((Object)new PartialItemHandler((IItemHandlerModifiable)this.inventory).extract(new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8}), new Direction[]{Direction.DOWN});
        }
    }

    public final int m_6643_() {
        return this.itemStacks.size();
    }

    public final boolean m_7983_() {
        return this.itemStacks.stream().allMatch(ItemStack::m_41619_);
    }

    public final ItemStack m_8020_(int slotIndex) {
        return (ItemStack)this.itemStacks.get(slotIndex);
    }

    public final ItemStack m_7407_(int slotIndex, int amount) {
        return ContainerHelper.m_18969_(this.itemStacks, (int)slotIndex, (int)amount);
    }

    public final ItemStack m_8016_(int slotIndex) {
        return ContainerHelper.m_18966_(this.itemStacks, (int)slotIndex);
    }

    public final void m_6836_(int slotIndex, ItemStack itemStack) {
        this.itemStacks.set(slotIndex, (Object)itemStack);
    }

    public void m_6596_() {
    }

    public boolean m_6542_(Player player) {
        return !this.m_213877_() && this.m_20182_().m_82509_((Position)player.m_20182_(), 8.0);
    }

    public final void m_6211_() {
        this.itemStacks.clear();
    }

    public static class VesselInventory
    extends InvWrapper
    implements INBTSerializable<CompoundTag> {
        private final LargeVesselCompartmentEntity vesselCompartment;

        public VesselInventory(LargeVesselCompartmentEntity vesselCompartment) {
            super((Container)vesselCompartment);
            this.vesselCompartment = vesselCompartment;
        }

        @NotNull
        public ItemStack insertItem(int slotIndex, ItemStack itemStack, boolean simulate) {
            return this.canModify() ? super.insertItem(slotIndex, itemStack, simulate) : itemStack;
        }

        @NotNull
        public ItemStack extractItem(int slotIndex, int amount, boolean simulate) {
            return this.canModify() ? super.extractItem(slotIndex, amount, simulate) : ItemStack.f_41583_;
        }

        public boolean isItemValid(int slotIndex, ItemStack itemStack) {
            return this.canModify() && ItemSizeManager.get((ItemStack)itemStack).getSize(itemStack).isSmallerThan(Size.LARGE) && super.isItemValid(slotIndex, itemStack);
        }

        public CompoundTag serializeNBT() {
            CompoundTag compoundTag = new CompoundTag();
            ListTag nbtTagList = new ListTag();
            for (int slotIndex = 0; slotIndex < this.vesselCompartment.m_6643_(); ++slotIndex) {
                ItemStack slotStack = this.vesselCompartment.m_8020_(slotIndex);
                if (slotStack.m_41619_()) continue;
                CompoundTag itemTag = new CompoundTag();
                itemTag.m_128405_("Slot", slotIndex);
                slotStack.m_41739_(itemTag);
                nbtTagList.add((Object)itemTag);
            }
            compoundTag.m_128365_("Items", (Tag)nbtTagList);
            compoundTag.m_128405_("Size", this.vesselCompartment.m_6643_());
            return compoundTag;
        }

        public void deserializeNBT(CompoundTag compoundTag) {
            ListTag tagList = compoundTag.m_128437_("Items", 10);
            for (int i = 0; i < tagList.size(); ++i) {
                CompoundTag itemTags = tagList.m_128728_(i);
                int slotIndex = itemTags.m_128451_("Slot");
                if (slotIndex < 0 || slotIndex >= this.vesselCompartment.m_6643_()) continue;
                this.vesselCompartment.m_6836_(slotIndex, ItemStack.m_41712_((CompoundTag)itemTags));
            }
        }

        private boolean canModify() {
            return !this.vesselCompartment.isSealed();
        }
    }
}

