/*
 * Decompiled with CFR 0.152.
 */
package com.alekiponi.firmaciv.common.blockentity;

import com.alekiponi.firmaciv.common.block.CanoeComponentBlock;
import com.alekiponi.firmaciv.common.blockentity.FirmacivBlockEntities;
import net.dries007.tfc.common.blockentities.TFCBlockEntity;
import net.dries007.tfc.config.TFCConfig;
import net.dries007.tfc.util.calendar.Calendars;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class CanoeComponentBlockEntity
extends TFCBlockEntity {
    private long litTick;
    private boolean isLit;

    public CanoeComponentBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)FirmacivBlockEntities.CANOE_COMPONENT_BLOCK_ENTITY.get(), pPos, pBlockState);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, CanoeComponentBlockEntity canoeBlock) {
        long remainingTicks;
        if (canoeBlock.isLit && (remainingTicks = (long)((Integer)TFCConfig.SERVER.pitKilnTicks.get()).intValue() - (Calendars.SERVER.getTicks() - canoeBlock.litTick)) <= 0L) {
            BlockState newState = (BlockState)state.m_61124_((Property)CanoeComponentBlock.CANOE_CARVED, (Comparable)Integer.valueOf(13));
            level.m_7731_(pos, newState, 4);
            CanoeComponentBlock.trySpawnCanoe(level, pos, (CanoeComponentBlock)state.m_60734_());
            canoeBlock.isLit = false;
        }
    }

    public void light() {
        if (this.isLit) {
            return;
        }
        this.isLit = true;
        this.litTick = Calendars.SERVER.getTicks();
        this.markForBlockUpdate();
        BlockState newState = (BlockState)this.m_58900_().m_61124_((Property)CanoeComponentBlock.CANOE_CARVED, (Comparable)Integer.valueOf(12));
        this.f_58857_.m_7731_(this.m_58899_(), newState, 4);
        BlockPos pPos = this.m_58899_();
        Level pLevel = this.m_58904_();
        Direction.Axis axis = (Direction.Axis)pLevel.m_8055_(pPos).m_61143_((Property)BlockStateProperties.f_61365_);
        BlockPos blockPos1 = pPos.m_5487_(axis, 1);
        BlockPos blockPos2 = pPos.m_5487_(axis, -1);
        if (pLevel.m_7702_(blockPos1) instanceof CanoeComponentBlockEntity && (Integer)pLevel.m_8055_(blockPos1).m_61143_((Property)CanoeComponentBlock.CANOE_CARVED) == 11) {
            ((CanoeComponentBlockEntity)pLevel.m_7702_(blockPos1)).light();
        }
        if (pLevel.m_7702_(blockPos2) instanceof CanoeComponentBlockEntity && (Integer)pLevel.m_8055_(blockPos2).m_61143_((Property)CanoeComponentBlock.CANOE_CARVED) == 11) {
            ((CanoeComponentBlockEntity)pLevel.m_7702_(blockPos2)).light();
        }
    }

    public void loadAdditional(CompoundTag nbt) {
        this.isLit = nbt.m_128471_("isLit");
        this.litTick = nbt.m_128454_("litTick");
        super.loadAdditional(nbt);
    }

    public void m_183515_(CompoundTag nbt) {
        nbt.m_128379_("isLit", this.isLit);
        nbt.m_128356_("litTick", this.litTick);
        super.m_183515_(nbt);
    }

    public long getTicksLeft() {
        assert (this.f_58857_ != null);
        return this.litTick + (long)((Integer)TFCConfig.SERVER.pitKilnTicks.get()).intValue() - Calendars.get((LevelReader)this.f_58857_).getTicks();
    }
}

