/*
 * Decompiled with CFR 0.152.
 */
package com.alekiponi.firmaciv.common.block;

import com.alekiponi.alekiships.common.block.AngledBoatFrameBlock;
import com.alekiponi.alekiships.common.block.AngledWoodenBoatFrameBlock;
import com.alekiponi.alekiships.common.block.ProcessedBoatFrame;
import com.alekiponi.alekiships.util.BoatMaterial;
import com.alekiponi.alekiships.util.CommonHelper;
import com.alekiponi.firmaciv.common.block.FirmacivBlockStateProperties;
import com.alekiponi.firmaciv.common.block.FirmacivBlocks;
import com.alekiponi.firmaciv.common.item.FirmacivItems;
import net.dries007.tfc.common.TFCTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.phys.BlockHitResult;

public class FirmacivAngledWoodenBoatFrameBlock
extends AngledBoatFrameBlock
implements ProcessedBoatFrame {
    public static final IntegerProperty FRAME_PROCESSED = FirmacivBlockStateProperties.FRAME_PROCESSED_7;
    public static final int FULLY_PLANKED = 3;
    private static final int FULLY_PROCESSED = 7;
    public final BoatMaterial boatMaterial;

    public FirmacivAngledWoodenBoatFrameBlock(BoatMaterial boatMaterial, BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)SHAPE, (Comparable)StairsShape.STRAIGHT)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FRAME_PROCESSED, (Comparable)Integer.valueOf(0)));
        this.boatMaterial = boatMaterial;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, SHAPE, WATERLOGGED, FRAME_PROCESSED});
    }

    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (hand != InteractionHand.MAIN_HAND) {
            return InteractionResult.PASS;
        }
        ItemStack heldStack = player.m_21120_(hand);
        int processState = (Integer)blockState.m_61143_((Property)FRAME_PROCESSED);
        if (heldStack.m_41619_() && !level.f_46443_) {
            if (processState <= 3) {
                CommonHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)this.boatMaterial.getDeckItem()));
            } else {
                CommonHelper.giveItemToPlayer((Player)player, (ItemStack)new ItemStack((ItemLike)FirmacivItems.COPPER_BOLT.get()));
            }
            if (processState == 0) {
                level.m_46597_(blockPos, ((AngledBoatFrameBlock)FirmacivBlocks.BOAT_FRAME_ANGLED.get()).m_152465_(blockState));
                return InteractionResult.SUCCESS;
            }
            level.m_46597_(blockPos, (BlockState)blockState.m_61124_((Property)FRAME_PROCESSED, (Comparable)Integer.valueOf(processState - 1)));
            return InteractionResult.SUCCESS;
        }
        if (heldStack.m_150930_(this.boatMaterial.getDeckItem())) {
            if (processState < 3) {
                if (!player.m_150110_().f_35937_) {
                    heldStack.m_41774_(1);
                }
                level.m_46597_(blockPos, (BlockState)blockState.m_61122_((Property)FRAME_PROCESSED));
                level.m_5594_(null, blockPos, SoundEvents.f_12635_, SoundSource.BLOCKS, 1.5f, level.m_213780_().m_188501_() * 0.1f + 0.9f);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.CONSUME;
        }
        if (heldStack.m_150930_((Item)FirmacivItems.COPPER_BOLT.get()) && player.m_21206_().m_204117_(TFCTags.Items.HAMMERS)) {
            if (3 <= processState && processState < 7) {
                if (!player.m_150110_().f_35937_) {
                    heldStack.m_41774_(1);
                }
                level.m_46597_(blockPos, (BlockState)blockState.m_61122_((Property)FRAME_PROCESSED));
                level.m_5594_(null, blockPos, SoundEvents.f_12065_, SoundSource.BLOCKS, 1.5f, level.m_213780_().m_188501_() * 0.1f + 0.9f);
                if (processState + 1 == 7) {
                    AngledWoodenBoatFrameBlock.triggerDetection((Level)level, (BlockPos)blockPos);
                }
                return InteractionResult.m_19078_((boolean)level.m_5776_());
            }
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    public ItemStack m_7397_(BlockGetter blockGetter, BlockPos blockPos, BlockState blockState) {
        return ((AngledBoatFrameBlock)FirmacivBlocks.BOAT_FRAME_ANGLED.get()).m_7397_(blockGetter, blockPos, blockState);
    }

    public IntegerProperty getProcessingProperty() {
        return FRAME_PROCESSED;
    }

    public int getProcessingLimit() {
        return 7;
    }

    public BoatMaterial getBoatMaterial() {
        return this.boatMaterial;
    }
}

