/*
 * Decompiled with CFR 0.152.
 */
package com.alekiponi.firmaciv.client.render.entity.compartment;

import com.alekiponi.alekiships.client.render.entity.vehicle.vehiclehelper.BlockCompartmentRenderer;
import com.alekiponi.alekiships.common.entity.vehiclehelper.compartment.AbstractCompartmentEntity;
import com.alekiponi.firmaciv.common.entity.compartment.TFCBarrelCompartmentEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.dries007.tfc.client.RenderHelpers;
import net.dries007.tfc.config.TFCConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.FluidStack;

public class BarrelCompartmentRenderer
extends BlockCompartmentRenderer<TFCBarrelCompartmentEntity> {
    public BarrelCompartmentRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    protected void renderCompartmentContents(TFCBarrelCompartmentEntity compartmentEntity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        super.renderCompartmentContents((AbstractCompartmentEntity)compartmentEntity, partialTicks, poseStack, bufferSource, packedLight);
        if (compartmentEntity.isSealed()) {
            return;
        }
        compartmentEntity.getCapability(ForgeCapabilities.FLUID_HANDLER).map(fluidHandler -> fluidHandler.getFluidInTank(0)).filter(fluidStack -> !fluidStack.isEmpty()).ifPresent(fluidStack -> {
            float fillPercent = (float)fluidStack.getAmount() / (float)((Integer)TFCConfig.SERVER.barrelCapacity.get()).intValue();
            float subtract = (double)fillPercent > 0.03 ? 0.0f : (0.03f - fillPercent) * 7.0f;
            RenderHelpers.renderFluidFace((PoseStack)poseStack, (FluidStack)fluidStack, (MultiBufferSource)bufferSource, (float)(0.1875f + subtract), (float)(0.1875f + subtract), (float)(0.8125f - subtract), (float)(0.8125f - subtract), (float)(0.140625f + 0.734375f * fillPercent), (int)OverlayTexture.f_118083_, (int)packedLight);
        });
        compartmentEntity.getCapability(ForgeCapabilities.ITEM_HANDLER).map(itemHandler -> itemHandler.getStackInSlot(2)).filter(itemStack -> !itemStack.m_41619_()).ifPresent(itemStack -> {
            poseStack.m_85836_();
            poseStack.m_85837_(0.5, 0.15625, 0.5);
            poseStack.m_85841_(0.5f, 0.5f, 0.5f);
            poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
            Minecraft.m_91087_().m_91291_().m_269128_(itemStack, ItemDisplayContext.FIXED, packedLight, OverlayTexture.f_118083_, poseStack, bufferSource, compartmentEntity.m_9236_(), 0);
            poseStack.m_85849_();
        });
    }
}

