/*
 * Decompiled with CFR 0.152.
 */
package mod.trasiter101.esc.network;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import mod.trasiter101.esc.network.ClientboundExtendedSlotInitialDataPacket;
import mod.trasiter101.esc.network.ClientboundExtendedSlotSyncPacket;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.commons.lang3.mutable.MutableInt;

public final class ESCPacketHandler {
    private static final String VERSION = ModList.get().getModFileById("esc").versionString();
    private static final SimpleChannel CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("esc", "main"), () -> VERSION, VERSION::equals, VERSION::equals);
    private static final MutableInt ID = new MutableInt(0);

    public static void send(PacketDistributor.PacketTarget target, Object message) {
        CHANNEL.send(target, message);
    }

    public static void init() {
        ESCPacketHandler.register(ClientboundExtendedSlotInitialDataPacket.class, ClientboundExtendedSlotInitialDataPacket::encode, ClientboundExtendedSlotInitialDataPacket::new, ClientboundExtendedSlotInitialDataPacket::handle);
        ESCPacketHandler.register(ClientboundExtendedSlotSyncPacket.class, ClientboundExtendedSlotSyncPacket::encode, ClientboundExtendedSlotSyncPacket::new, ClientboundExtendedSlotSyncPacket::handle);
    }

    private static <T> void register(Class<T> clazz, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, Consumer<T> handler) {
        ESCPacketHandler.register(clazz, encoder, decoder, (T packet, ServerPlayer player) -> handler.accept(packet));
    }

    private static <T> void register(Class<T> clazz, BiConsumer<T, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, T> decoder, BiConsumer<T, ServerPlayer> handler) {
        CHANNEL.registerMessage(ID.getAndIncrement(), clazz, encoder, decoder, (packet, context) -> {
            ((NetworkEvent.Context)context.get()).setPacketHandled(true);
            ((NetworkEvent.Context)context.get()).enqueueWork(() -> ESCPacketHandler.lambda$register$2(handler, packet, (Supplier)context));
        });
    }

    private static /* synthetic */ void lambda$register$2(BiConsumer handler, Object packet, Supplier context) {
        handler.accept(packet, ((NetworkEvent.Context)context.get()).getSender());
    }
}

