/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.world;

import com.seibel.distanthorizons.core.file.structure.LocalSaveStructure;
import com.seibel.distanthorizons.core.level.DhClientServerLevel;
import com.seibel.distanthorizons.core.level.IDhLevel;
import com.seibel.distanthorizons.core.util.LodUtil;
import com.seibel.distanthorizons.core.util.ThreadUtil;
import com.seibel.distanthorizons.core.util.objects.EventLoop;
import com.seibel.distanthorizons.core.world.AbstractDhWorld;
import com.seibel.distanthorizons.core.world.EWorldEnvironment;
import com.seibel.distanthorizons.core.world.IDhClientWorld;
import com.seibel.distanthorizons.core.world.IDhServerWorld;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IClientLevelWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IServerLevelWrapper;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import org.jetbrains.annotations.NotNull;

public class DhClientServerWorld
extends AbstractDhWorld
implements IDhClientWorld,
IDhServerWorld {
    private final HashMap<ILevelWrapper, DhClientServerLevel> levelWrapperByDhLevel = new HashMap();
    private final HashSet<DhClientServerLevel> dhLevels = new HashSet();
    public final LocalSaveStructure saveStructure = new LocalSaveStructure();
    public ExecutorService dhTickerThread = ThreadUtil.makeSingleThreadPool("Client Server World Ticker Thread", 2);
    public EventLoop eventLoop = new EventLoop(this.dhTickerThread, this::_clientTick);

    public DhClientServerWorld() {
        super(EWorldEnvironment.Client_Server);
        LOGGER.info("Started DhWorld of type " + (Object)((Object)this.environment));
    }

    @Override
    public DhClientServerLevel getOrLoadLevel(@NotNull ILevelWrapper wrapper) {
        if (wrapper instanceof IServerLevelWrapper) {
            return this.levelWrapperByDhLevel.computeIfAbsent(wrapper, levelWrapper -> {
                File levelFile = this.saveStructure.getLevelFolder((ILevelWrapper)levelWrapper);
                LodUtil.assertTrue(levelFile != null);
                DhClientServerLevel level = new DhClientServerLevel(this.saveStructure, (IServerLevelWrapper)levelWrapper);
                this.dhLevels.add(level);
                return level;
            });
        }
        return this.levelWrapperByDhLevel.computeIfAbsent(wrapper, levelWrapper -> {
            DhClientServerLevel level;
            IClientLevelWrapper clientLevelWrapper = (IClientLevelWrapper)levelWrapper;
            IServerLevelWrapper serverLevelWrapper = clientLevelWrapper.tryGetServerSideWrapper();
            LodUtil.assertTrue(serverLevelWrapper != null);
            if (!clientLevelWrapper.getDimensionType().equals(serverLevelWrapper.getDimensionType())) {
                LodUtil.assertNotReach("tryGetServerSideWrapper returned a level for a different dimension. ClientLevelWrapper dim: " + clientLevelWrapper.getDimensionType().getDimensionName() + " ServerLevelWrapper dim: " + serverLevelWrapper.getDimensionType().getDimensionName());
            }
            if ((level = this.levelWrapperByDhLevel.get(serverLevelWrapper)) == null) {
                return null;
            }
            level.startRenderer(clientLevelWrapper);
            clientLevelWrapper.setParentLevel(level);
            return level;
        });
    }

    @Override
    public DhClientServerLevel getLevel(@NotNull ILevelWrapper wrapper) {
        return this.levelWrapperByDhLevel.get(wrapper);
    }

    @Override
    public Iterable<? extends IDhLevel> getAllLoadedLevels() {
        return this.dhLevels;
    }

    @Override
    public int getLoadedLevelCount() {
        return this.dhLevels.size();
    }

    @Override
    public void unloadLevel(@NotNull ILevelWrapper wrapper) {
        if (this.levelWrapperByDhLevel.containsKey(wrapper)) {
            if (wrapper instanceof IServerLevelWrapper) {
                LOGGER.info("Unloading level " + this.levelWrapperByDhLevel.get(wrapper));
                wrapper.onUnload();
                DhClientServerLevel clientServerLevel = this.levelWrapperByDhLevel.remove(wrapper);
                clientServerLevel.close();
                this.dhLevels.remove(clientServerLevel);
            } else {
                this.levelWrapperByDhLevel.remove(wrapper).stopRenderer();
            }
        }
    }

    private void _clientTick() {
        this.dhLevels.forEach(DhClientServerLevel::clientTick);
    }

    @Override
    public void clientTick() {
        this.eventLoop.tick();
    }

    @Override
    public void serverTick() {
        this.dhLevels.forEach(DhClientServerLevel::serverTick);
    }

    @Override
    public void doWorldGen() {
        this.dhLevels.forEach(DhClientServerLevel::doWorldGen);
    }

    @Override
    public synchronized void close() {
        HashSet<DhClientServerLevel> levelsToClose = new HashSet<DhClientServerLevel>(this.dhLevels);
        this.dhLevels.clear();
        for (DhClientServerLevel level : levelsToClose) {
            LOGGER.info("Unloading level " + level.getServerLevelWrapper().getDimensionType().getDimensionName());
            IServerLevelWrapper serverLevelWrapper = level.getServerLevelWrapper();
            if (serverLevelWrapper != null) {
                serverLevelWrapper.onUnload();
            }
            level.close();
        }
        this.levelWrapperByDhLevel.clear();
        this.eventLoop.close();
        LOGGER.info("Closed DhWorld of type " + (Object)((Object)this.environment));
    }
}

