/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.util;

import com.google.common.annotations.VisibleForTesting;
import com.seibel.distanthorizons.core.dataObjects.render.columnViews.ColumnArrayView;
import com.seibel.distanthorizons.core.dataObjects.render.columnViews.IColumnDataView;
import com.seibel.distanthorizons.core.util.LodUtil;
import com.seibel.distanthorizons.core.util.RenderDataPointUtil;
import it.unimi.dsi.fastutil.longs.LongArrays;
import it.unimi.dsi.fastutil.shorts.ShortArrays;
import java.util.Arrays;

public class RenderDataPointReducingList {
    private static final boolean ASSERTS = false;
    private static final int SPECIAL_CASES = 2;
    public static final int LOWER_SHIFT = 0;
    public static final int HIGHER_SHIFT = 16;
    public static final int SMALLER_SHIFT = 32;
    public static final int BIGGER_SHIFT = 48;
    public static final int LINK_MASK = 65535;
    public static final int NULL = 65535;
    public static final long DEFAUlT_DATA = 0L;
    public static final long DEFAULT_LINKS = -1L;
    private short lowest;
    private short highest;
    private short smallest;
    private short biggest;
    private short sizeWithAir;
    private short sizeWithoutAir;
    private final long[] links;
    private final long[] data;
    private final short[] sortingArray;

    public RenderDataPointReducingList(IColumnDataView view) {
        int sortingIndex;
        int size = view.size();
        if (size == 0) {
            this.setLowest(65535);
            this.setHighest(65535);
            this.setSmallest(65535);
            this.setBiggest(65535);
            this.links = LongArrays.EMPTY_ARRAY;
            this.data = LongArrays.EMPTY_ARRAY;
            this.sortingArray = ShortArrays.EMPTY_ARRAY;
            return;
        }
        int arrayCapacity = (size << 1) - 1;
        this.sortingArray = new short[arrayCapacity];
        this.links = new long[arrayCapacity];
        Arrays.fill(this.links, -1L);
        this.data = new long[arrayCapacity];
        int sizeWithoutAir = 0;
        for (int index = 0; index < size; ++index) {
            long packedData = view.get(index);
            if (!RenderDataPointReducingList.isDataVisible(packedData) || RenderDataPointUtil.getYMin(packedData) >= RenderDataPointUtil.getYMax(packedData)) continue;
            this.setData(sizeWithoutAir, packedData);
            this.setSortingIndex(sizeWithoutAir, sizeWithoutAir);
            ++sizeWithoutAir;
        }
        if (sizeWithoutAir == 0) {
            this.setLowest(65535);
            this.setHighest(65535);
            this.setSmallest(65535);
            this.setBiggest(65535);
            return;
        }
        this.sortByPosition(sizeWithoutAir);
        int sizeWithAir = sizeWithoutAir;
        for (sortingIndex = 1; sortingIndex < sizeWithoutAir; ++sortingIndex) {
            short higherMinY;
            int lowerIndex = this.getSortingIndex(sortingIndex - 1);
            int higherIndex = this.getSortingIndex(sortingIndex);
            long lowerData = this.getData(lowerIndex);
            long higherData = this.getData(higherIndex);
            short lowerMaxY = RenderDataPointUtil.getYMax(lowerData);
            if (lowerMaxY == (higherMinY = RenderDataPointUtil.getYMin(higherData))) {
                this.setHigher(lowerIndex, higherIndex);
                this.setLower(higherIndex, lowerIndex);
                continue;
            }
            if (lowerMaxY < higherMinY) {
                this.setData(sizeWithAir, RenderDataPointUtil.createDataPoint(0, 0, 0, 0, higherMinY, lowerMaxY, RenderDataPointUtil.getLightSky(higherData), RenderDataPointUtil.getLightBlock(higherData), RenderDataPointUtil.getBlockMaterialId(higherData)));
                this.setSortingIndex(sizeWithAir, sizeWithAir);
                this.setLower(higherIndex, sizeWithAir);
                this.setHigher(lowerIndex, sizeWithAir);
                this.setLower(sizeWithAir, lowerIndex);
                this.setHigher(sizeWithAir, higherIndex);
                ++sizeWithAir;
                continue;
            }
            throw new IllegalArgumentException(RenderDataPointUtil.toString(lowerData) + " overlaps with " + RenderDataPointUtil.toString(higherData));
        }
        this.lowest = this.sortingArray[0];
        this.highest = this.sortingArray[sizeWithoutAir - 1];
        this.sortBySize(sizeWithAir);
        for (sortingIndex = 1; sortingIndex < sizeWithAir; ++sortingIndex) {
            int smallerIndex = this.getSortingIndex(sortingIndex - 1);
            int biggerIndex = this.getSortingIndex(sortingIndex);
            this.setBigger(smallerIndex, biggerIndex);
            this.setSmaller(biggerIndex, smallerIndex);
        }
        this.smallest = this.sortingArray[0];
        this.biggest = this.sortingArray[sizeWithAir - 1];
        this.setSizeWithAir(sizeWithAir);
        this.setSizeWithoutAir(sizeWithoutAir);
    }

    public void reduce(int target) {
        if (this.mergeVerySmallConnectedSegments(target)) {
            return;
        }
        if (this.mergeConnectedSegments(target)) {
            return;
        }
        if (this.removeLeastImportantSegments(target)) {
            return;
        }
        this.forceBottomToMerge(target);
    }

    @VisibleForTesting
    public void checkLinks() {
        LodUtil.assertTrue(this.getSizeWithAir() >= 0, "size with air < 0");
        LodUtil.assertTrue(this.getSizeWithoutAir() >= 0, "size without air < 0");
        LodUtil.assertTrue(this.getSizeWithoutAir() <= this.getSizeWithAir(), "more segments without air than with air");
        if (this.getSizeWithAir() == 0) {
            LodUtil.assertTrue(this.getSmallest() == 65535, "size is 0, but we have a smallest node");
            LodUtil.assertTrue(this.getBiggest() == 65535, "size is 0, but we have a biggest node");
            LodUtil.assertTrue(this.getLowest() == 65535, "size is 0, but we have a lowest node");
            LodUtil.assertTrue(this.getHighest() == 65535, "size is 0, but we have a highest node");
        } else {
            int sizeWithAir = 0;
            int sizeWithoutAir = 0;
            int index = this.getSmallest();
            while (index != 65535) {
                int smaller = this.getSmaller(index);
                int bigger = this.getBigger(index);
                LodUtil.assertTrue((smaller != 65535 ? this.getBigger(smaller) : this.getSmallest()) == index, "one-way link");
                LodUtil.assertTrue((bigger != 65535 ? this.getSmaller(bigger) : this.getBiggest()) == index, "one-way link");
                LodUtil.assertTrue(smaller == 65535 || this.getSize(index) >= this.getSize(smaller), "node is not sorted by size");
                ++sizeWithAir;
                if (this.isIndexVisible(index)) {
                    ++sizeWithoutAir;
                }
                index = this.getBigger(index);
            }
            LodUtil.assertTrue(sizeWithAir == this.getSizeWithAir() && sizeWithoutAir == this.getSizeWithoutAir(), "node count does not match size");
            sizeWithoutAir = 0;
            sizeWithAir = 0;
            index = this.getLowest();
            while (index != 65535) {
                int lower = this.getLower(index);
                int higher = this.getHigher(index);
                LodUtil.assertTrue((lower != 65535 ? this.getHigher(lower) : this.getLowest()) == index, "one-way link");
                LodUtil.assertTrue((higher != 65535 ? this.getLower(higher) : this.getHighest()) == index, "one-way link");
                LodUtil.assertTrue(this.getMaxY(index) > this.getMinY(index), "node has inverted Y levels");
                LodUtil.assertTrue(lower == 65535 || this.getMinY(index) == this.getMaxY(lower), "node does not touch its lower neighbor");
                ++sizeWithAir;
                if (this.isIndexVisible(index)) {
                    ++sizeWithoutAir;
                }
                index = this.getHigher(index);
            }
            LodUtil.assertTrue(sizeWithAir == this.getSizeWithAir() && sizeWithoutAir == this.getSizeWithoutAir(), "node count does not match size");
        }
    }

    public void remove(int index) {
        int lower = this.getLower(index);
        int higher = this.getHigher(index);
        int smaller = this.getSmaller(index);
        int bigger = this.getBigger(index);
        int alpha = this.getAlpha(index);
        if (lower != 65535) {
            this.setHigher(lower, higher);
        } else {
            this.setLowest(higher);
        }
        if (higher != 65535) {
            this.setLower(higher, lower);
        } else {
            this.setHighest(lower);
        }
        if (smaller != 65535) {
            this.setBigger(smaller, bigger);
        } else {
            this.setSmallest(bigger);
        }
        if (bigger != 65535) {
            this.setSmaller(bigger, smaller);
        } else {
            this.setBiggest(smaller);
        }
        this.setData(index, 0L);
        this.links[index] = -1L;
        this.sizeWithAir = (short)(this.sizeWithAir - 1);
        if (RenderDataPointReducingList.isAlphaVisible(alpha)) {
            this.sizeWithoutAir = (short)(this.sizeWithoutAir - 1);
        }
    }

    @VisibleForTesting
    public void sortBySizeAndReLink() {
        if (this.getSizeWithAir() <= 1) {
            return;
        }
        long[] datas = this.data;
        int writeIndex = 0;
        int readIndex = this.getLowest();
        while (readIndex != 65535) {
            if (datas[readIndex] != 0L) {
                this.setSortingIndex(writeIndex++, readIndex);
            }
            readIndex = this.getHigher(readIndex);
        }
        this.sortBySize(writeIndex);
        for (int index = 1; index < writeIndex; ++index) {
            int smaller = this.getSortingIndex(index - 1);
            int bigger = this.getSortingIndex(index);
            this.setSmaller(bigger, smaller);
            this.setBigger(smaller, bigger);
        }
        this.smallest = this.sortingArray[0];
        this.biggest = this.sortingArray[writeIndex - 1];
        this.setSmaller(this.getSmallest(), 65535);
        this.setBigger(this.getBiggest(), 65535);
    }

    @VisibleForTesting
    public void sortBySize(int size) {
        short[] array = this.sortingArray;
        it.unimi.dsi.fastutil.Arrays.quickSort((int)0, (int)size, (index1, index2) -> Integer.compare(this.getSize(this.getSortingIndex(index1)), this.getSize(this.getSortingIndex(index2))), (index1, index2) -> ShortArrays.swap((short[])array, (int)index1, (int)index2));
    }

    @VisibleForTesting
    public void sortByPosition(int size) {
        short[] array = this.sortingArray;
        it.unimi.dsi.fastutil.Arrays.quickSort((int)0, (int)size, (index1, index2) -> Integer.compare(this.getMinY(this.getSortingIndex(index1)), this.getMinY(this.getSortingIndex(index2))), (index1, index2) -> ShortArrays.swap((short[])array, (int)index1, (int)index2));
    }

    public void resortSize(int smaller) {
        int bigger = this.getBigger(smaller);
        if (bigger == 65535 || this.getSize(smaller) <= this.getSize(bigger)) {
            return;
        }
        int smallest = this.getSmaller(smaller);
        if (smallest != 65535) {
            this.setBigger(smallest, bigger);
        } else {
            this.setSmallest(bigger);
        }
        this.setSmaller(bigger, smallest);
        while ((bigger = this.getBigger(bigger)) != 65535 && this.getSize(smaller) > this.getSize(bigger)) {
        }
        this.setSmaller(smaller, bigger != 65535 ? this.getSmaller(bigger) : this.getBiggest());
        this.setBigger(smaller, bigger);
        if (bigger != 65535) {
            this.setSmaller(bigger, smaller);
        } else {
            this.setBiggest(smaller);
        }
        smallest = this.getSmaller(smaller);
        if (smallest != 65535) {
            this.setBigger(smallest, smaller);
        } else {
            this.setSmallest(smaller);
        }
    }

    private int tryMergeStep1(int current, boolean fastPath) {
        int toRemove;
        int toExtendDownwards;
        int result = fastPath ? this.getSmaller(current) : this.getBigger(current);
        int higher = this.getHigher(current);
        int lower = this.getLower(current);
        if (higher != 65535 && this.getAlpha(higher) == this.getAlpha(current)) {
            if (lower != 65535 && this.getAlpha(lower) == this.getAlpha(current)) {
                if (this.getSize(higher) <= this.getSize(lower)) {
                    toExtendDownwards = higher;
                    toRemove = current;
                } else {
                    toExtendDownwards = current;
                    toRemove = lower;
                }
            } else {
                toExtendDownwards = higher;
                toRemove = current;
            }
        } else if (lower != 65535 && this.getAlpha(lower) == this.getAlpha(current)) {
            toExtendDownwards = current;
            toRemove = lower;
        } else {
            return result;
        }
        if (result == toRemove) {
            result = this.getSmaller(result);
        }
        this.setMinY(toExtendDownwards, this.getMinY(toRemove));
        if (!fastPath) {
            this.resortSize(toExtendDownwards);
        }
        this.remove(toRemove);
        return fastPath ? result : this.getSmallest();
    }

    private int lowerNode(int size) {
        int node = this.getSmallest();
        while (node != 65535) {
            if (this.getSize(node) >= size) {
                return this.getSmaller(node);
            }
            node = this.getBigger(node);
        }
        return this.getBiggest();
    }

    private boolean mergeVerySmallConnectedSegments(int target) {
        for (int specialCase = 1; specialCase <= 2; ++specialCase) {
            int current = this.lowerNode(specialCase + 1);
            while (current != 65535) {
                if (this.getSizeWithoutAir() <= target) {
                    this.sortBySizeAndReLink();
                    return true;
                }
                current = this.tryMergeStep1(current, true);
            }
            this.sortBySizeAndReLink();
        }
        return false;
    }

    private boolean mergeConnectedSegments(int target) {
        int current = this.getSmallest();
        while (current != 65535) {
            if (this.getSizeWithoutAir() <= target) {
                return true;
            }
            current = this.tryMergeStep1(current, false);
        }
        return false;
    }

    private boolean removeLeastImportantSegments(int target) {
        int center = this.getSmallest();
        while (center != 65535) {
            if (this.getSizeWithoutAir() <= target) {
                return true;
            }
            int lower = this.getLower(center);
            int higher = this.getHigher(center);
            if (lower != 65535 && higher != 65535 && this.getAlpha(lower) == this.getAlpha(higher)) {
                this.setMinY(higher, this.getMinY(lower));
                this.resortSize(higher);
                this.remove(lower);
                this.remove(center);
                center = this.getSmallest();
                continue;
            }
            center = this.getBigger(center);
        }
        return false;
    }

    private void forceBottomToMerge(int target) {
        int lowest = this.getLowest();
        block0: while (lowest != 65535) {
            if (this.getSizeWithoutAir() <= target) {
                return;
            }
            int lowY = this.getMinY(lowest);
            int higher = this.getHigher(lowest);
            while (true) {
                if (higher == 65535) {
                    this.setLowest(65535);
                    this.setHighest(65535);
                    this.setSmallest(65535);
                    this.setBiggest(65535);
                    this.setSizeWithAir(0);
                    this.setSizeWithoutAir(0);
                    return;
                }
                if (this.isIndexVisible(higher)) {
                    this.setMinY(higher, lowY);
                    this.resortSize(higher);
                    this.remove(lowest);
                    lowest = this.getLowest();
                    continue block0;
                }
                this.remove(lowest);
                lowest = higher;
                higher = this.getHigher(higher);
            }
        }
    }

    public static long reduceToOne(IColumnDataView view) {
        long lowestDataPoint;
        long highestDataPoint;
        long dataPoint;
        int index;
        int size;
        block7: {
            size = view.size();
            if (size <= 0) {
                return 0L;
            }
            for (index = 0; index < size; ++index) {
                dataPoint = view.get(index);
                if (!RenderDataPointReducingList.isDataVisible(dataPoint)) continue;
                highestDataPoint = dataPoint;
                lowestDataPoint = dataPoint;
                break block7;
            }
            return 0L;
        }
        while (index < size) {
            dataPoint = view.get(index);
            if (RenderDataPointReducingList.isDataVisible(dataPoint)) {
                short yMax = RenderDataPointUtil.getYMax(dataPoint);
                short yMin = RenderDataPointUtil.getYMin(dataPoint);
                if (yMax > RenderDataPointUtil.getYMax(highestDataPoint)) {
                    highestDataPoint = dataPoint;
                } else if (yMin < RenderDataPointUtil.getYMin(lowestDataPoint)) {
                    lowestDataPoint = dataPoint;
                }
            }
            ++index;
        }
        return highestDataPoint & 0xFFFFFFFFFFF000FFL | (long)(RenderDataPointUtil.getYMin(lowestDataPoint) << 8);
    }

    public void copyTo(ColumnArrayView view) {
        int writeIndex = 0;
        int node = this.getHighest();
        while (node != 65535) {
            if (this.isIndexVisible(node)) {
                view.set(writeIndex++, this.getData(node));
            }
            node = this.getLower(node);
        }
        if (writeIndex == 0) {
            view.set(writeIndex++, 0L);
        }
        int size = view.size();
        while (writeIndex < size) {
            view.set(writeIndex, 0L);
            ++writeIndex;
        }
    }

    public int getSmallest() {
        return Short.toUnsignedInt(this.smallest);
    }

    public int getBiggest() {
        return Short.toUnsignedInt(this.biggest);
    }

    public int getLowest() {
        return Short.toUnsignedInt(this.lowest);
    }

    public int getHighest() {
        return Short.toUnsignedInt(this.highest);
    }

    public int getSizeWithAir() {
        return Short.toUnsignedInt(this.sizeWithAir);
    }

    public int getSizeWithoutAir() {
        return Short.toUnsignedInt(this.sizeWithoutAir);
    }

    public int getSortingIndex(int index) {
        return Short.toUnsignedInt(this.sortingArray[index]);
    }

    public int getLower(int index) {
        return (int)(this.links[index] >>> 0) & 0xFFFF;
    }

    public int getHigher(int index) {
        return (int)(this.links[index] >>> 16) & 0xFFFF;
    }

    public int getSmaller(int index) {
        return (int)(this.links[index] >>> 32) & 0xFFFF;
    }

    public int getBigger(int index) {
        return (int)(this.links[index] >>> 48) & 0xFFFF;
    }

    public long getData(int index) {
        return this.data[index];
    }

    public int getMinY(int index) {
        return RenderDataPointUtil.getYMin(this.getData(index));
    }

    public int getMaxY(int index) {
        return RenderDataPointUtil.getYMax(this.getData(index));
    }

    public int getSize(int index) {
        long data = this.getData(index);
        return RenderDataPointUtil.getYMax(data) - RenderDataPointUtil.getYMin(data);
    }

    public int getRed(int index) {
        return RenderDataPointUtil.getRed(this.getData(index));
    }

    public int getGreen(int index) {
        return RenderDataPointUtil.getGreen(this.getData(index));
    }

    public int getBlue(int index) {
        return RenderDataPointUtil.getBlue(this.getData(index));
    }

    public int getAlpha(int index) {
        return RenderDataPointUtil.getAlpha(this.getData(index));
    }

    public int getBlockLight(int index) {
        return RenderDataPointUtil.getLightBlock(this.getData(index));
    }

    public int getSkyLight(int index) {
        return RenderDataPointUtil.getLightSky(this.getData(index));
    }

    public void setSmallest(int smallest) {
        this.smallest = (short)smallest;
    }

    public void setBiggest(int biggest) {
        this.biggest = (short)biggest;
    }

    public void setLowest(int lowest) {
        this.lowest = (short)lowest;
    }

    public void setHighest(int highest) {
        this.highest = (short)highest;
    }

    public void setSizeWithAir(int sizeWithAir) {
        this.sizeWithAir = (short)sizeWithAir;
    }

    public void setSizeWithoutAir(int sizeWithoutAir) {
        this.sizeWithoutAir = (short)sizeWithoutAir;
    }

    public void setSortingIndex(int index, int to) {
        this.sortingArray[index] = (short)to;
    }

    public void setLower(int index, int lowerIndex) {
        this.links[index] = this.links[index] & 0xFFFFFFFFFFFF0000L | (long)(lowerIndex & 0xFFFF) << 0;
    }

    public void setHigher(int index, int higherIndex) {
        this.links[index] = this.links[index] & 0xFFFFFFFF0000FFFFL | (long)(higherIndex & 0xFFFF) << 16;
    }

    public void setSmaller(int index, int smallerIndex) {
        this.links[index] = this.links[index] & 0xFFFF0000FFFFFFFFL | (long)(smallerIndex & 0xFFFF) << 32;
    }

    public void setBigger(int index, int biggerIndex) {
        this.links[index] = this.links[index] & 0xFFFFFFFFFFFFL | (long)(biggerIndex & 0xFFFF) << 48;
    }

    public void setData(int index, long data) {
        this.data[index] = data;
    }

    public void setMinY(int index, int minY) {
        this.data[index] = this.data[index] & 0xFFFFFFFFFFF000FFL | ((long)minY & 0xFFFL) << 8;
    }

    public void setMaxY(int index, int maxY) {
        this.data[index] = this.data[index] & 0xFFFFFFFF000FFFFFL | ((long)maxY & 0xFFFL) << 20;
    }

    public void setRed(int index, int red) {
        this.data[index] = this.data[index] & 0xFF00FFFFFFFFFFFFL | ((long)red & 0xFFL) << 48;
    }

    public void setGreen(int index, int green) {
        this.data[index] = this.data[index] & 0xFFFF00FFFFFFFFFFL | ((long)green & 0xFFL) << 40;
    }

    public void setBlue(int index, int blue) {
        this.data[index] = this.data[index] & 0xFFFFFF00FFFFFFFFL | ((long)blue & 0xFFL) << 32;
    }

    public void setAlpha(int index, int alpha) {
        this.data[index] = this.data[index] & 0xF0FFFFFFFFFFFFFFL | ((long)(alpha >>>= 4) & 0xFL) << 56;
    }

    public void setBlockLight(int index, int blockLight) {
        this.data[index] = this.data[index] & 0xFFFFFFFFFFFFFF0FL | ((long)blockLight & 0xFL) << 4;
    }

    public void setSkyLight(int index, int skyLight) {
        this.data[index] = this.data[index] & 0xFFFFFFFFFFFFFFF0L | ((long)skyLight & 0xFL) << 0;
    }

    public boolean isIndexVisible(int index) {
        return RenderDataPointReducingList.isDataVisible(this.getData(index));
    }

    public static boolean isDataVisible(long data) {
        return RenderDataPointReducingList.isAlphaVisible(RenderDataPointUtil.getAlpha(data));
    }

    public static boolean isAlphaVisible(int alpha) {
        return alpha >= 16;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.sizeWithAir << 8).append("lowest to highest:");
        int index = this.lowest;
        while (index != 65535) {
            builder.append('\n').append(RenderDataPointUtil.toString(this.getData(index)));
            index = this.getHigher(index);
        }
        builder.append("\nsmallest to biggest:");
        index = this.smallest;
        while (index != 65535) {
            builder.append('\n').append(RenderDataPointUtil.toString(this.getData(index)));
            index = this.getBigger(index);
        }
        return builder.toString();
    }
}

