/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.render.renderer.generic;

import com.seibel.distanthorizons.api.enums.rendering.EDhApiBlockMaterial;
import com.seibel.distanthorizons.api.interfaces.render.IDhApiRenderableBoxGroup;
import com.seibel.distanthorizons.api.methods.events.sharedParameterObjects.DhApiRenderParam;
import com.seibel.distanthorizons.api.objects.math.DhApiVec3d;
import com.seibel.distanthorizons.api.objects.render.DhApiRenderableBox;
import com.seibel.distanthorizons.api.objects.render.DhApiRenderableBoxGroupShading;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.level.IDhClientLevel;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.render.renderer.generic.GenericObjectRenderer;
import com.seibel.distanthorizons.core.render.renderer.generic.GenericRenderObjectFactory;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftRenderWrapper;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import org.apache.logging.log4j.Logger;

public class CloudRenderHandler {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    private static final IMinecraftRenderWrapper MC_RENDER = SingletonInjector.INSTANCE.get(IMinecraftRenderWrapper.class);
    private static final String CLOUD_RESOURCE_TEXTURE_PATH = "assets/distanthorizons/textures/clouds.png";
    private static final boolean DEBUG_BORDER_COLORS = false;
    private static final int CLOUD_BOX_WIDTH = 64;
    private static final int CLOUD_BOX_THICKNESS = 16;
    private final IDhApiRenderableBoxGroup[][] boxGroupByOffset = new IDhApiRenderableBoxGroup[3][3];
    private final IDhClientLevel level;
    private final GenericObjectRenderer renderer;
    private float moveSpeedInBlocksPerSecond = 3.0f;
    private boolean disabledWarningLogged = false;

    public CloudRenderHandler(IDhClientLevel level, GenericObjectRenderer renderer) {
        this.level = level;
        this.renderer = renderer;
        boolean[][] cloudLocations = new boolean[1][1];
        try {
            cloudLocations = CloudRenderHandler.getCloudsFromTexture();
        }
        catch (FileNotFoundException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            LOGGER.error("Unexpected issue getting cloud texture, error: [" + e.getMessage() + "].", (Throwable)e);
        }
        if (cloudLocations.length != 0 && cloudLocations.length != cloudLocations[0].length) {
            LOGGER.warn("Non-square cloud texture found, some parts of the texture will be clipped off.");
        }
        int textureWidth = cloudLocations.length;
        ArrayList<DhApiRenderableBox> boxList = new ArrayList<DhApiRenderableBox>(512);
        for (int x = 0; x < textureWidth; ++x) {
            for (int z = 0; z < textureWidth; ++z) {
                int endZ;
                if (!cloudLocations[x][z]) continue;
                int startZ = z;
                int startX = x;
                int endX = x + 1;
                for (endZ = startZ; endZ < textureWidth && cloudLocations[x][endZ]; ++endZ) {
                }
                z = endZ - 1;
                for (int currentX = startX + 1; currentX < textureWidth; ++currentX) {
                    boolean canMergeInXDir = true;
                    for (int adjacentZ = startZ; adjacentZ < endZ; ++adjacentZ) {
                        if (cloudLocations[currentX][adjacentZ]) continue;
                        canMergeInXDir = false;
                        break;
                    }
                    if (!canMergeInXDir) break;
                    for (int currentZ = startZ; currentZ < endZ; ++currentZ) {
                        cloudLocations[currentX][currentZ] = false;
                    }
                    endX = currentX + 1;
                }
                int minXBlockPos = startX * 64;
                int minZBlockPos = startZ * 64;
                int maxXBlockPos = endX * 64;
                int maxZBlockPos = endZ * 64;
                Color color = new Color(255, 255, 255, 255);
                DhApiRenderableBox box = new DhApiRenderableBox(new DhApiVec3d(minXBlockPos, 0.0, minZBlockPos), new DhApiVec3d(maxXBlockPos, 16.0, maxZBlockPos), color, EDhApiBlockMaterial.UNKNOWN);
                boxList.add(box);
            }
        }
        DhApiRenderableBoxGroupShading cloudShading = DhApiRenderableBoxGroupShading.getUnshaded();
        cloudShading.south = 0.9f;
        cloudShading.north = 0.9f;
        cloudShading.west = 0.8f;
        cloudShading.east = 0.8f;
        cloudShading.top = 1.0f;
        cloudShading.bottom = 0.7f;
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                IDhApiRenderableBoxGroup boxGroup = GenericRenderObjectFactory.INSTANCE.createRelativePositionedGroup("DistantHorizons:Clouds", new DhApiVec3d(0.0, 0.0, 0.0), boxList);
                boxGroup.setBlockLight(15);
                boxGroup.setSkyLight(15);
                boxGroup.setSsaoEnabled(false);
                boxGroup.setShading(cloudShading);
                CloudParams cloudParams = new CloudParams(textureWidth, x, z);
                boxGroup.setPreRenderFunc(renderParam -> this.preRender((DhApiRenderParam)renderParam, cloudParams));
                renderer.add(boxGroup);
                this.boxGroupByOffset[x + 1][z + 1] = boxGroup;
            }
        }
    }

    private void preRender(DhApiRenderParam renderParam, CloudParams cloudParams) {
        IDhApiRenderableBoxGroup boxGroup = this.boxGroupByOffset[cloudParams.instanceOffsetX + 1][cloudParams.instanceOffsetZ + 1];
        boolean renderClouds = Config.Client.Advanced.Graphics.GenericRendering.enableCloudRendering.get();
        boxGroup.setActive(renderClouds);
        if (!renderClouds) {
            return;
        }
        if (!this.renderer.getUseInstancedRendering()) {
            if (!this.disabledWarningLogged) {
                this.disabledWarningLogged = true;
                LOGGER.warn("Instanced rendering unavailable, cloud rendering disabled.");
            }
            boxGroup.setActive(false);
            return;
        }
        Color cloudColor = this.level.getClientLevelWrapper().getCloudColor(renderParam.partialTicks);
        for (DhApiRenderableBox box : boxGroup) {
            box.color = cloudColor;
        }
        boxGroup.triggerBoxChange();
        long currentTime = System.currentTimeMillis();
        float deltaTime = (float)(currentTime - cloudParams.lastFrameTime) / 1000.0f;
        cloudParams.lastFrameTime = currentTime;
        float deltaX = this.moveSpeedInBlocksPerSecond * deltaTime;
        cloudParams.xOffset -= deltaX;
        cloudParams.xOffset %= cloudParams.widthInBlocks;
        int cameraPosX = (int)CloudRenderHandler.MC_RENDER.getCameraExactPosition().x;
        int cameraPosZ = (int)CloudRenderHandler.MC_RENDER.getCameraExactPosition().z;
        if (cameraPosX < 0) {
            cameraPosX -= (int)cloudParams.widthInBlocks;
        }
        if (cameraPosZ < 0) {
            cameraPosZ -= (int)cloudParams.widthInBlocks;
        }
        int cloudInstanceOffsetX = cameraPosX / (int)cloudParams.widthInBlocks;
        int cloudInstanceOffsetZ = cameraPosZ / (int)cloudParams.widthInBlocks;
        float xOffset = (float)cloudInstanceOffsetX * cloudParams.widthInBlocks;
        float zOffset = (float)cloudInstanceOffsetZ * cloudParams.widthInBlocks;
        boxGroup.setOriginBlockPos(new DhApiVec3d(cloudParams.xOffset + (float)cloudParams.instanceOffsetX * cloudParams.widthInBlocks + xOffset + cloudParams.halfWidthInBlocks, this.level.getLevelWrapper().getMaxHeight() + 200, cloudParams.zOffset + (float)cloudParams.instanceOffsetZ * cloudParams.widthInBlocks + zOffset + cloudParams.halfWidthInBlocks));
    }

    private static boolean[][] getCloudsFromTexture() throws FileNotFoundException, IOException {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        boolean[][] whitePixels = null;
        try (InputStream imageInputStream = loader.getResourceAsStream(CLOUD_RESOURCE_TEXTURE_PATH);){
            if (imageInputStream == null) {
                throw new FileNotFoundException("Unable to find cloud texture at resource path: [assets/distanthorizons/textures/clouds.png].");
            }
            BufferedImage image = ImageIO.read(imageInputStream);
            int width = image.getWidth();
            int height = image.getHeight();
            whitePixels = new boolean[width][height];
            for (int x = 0; x < width; ++x) {
                for (int z = 0; z < width; ++z) {
                    Color color = new Color(image.getRGB(x, z));
                    whitePixels[x][z] = color.equals(Color.WHITE);
                }
            }
        }
        return whitePixels;
    }

    private static class CloudParams {
        public final float textureWidth;
        public final float widthInBlocks;
        public final float halfWidthInBlocks;
        public final int instanceOffsetX;
        public final int instanceOffsetZ;
        public float xOffset = 0.0f;
        public float zOffset = 0.0f;
        public long lastFrameTime = System.currentTimeMillis();

        public CloudParams(float textureWidth, int instanceOffsetX, int instanceOffsetZ) {
            this.textureWidth = textureWidth;
            this.widthInBlocks = this.textureWidth * 64.0f;
            this.halfWidthInBlocks = this.widthInBlocks / 2.0f;
            this.instanceOffsetX = instanceOffsetX;
            this.instanceOffsetZ = instanceOffsetZ;
        }
    }
}

