/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.pos.blockPos;

import com.seibel.distanthorizons.core.enums.EDhDirection;
import com.seibel.distanthorizons.core.pos.blockPos.DhBlockPos2D;
import com.seibel.distanthorizons.core.pos.blockPos.DhBlockPosMutable;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DhBlockPos {
    public static final DhBlockPos ZERO = new DhBlockPos(0, 0, 0);
    protected int x;
    protected int y;
    protected int z;

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public DhBlockPos(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public DhBlockPos() {
        this(0, 0, 0);
    }

    public DhBlockPos(DhBlockPos pos) {
        this(pos.x, pos.y, pos.z);
    }

    public DhBlockPos(DhBlockPos2D pos, int y) {
        this(pos.x, y, pos.z);
    }

    public DhBlockPos createOffset(EDhDirection direction) {
        return this.mutateOrCreateOffset(direction.getNormal().x, direction.getNormal().y, direction.getNormal().z, null);
    }

    public void mutateOffset(EDhDirection direction, @NotNull DhBlockPosMutable mutablePos) {
        this.mutateOrCreateOffset(direction.getNormal().x, direction.getNormal().y, direction.getNormal().z, mutablePos);
    }

    public DhBlockPos createOffset(int x, int y, int z) {
        return this.mutateOrCreateOffset(x, y, z, null);
    }

    public void mutateOffset(int x, int y, int z, @NotNull DhBlockPosMutable mutablePos) {
        this.mutateOrCreateOffset(x, y, z, mutablePos);
    }

    protected DhBlockPos mutateOrCreateOffset(int x, int y, int z, @Nullable DhBlockPosMutable mutablePos) {
        int newX = this.x + x;
        int newY = this.y + y;
        int newZ = this.z + z;
        if (mutablePos != null) {
            mutablePos.x = newX;
            mutablePos.y = newY;
            mutablePos.z = newZ;
            return mutablePos;
        }
        return new DhBlockPos(newX, newY, newZ);
    }

    public DhBlockPos createChunkRelativePos() {
        return this.mutateOrCreateChunkRelativePos(null);
    }

    public void mutateToChunkRelativePos(DhBlockPosMutable mutableBlockPos) {
        this.mutateOrCreateChunkRelativePos(mutableBlockPos);
    }

    protected DhBlockPos mutateOrCreateChunkRelativePos(@Nullable DhBlockPosMutable mutableBlockPos) {
        int relX = DhBlockPos.convertWorldPosToChunkRelative(this.x);
        int relZ = DhBlockPos.convertWorldPosToChunkRelative(this.z);
        if (mutableBlockPos != null) {
            mutableBlockPos.x = relX;
            mutableBlockPos.y = this.y;
            mutableBlockPos.z = relZ;
            return mutableBlockPos;
        }
        return new DhBlockPos(relX, this.y, relZ);
    }

    protected static int convertWorldPosToChunkRelative(int xOrZ) {
        int relPos = xOrZ % 16;
        relPos = relPos < 0 ? relPos + 16 : relPos;
        return relPos;
    }

    public int getManhattanDistance(DhBlockPos otherPos) {
        return Math.abs(this.x - otherPos.x) + Math.abs(this.y - otherPos.y) + Math.abs(this.z - otherPos.z);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DhBlockPos that = (DhBlockPos)obj;
        return this.x == that.x && this.y == that.y && this.z == that.z;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y, this.z);
    }

    public String toString() {
        return "DHBlockPos[" + this.x + ", " + this.y + ", " + this.z + "]";
    }
}

