/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.network.protocol;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.seibel.distanthorizons.core.network.messages.AckMessage;
import com.seibel.distanthorizons.core.network.messages.CloseReasonMessage;
import com.seibel.distanthorizons.core.network.messages.HelloMessage;
import com.seibel.distanthorizons.core.network.messages.PlayerUUIDMessage;
import com.seibel.distanthorizons.core.network.messages.RemotePlayerConfigMessage;
import com.seibel.distanthorizons.core.network.messages.RequestChunksMessage;
import com.seibel.distanthorizons.core.network.protocol.INetworkMessage;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

public class MessageRegistry {
    public static final MessageRegistry INSTANCE = new MessageRegistry();
    private final Map<Integer, Supplier<? extends INetworkMessage>> idToSupplier = new HashMap<Integer, Supplier<? extends INetworkMessage>>();
    private final BiMap<Class<? extends INetworkMessage>, Integer> classToId = HashBiMap.create();

    private MessageRegistry() {
        this.registerMessage(HelloMessage.class, HelloMessage::new);
        this.registerMessage(CloseReasonMessage.class, CloseReasonMessage::new);
        this.registerMessage(AckMessage.class, AckMessage::new);
        this.registerMessage(PlayerUUIDMessage.class, PlayerUUIDMessage::new);
        this.registerMessage(RemotePlayerConfigMessage.class, RemotePlayerConfigMessage::new);
        this.registerMessage(RequestChunksMessage.class, RequestChunksMessage::new);
    }

    public <T extends INetworkMessage> void registerMessage(Class<T> clazz, Supplier<T> supplier) {
        int id = this.idToSupplier.size() + 1;
        this.idToSupplier.put(id, supplier);
        this.classToId.put(clazz, (Object)id);
    }

    public Class<? extends INetworkMessage> getMessageClassById(int messageId) {
        return (Class)this.classToId.inverse().get((Object)messageId);
    }

    public INetworkMessage createMessage(int messageId) throws IllegalArgumentException {
        try {
            return this.idToSupplier.get(messageId).get();
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException("Invalid message ID");
        }
    }

    public int getMessageId(INetworkMessage message) {
        return this.getMessageId(message.getClass());
    }

    public int getMessageId(Class<? extends INetworkMessage> messageClass) {
        return (Integer)this.classToId.get(messageClass);
    }
}

