/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.api.external.methods.data;

import com.seibel.distanthorizons.api.interfaces.data.IDhApiTerrainDataCache;
import com.seibel.distanthorizons.api.interfaces.data.IDhApiTerrainDataRepo;
import com.seibel.distanthorizons.api.interfaces.world.IDhApiLevelWrapper;
import com.seibel.distanthorizons.api.objects.DhApiResult;
import com.seibel.distanthorizons.api.objects.data.DhApiRaycastResult;
import com.seibel.distanthorizons.api.objects.data.DhApiTerrainDataPoint;
import com.seibel.distanthorizons.api.objects.math.DhApiVec3i;
import com.seibel.distanthorizons.core.api.external.methods.data.DhApiTerrainDataCache;
import com.seibel.distanthorizons.core.api.internal.SharedApi;
import com.seibel.distanthorizons.core.dataObjects.fullData.FullDataPointIdMap;
import com.seibel.distanthorizons.core.dataObjects.fullData.sources.FullDataSourceV2;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.level.IDhLevel;
import com.seibel.distanthorizons.core.pos.DhLodPos;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.util.FullDataPointUtil;
import com.seibel.distanthorizons.core.util.RayCastUtil;
import com.seibel.distanthorizons.core.util.math.Vec3d;
import com.seibel.distanthorizons.core.util.math.Vec3f;
import com.seibel.distanthorizons.core.util.math.Vec3i;
import com.seibel.distanthorizons.core.world.AbstractDhWorld;
import com.seibel.distanthorizons.core.wrapperInterfaces.IWrapperFactory;
import com.seibel.distanthorizons.core.wrapperInterfaces.block.IBlockStateWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.chunk.IChunkWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftRenderWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IBiomeWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import com.seibel.distanthorizons.coreapi.util.BitShiftUtil;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class DhApiTerrainDataRepo
implements IDhApiTerrainDataRepo {
    public static DhApiTerrainDataRepo INSTANCE = new DhApiTerrainDataRepo();
    private static final Logger LOGGER = LogManager.getLogger((String)DhApiTerrainDataRepo.class.getSimpleName());
    private static volatile boolean debugThreadRunning = false;
    private static DhApiTerrainDataCache debugDataCache = new DhApiTerrainDataCache();
    private static DhApiVec3i currentDebugVec3i = new Vec3i();

    private DhApiTerrainDataRepo() {
    }

    @Override
    public DhApiResult<DhApiTerrainDataPoint> getSingleDataPointAtBlockPos(IDhApiLevelWrapper levelWrapper, int blockPosX, int blockPosY, int blockPosZ, @Nullable IDhApiTerrainDataCache dataCache) {
        return DhApiTerrainDataRepo.getTerrainDataAtBlockYPos(levelWrapper, new DhLodPos(0, blockPosX, blockPosZ), blockPosY, dataCache);
    }

    @Override
    public DhApiResult<DhApiTerrainDataPoint[]> getColumnDataAtBlockPos(IDhApiLevelWrapper levelWrapper, int blockPosX, int blockPosZ, @Nullable IDhApiTerrainDataCache dataCache) {
        return DhApiTerrainDataRepo.getTerrainDataColumnArray(levelWrapper, new DhLodPos(0, blockPosX, blockPosZ), null, dataCache);
    }

    @Override
    public DhApiResult<DhApiTerrainDataPoint[][][]> getAllTerrainDataAtChunkPos(IDhApiLevelWrapper levelWrapper, int chunkPosX, int chunkPosZ, @Nullable IDhApiTerrainDataCache dataCache) {
        return DhApiTerrainDataRepo.getTerrainDataOverAreaForPositionDetailLevel(levelWrapper, new DhLodPos(4, chunkPosX, chunkPosZ), dataCache);
    }

    @Override
    public DhApiResult<DhApiTerrainDataPoint[][][]> getAllTerrainDataAtRegionPos(IDhApiLevelWrapper levelWrapper, int regionPosX, int regionPosZ, @Nullable IDhApiTerrainDataCache dataCache) {
        return DhApiTerrainDataRepo.getTerrainDataOverAreaForPositionDetailLevel(levelWrapper, new DhLodPos(9, regionPosX, regionPosZ), dataCache);
    }

    @Override
    public DhApiResult<DhApiTerrainDataPoint[][][]> getAllTerrainDataAtDetailLevelAndPos(IDhApiLevelWrapper levelWrapper, byte detailLevel, int posX, int posZ, @Nullable IDhApiTerrainDataCache dataCache) {
        return DhApiTerrainDataRepo.getTerrainDataOverAreaForPositionDetailLevel(levelWrapper, new DhLodPos(detailLevel, posX, posZ), dataCache);
    }

    private static DhApiResult<DhApiTerrainDataPoint> getTerrainDataAtBlockYPos(IDhApiLevelWrapper levelWrapper, DhLodPos requestedColumnPos, Integer blockYPos, @Nullable IDhApiTerrainDataCache dataCache) {
        DhApiResult<DhApiTerrainDataPoint[]> result = DhApiTerrainDataRepo.getTerrainDataColumnArray(levelWrapper, requestedColumnPos, blockYPos, dataCache);
        if (result.success && ((DhApiTerrainDataPoint[])result.payload).length > 0) {
            return DhApiResult.createSuccess(result.message, ((DhApiTerrainDataPoint[])result.payload)[0]);
        }
        return DhApiResult.createFail(result.message);
    }

    private static DhApiResult<DhApiTerrainDataPoint[][][]> getTerrainDataOverAreaForPositionDetailLevel(IDhApiLevelWrapper levelWrapper, DhLodPos requestedAreaPos, @Nullable IDhApiTerrainDataCache dataCache) {
        DhLodPos startingBlockPos = requestedAreaPos.getCornerLodPos((byte)0);
        int widthOfAreaInBlocks = BitShiftUtil.powerOfTwo(requestedAreaPos.detailLevel);
        DhApiTerrainDataPoint[][][] returnArray = new DhApiTerrainDataPoint[widthOfAreaInBlocks][widthOfAreaInBlocks][];
        int dataColumnsReturned = 0;
        for (int x = 0; x < widthOfAreaInBlocks; ++x) {
            for (int z = 0; z < widthOfAreaInBlocks; ++z) {
                DhLodPos blockColumnPos = new DhLodPos(0, startingBlockPos.x + x, startingBlockPos.z + z);
                DhApiResult<DhApiTerrainDataPoint[]> result = DhApiTerrainDataRepo.getTerrainDataColumnArray(levelWrapper, blockColumnPos, null, dataCache);
                if (result.success) {
                    returnArray[x][z] = (DhApiTerrainDataPoint[])result.payload;
                    ++dataColumnsReturned;
                    continue;
                }
                return DhApiResult.createFail(result.message, returnArray);
            }
        }
        return dataColumnsReturned != 0 ? DhApiResult.createSuccess("[" + dataColumnsReturned + "] columns returned.", returnArray) : DhApiResult.createSuccess("No data found.", returnArray);
    }

    private static DhApiResult<DhApiTerrainDataPoint[]> getTerrainDataColumnArray(IDhApiLevelWrapper levelWrapper, DhLodPos requestedColumnPos, Integer nullableBlockYPos, @Nullable IDhApiTerrainDataCache apiDataCache) {
        AbstractDhWorld currentWorld = SharedApi.getAbstractDhWorld();
        if (currentWorld == null) {
            return DhApiResult.createFail("Unable to get terrain data before the world has loaded.");
        }
        if (!(levelWrapper instanceof ILevelWrapper)) {
            return DhApiResult.createFail("Unsupported [" + IDhApiLevelWrapper.class.getSimpleName() + "] implementation, only the core class [" + IDhLevel.class.getSimpleName() + "] is a valid parameter.");
        }
        ILevelWrapper coreLevelWrapper = (ILevelWrapper)levelWrapper;
        if (!(apiDataCache instanceof DhApiTerrainDataCache)) {
            return DhApiResult.createFail("Unsupported [" + IDhApiTerrainDataCache.class.getSimpleName() + "] implementation, only the core class [" + DhApiTerrainDataCache.class.getSimpleName() + "] is a valid parameter.");
        }
        DhApiTerrainDataCache dataCache = (DhApiTerrainDataCache)apiDataCache;
        IDhLevel level = currentWorld.getLevel(coreLevelWrapper);
        if (level == null) {
            return DhApiResult.createFail("Unable to get terrain data before the world has loaded.");
        }
        byte requestedDetailLevel = requestedColumnPos.detailLevel;
        byte sectionDetailLevel = (byte)(requestedDetailLevel + 6);
        long sectionPos = requestedColumnPos.getSectionPosWithSectionDetailLevel(sectionDetailLevel);
        DhLodPos relativePos = requestedColumnPos.getDhSectionRelativePositionForDetailLevel();
        try {
            FullDataSourceV2 dataSource = null;
            if (dataCache != null) {
                dataSource = dataCache.get(sectionPos);
            }
            if (dataSource == null) {
                dataSource = (FullDataSourceV2)level.getFullDataProvider().getAsync(sectionPos).get();
                if (dataSource == null) {
                    return DhApiResult.createFail("Unable to find/generate any data at the " + DhSectionPos.class.getSimpleName() + " [" + DhSectionPos.toString(sectionPos) + "].");
                }
                dataCache.add(sectionPos, dataSource);
            }
            FullDataPointIdMap mapping = dataSource.mapping;
            LongArrayList dataColumn = dataSource.get(relativePos.x, relativePos.z);
            if (dataColumn != null) {
                int dataColumnIndexCount = dataColumn.size();
                DhApiTerrainDataPoint[] returnArray = new DhApiTerrainDataPoint[dataColumnIndexCount];
                boolean getSpecificYCoordinate = nullableBlockYPos != null;
                int levelMinimumHeight = levelWrapper.getMinHeight();
                for (int i = 0; i < dataColumnIndexCount; ++i) {
                    long dataPoint = dataColumn.getLong(i);
                    if (!getSpecificYCoordinate) {
                        returnArray[i] = DhApiTerrainDataRepo.generateApiDatapoint(levelWrapper, mapping, requestedDetailLevel, dataPoint);
                        continue;
                    }
                    if (dataPoint == 0L) continue;
                    int requestedY = nullableBlockYPos;
                    int bottomY = FullDataPointUtil.getBottomY(dataPoint) + levelMinimumHeight;
                    int height = FullDataPointUtil.getHeight(dataPoint);
                    int topY = bottomY + height;
                    if (bottomY > requestedY || requestedY >= topY) continue;
                    DhApiTerrainDataPoint apiTerrainData = DhApiTerrainDataRepo.generateApiDatapoint(levelWrapper, mapping, requestedDetailLevel, dataPoint);
                    return DhApiResult.createSuccess(new DhApiTerrainDataPoint[]{apiTerrainData});
                }
                return DhApiResult.createSuccess(returnArray);
            }
            return DhApiResult.createSuccess(new DhApiTerrainDataPoint[0]);
        }
        catch (InterruptedException | ExecutionException e) {
            LOGGER.error("getTerrainDataColumnArray operation canceled. Error: [" + e.getMessage() + "]", (Throwable)e);
            return DhApiResult.createFail("Operation cancled before it could complete: [" + e.getMessage() + "].");
        }
        catch (Exception e) {
            LOGGER.error("Unexpected exception in getTerrainDataColumnArray. Error: [" + e.getMessage() + "]", (Throwable)e);
            return DhApiResult.createFail("Unexpected exception: [" + e.getMessage() + "].");
        }
    }

    private static DhApiTerrainDataPoint generateApiDatapoint(IDhApiLevelWrapper levelWrapper, FullDataPointIdMap mapping, byte detailLevel, long dataPoint) {
        IBlockStateWrapper blockState = mapping.getBlockStateWrapper(FullDataPointUtil.getId(dataPoint));
        IBiomeWrapper biomeWrapper = mapping.getBiomeWrapper(FullDataPointUtil.getId(dataPoint));
        int bottomY = FullDataPointUtil.getBottomY(dataPoint) + levelWrapper.getMinHeight();
        int height = FullDataPointUtil.getHeight(dataPoint);
        int topY = bottomY + height;
        return DhApiTerrainDataPoint.create(detailLevel, FullDataPointUtil.getBlockLight(dataPoint), FullDataPointUtil.getSkyLight(dataPoint), bottomY, topY, blockState, biomeWrapper);
    }

    @Override
    public DhApiResult<DhApiRaycastResult> raycast(IDhApiLevelWrapper levelWrapper, double rayOriginX, double rayOriginY, double rayOriginZ, float rayDirectionX, float rayDirectionY, float rayDirectionZ, int maxRayBlockLength, @Nullable IDhApiTerrainDataCache dataCache) {
        return this.raycastLodData(levelWrapper, new Vec3d(rayOriginX, rayOriginY, rayOriginZ), new Vec3f(rayDirectionX, rayDirectionY, rayDirectionZ), maxRayBlockLength, dataCache);
    }

    private DhApiResult<DhApiRaycastResult> raycastLodData(IDhApiLevelWrapper levelWrapper, Vec3d rayOrigin, Vec3f rayDirection, int maxRayBlockLength, @Nullable IDhApiTerrainDataCache dataCache) {
        rayDirection.normalize();
        int minBlockHeight = levelWrapper.getMinHeight();
        int maxBlockHeight = levelWrapper.getMaxHeight();
        int currentLength = 0;
        Vec3d exactPos = new Vec3d(rayOrigin.x, rayOrigin.y, rayOrigin.z);
        Vec3i blockPos = new Vec3i((int)Math.round(rayOrigin.x), (int)Math.round(rayOrigin.y), (int)Math.round(rayOrigin.z));
        DhApiRaycastResult closetFoundDataPoint = null;
        while (blockPos.y >= minBlockHeight && blockPos.y < maxBlockHeight && currentLength <= maxRayBlockLength) {
            ArrayList<Vec3i> columnPositions = DhApiTerrainDataRepo.getIntersectingColumnsAtPosition(blockPos, rayDirection);
            for (Vec3i columnPos : columnPositions) {
                DhApiResult<DhApiTerrainDataPoint[]> result = this.getColumnDataAtBlockPos(levelWrapper, columnPos.x, columnPos.z, dataCache);
                if (!result.success) {
                    return DhApiResult.createFail(result.message);
                }
                for (DhApiTerrainDataPoint dataPoint : (DhApiTerrainDataPoint[])result.payload) {
                    double newDistanceSquared;
                    if (dataPoint.blockStateWrapper == null || dataPoint.blockStateWrapper.isAir()) continue;
                    Vec3i dataPointPos = new Vec3i(columnPos.x, dataPoint.bottomYBlockPos, columnPos.z);
                    if (!(exactPos.y >= (double)dataPoint.bottomYBlockPos) || !(exactPos.y <= (double)dataPoint.topYBlockPos)) continue;
                    if (closetFoundDataPoint == null) {
                        closetFoundDataPoint = new DhApiRaycastResult(dataPoint, dataPointPos);
                        continue;
                    }
                    double previousDistanceSquared = Math.pow(rayOrigin.x - (double)closetFoundDataPoint.pos.x, 2.0) + Math.pow(rayOrigin.y - (double)closetFoundDataPoint.pos.y, 2.0) + Math.pow(rayOrigin.z - (double)closetFoundDataPoint.pos.z, 2.0);
                    if (!(previousDistanceSquared > (newDistanceSquared = Math.pow(rayOrigin.x - (double)dataPointPos.x, 2.0) + Math.pow(rayOrigin.y - (double)dataPointPos.y, 2.0) + Math.pow(rayOrigin.z - (double)dataPointPos.z, 2.0)))) continue;
                    closetFoundDataPoint = new DhApiRaycastResult(dataPoint, dataPointPos);
                }
            }
            if (closetFoundDataPoint != null) {
                return DhApiResult.createSuccess(closetFoundDataPoint);
            }
            exactPos.x += (double)rayDirection.x;
            exactPos.y += (double)rayDirection.y;
            exactPos.z += (double)rayDirection.z;
            blockPos.x = (int)Math.round(exactPos.x);
            blockPos.y = (int)Math.round(exactPos.y);
            blockPos.z = (int)Math.round(exactPos.z);
            currentLength = (int)(Math.abs(rayOrigin.x - exactPos.x) + Math.abs(rayOrigin.y - exactPos.y) + Math.abs(rayOrigin.z - exactPos.z));
        }
        return DhApiResult.createSuccess(null);
    }

    private static ArrayList<Vec3i> getIntersectingColumnsAtPosition(Vec3i rayEndingPos, Vec3f rayDirection) {
        ArrayList<Vec3i> returnList = new ArrayList<Vec3i>(9);
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                Vec3i pos = new Vec3i(rayEndingPos.x + x, rayEndingPos.y, rayEndingPos.z + z);
                if (!RayCastUtil.rayIntersectsSquare(rayEndingPos.x, rayEndingPos.z, rayDirection.x, rayDirection.z, pos.x, pos.z, 1.0)) continue;
                returnList.add(pos);
            }
        }
        return returnList;
    }

    @Override
    public DhApiResult<Void> overwriteChunkDataAsync(IDhApiLevelWrapper levelWrapper, Object[] chunkObjectArray) throws ClassCastException {
        if (!(levelWrapper instanceof ILevelWrapper)) {
            return DhApiResult.createFail("Level wrapper needs to be an instance of [" + IDhApiLevelWrapper.class.getSimpleName() + "].");
        }
        AbstractDhWorld dhWorld = SharedApi.getAbstractDhWorld();
        if (dhWorld == null) {
            return DhApiResult.createFail("No world loaded. This method can only be called while in a loaded world.");
        }
        IDhLevel dhLevel = dhWorld.getLevel((ILevelWrapper)levelWrapper);
        if (dhLevel == null) {
            return DhApiResult.createFail("No level exists for the given level wrapper. This either means the level hasn't been loaded yet, or was unloaded.");
        }
        IChunkWrapper chunk = SingletonInjector.INSTANCE.get(IWrapperFactory.class).createChunkWrapper(chunkObjectArray);
        SharedApi.INSTANCE.applyChunkUpdate(chunk, dhLevel.getLevelWrapper(), true);
        return DhApiResult.createSuccess();
    }

    @Override
    public IDhApiTerrainDataCache getSoftCache() {
        return new DhApiTerrainDataCache();
    }

    public static void asyncDebugMethod(IDhApiLevelWrapper levelWrapper, int blockPosX, int blockPosY, int blockPosZ) {
        if (!debugThreadRunning) {
            debugThreadRunning = true;
            Thread thread = new Thread(() -> {
                try {
                    DhApiResult<DhApiTerrainDataPoint> single = DhApiTerrainDataRepo.getTerrainDataAtBlockYPos(levelWrapper, new DhLodPos(0, blockPosX, blockPosZ), blockPosY, debugDataCache);
                    DhApiResult<DhApiTerrainDataPoint[]> column = DhApiTerrainDataRepo.getTerrainDataColumnArray(levelWrapper, new DhLodPos(0, blockPosX, blockPosZ), null, debugDataCache);
                    DhLodPos chunkPos = new DhLodPos(0, blockPosX, blockPosZ).convertToDetailLevel((byte)4);
                    DhApiResult<DhApiTerrainDataPoint[][][]> area = DhApiTerrainDataRepo.getTerrainDataOverAreaForPositionDetailLevel(levelWrapper, chunkPos, debugDataCache);
                    IMinecraftRenderWrapper MC_RENDER = SingletonInjector.INSTANCE.get(IMinecraftRenderWrapper.class);
                    DhApiResult<DhApiRaycastResult> rayCast = INSTANCE.raycastLodData(levelWrapper, MC_RENDER.getCameraExactPosition(), MC_RENDER.getLookAtVector(), 1000, debugDataCache);
                    if (rayCast.payload != null && !((DhApiRaycastResult)rayCast.payload).pos.equals(currentDebugVec3i)) {
                        currentDebugVec3i = ((DhApiRaycastResult)rayCast.payload).pos;
                        String blockString = "[NULL BLOCK]";
                        if (((DhApiRaycastResult)rayCast.payload).dataPoint.blockStateWrapper != null) {
                            blockString = !((DhApiRaycastResult)rayCast.payload).dataPoint.blockStateWrapper.isAir() && ((DhApiRaycastResult)rayCast.payload).dataPoint.blockStateWrapper.getWrappedMcObject() != null ? ((DhApiRaycastResult)rayCast.payload).dataPoint.blockStateWrapper.getWrappedMcObject().toString() : "[AIR]";
                        }
                        LOGGER.info("raycast: " + currentDebugVec3i + "\t block: " + blockString);
                    } else if (rayCast.payload == null && currentDebugVec3i != null) {
                        currentDebugVec3i = null;
                        LOGGER.info("raycast: [INFINITY]");
                    }
                    boolean bl = false;
                }
                catch (Exception e) {
                    LOGGER.error("Test method Error: [" + e.getMessage() + "]", (Throwable)e);
                }
                finally {
                    debugThreadRunning = false;
                }
            });
            thread.start();
        }
    }
}

