/*
 * Decompiled with CFR 0.152.
 */
package com.lazrproductions.cuffed.utils;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Random;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class ChainUtils {
    public static void renderChainTo(Entity entity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, Entity entityFrom) {
        if (entityFrom == null) {
            return;
        }
        float maxLength = 12.0f;
        float distance = entity.m_20270_(entityFrom) / maxLength;
        if (distance > maxLength) {
            distance = maxLength;
        }
        ChainUtils.renderVerticalTo(entity, partialTicks, poseStack, bufferSource, entityFrom, distance);
        ChainUtils.renderHorizontalTo(entity, partialTicks, poseStack, bufferSource, entityFrom, distance);
    }

    public static void renderChainFrom(Entity entity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, Entity entityTo) {
        if (entityTo == null) {
            return;
        }
        float maxLength = 12.0f;
        float distance = entity.m_20270_(entityTo) / maxLength;
        if (distance > maxLength) {
            distance = maxLength;
        }
        ChainUtils.renderVerticalFrom(entity, partialTicks, poseStack, bufferSource, entityTo, distance);
        ChainUtils.renderHorizontalFrom(entity, partialTicks, poseStack, bufferSource, entityTo, distance);
    }

    public static void renderVerticalFrom(Entity entityTo, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, Entity entityFrom, float distance) {
        if (entityTo == null) {
            return;
        }
        poseStack.m_85836_();
        Vec3 startPos = entityTo.m_20318_(partialTicks).m_82549_(new Vec3(0.0, 1.4, 0.0));
        double d0 = (double)(Mth.m_14179_((float)partialTicks, (float)entityFrom.f_19859_, (float)entityFrom.f_19859_) * ((float)Math.PI / 180)) + 1.5707963267948966;
        Vec3 endPosOffset = entityFrom.m_7398_(partialTicks).m_82546_(entityFrom.m_20182_());
        double d1 = org.joml.Math.cos((double)d0) * endPosOffset.f_82481_ + org.joml.Math.sin((double)d0) * endPosOffset.f_82479_;
        double d2 = org.joml.Math.sin((double)d0) * endPosOffset.f_82481_ - org.joml.Math.cos((double)d0) * endPosOffset.f_82479_;
        double ePosX = Mth.m_14139_((double)partialTicks, (double)entityFrom.f_19854_, (double)entityFrom.m_20185_()) + d1;
        double ePosY = Mth.m_14139_((double)partialTicks, (double)entityFrom.f_19855_, (double)entityFrom.m_20186_()) + endPosOffset.f_82480_;
        double ePosZ = Mth.m_14139_((double)partialTicks, (double)entityFrom.f_19856_, (double)entityFrom.m_20189_()) + d2;
        poseStack.m_85837_(d1, endPosOffset.f_82480_, d2);
        float f = (float)(startPos.f_82479_ - ePosX);
        float f1 = (float)(startPos.f_82480_ - ePosY);
        float f2 = (float)(startPos.f_82481_ - ePosZ);
        VertexConsumer vertexConsumer = bufferSource.m_6299_(RenderType.m_110475_());
        Matrix4f pose = poseStack.m_85850_().m_252922_();
        float f4 = Mth.m_264536_((float)(f * f + f2 * f2)) * 0.025f / 2.0f;
        float f5 = f2 * f4;
        float f6 = f * f4;
        Vec3 _mEye = entityFrom.m_20299_(partialTicks);
        Vec3 _hEye = entityTo.m_20299_(partialTicks);
        BlockPos mobEyePosition = new BlockPos((int)org.joml.Math.floor((double)_mEye.f_82479_), (int)org.joml.Math.floor((double)_mEye.f_82480_), (int)org.joml.Math.floor((double)_mEye.f_82481_));
        BlockPos holderEyePos = new BlockPos((int)org.joml.Math.floor((double)_hEye.f_82479_), (int)org.joml.Math.floor((double)_hEye.f_82480_), (int)org.joml.Math.floor((double)_hEye.f_82481_));
        int mobLightLevel = ChainUtils.getBlockLightLevel(entityFrom, mobEyePosition);
        int holderLightLevel = ChainUtils.getBlockLightLevel(entityTo, holderEyePos);
        int mobBrightness = entityFrom.m_9236_().m_45517_(LightLayer.SKY, mobEyePosition);
        int holderBrightness = entityFrom.m_9236_().m_45517_(LightLayer.SKY, holderEyePos);
        for (int i = 0; i <= 24; ++i) {
            ChainUtils.addChainLink(vertexConsumer, pose, f, f1, f2, mobLightLevel, holderLightLevel, mobBrightness, holderBrightness, 0.025f, 0.025f, f5, f6, i, false, distance);
        }
        poseStack.m_85849_();
    }

    public static void renderHorizontalFrom(Entity entityTo, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, Entity entityFrom, float distance) {
        if (entityTo == null) {
            return;
        }
        poseStack.m_85836_();
        Vec3 startPos = entityTo.m_20318_(partialTicks).m_82549_(new Vec3(0.0, 1.4, 0.0));
        double d0 = (double)(Mth.m_14179_((float)partialTicks, (float)entityFrom.f_19859_, (float)entityFrom.f_19859_) * ((float)Math.PI / 180)) + 1.5707963267948966;
        Vec3 endPosOffset = entityFrom.m_7398_(partialTicks).m_82546_(entityFrom.m_20182_());
        double d1 = org.joml.Math.cos((double)d0) * endPosOffset.f_82481_ + org.joml.Math.sin((double)d0) * endPosOffset.f_82479_;
        double d2 = org.joml.Math.sin((double)d0) * endPosOffset.f_82481_ - org.joml.Math.cos((double)d0) * endPosOffset.f_82479_;
        double ePosX = Mth.m_14139_((double)partialTicks, (double)entityFrom.f_19854_, (double)entityFrom.m_20185_()) + d1;
        double ePosY = Mth.m_14139_((double)partialTicks, (double)entityFrom.f_19855_, (double)entityFrom.m_20186_()) + endPosOffset.f_82480_;
        double ePosZ = Mth.m_14139_((double)partialTicks, (double)entityFrom.f_19856_, (double)entityFrom.m_20189_()) + d2;
        poseStack.m_85837_(d1, endPosOffset.f_82480_, d2);
        float x = (float)(startPos.f_82479_ - ePosX);
        float y = (float)(startPos.f_82480_ - ePosY);
        float z = (float)(startPos.f_82481_ - ePosZ);
        VertexConsumer vertexConsumer = bufferSource.m_6299_(RenderType.m_110475_());
        Matrix4f pose = poseStack.m_85850_().m_252922_();
        float f4 = Mth.m_264536_((float)(x * x + z * z)) * 0.025f / 2.0f;
        float f5 = z * f4;
        float f6 = x * f4;
        Vec3 _mEye = entityFrom.m_20299_(partialTicks);
        Vec3 _hEye = entityTo.m_20299_(partialTicks);
        BlockPos mobEyePosition = new BlockPos((int)org.joml.Math.floor((double)_mEye.f_82479_), (int)org.joml.Math.floor((double)_mEye.f_82480_), (int)org.joml.Math.floor((double)_mEye.f_82481_));
        BlockPos holderEyePos = new BlockPos((int)org.joml.Math.floor((double)_hEye.f_82479_), (int)org.joml.Math.floor((double)_hEye.f_82480_), (int)org.joml.Math.floor((double)_hEye.f_82481_));
        int mobLightLevel = ChainUtils.getBlockLightLevel(entityFrom, mobEyePosition);
        int holderLightLevel = ChainUtils.getBlockLightLevel(entityTo, holderEyePos);
        int mobBrightness = entityFrom.m_9236_().m_45517_(LightLayer.SKY, mobEyePosition);
        int holderBrightness = entityFrom.m_9236_().m_45517_(LightLayer.SKY, holderEyePos);
        for (int i = 0; i <= 24; ++i) {
            ChainUtils.addChainLink(vertexConsumer, pose, x, y, z, mobLightLevel, holderLightLevel, mobBrightness, holderBrightness, 0.025f, 0.0f, f5, f6, i, true, distance);
        }
        poseStack.m_85849_();
    }

    public static void renderVerticalTo(Entity entityFrom, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, Entity entityTo, float distance) {
        if (entityTo == null) {
            return;
        }
        poseStack.m_85836_();
        Vec3 startPos = entityTo.m_7398_(partialTicks);
        double d0 = (double)(Mth.m_14179_((float)partialTicks, (float)entityFrom.f_19859_, (float)entityFrom.f_19859_) * ((float)Math.PI / 180)) + 1.5707963267948966;
        Vec3 endPosOffset = entityFrom.m_245894_(partialTicks);
        double d1 = org.joml.Math.cos((double)d0) * endPosOffset.f_82481_ + org.joml.Math.sin((double)d0) * endPosOffset.f_82479_;
        double d2 = org.joml.Math.sin((double)d0) * endPosOffset.f_82481_ - org.joml.Math.cos((double)d0) * endPosOffset.f_82479_;
        double ePosX = Mth.m_14139_((double)partialTicks, (double)entityFrom.f_19854_, (double)entityFrom.m_20185_()) + d1;
        double ePosY = Mth.m_14139_((double)partialTicks, (double)entityFrom.f_19855_, (double)entityFrom.m_20186_()) + endPosOffset.f_82480_;
        double ePosZ = Mth.m_14139_((double)partialTicks, (double)entityFrom.f_19856_, (double)entityFrom.m_20189_()) + d2;
        poseStack.m_85837_(d1, endPosOffset.f_82480_, d2);
        float f = (float)(startPos.f_82479_ - ePosX);
        float f1 = (float)(startPos.f_82480_ - ePosY);
        float f2 = (float)(startPos.f_82481_ - ePosZ);
        VertexConsumer vertexConsumer = bufferSource.m_6299_(RenderType.m_110475_());
        Matrix4f pose = poseStack.m_85850_().m_252922_();
        float f4 = Mth.m_264536_((float)(f * f + f2 * f2)) * 0.025f / 2.0f;
        float f5 = f2 * f4;
        float f6 = f * f4;
        Vec3 _mEye = entityFrom.m_20299_(partialTicks);
        Vec3 _hEye = entityTo.m_20299_(partialTicks);
        BlockPos mobEyePosition = new BlockPos((int)org.joml.Math.floor((double)_mEye.f_82479_), (int)org.joml.Math.floor((double)_mEye.f_82480_), (int)org.joml.Math.floor((double)_mEye.f_82481_));
        BlockPos holderEyePos = new BlockPos((int)org.joml.Math.floor((double)_hEye.f_82479_), (int)org.joml.Math.floor((double)_hEye.f_82480_), (int)org.joml.Math.floor((double)_hEye.f_82481_));
        int mobLightLevel = ChainUtils.getBlockLightLevel(entityFrom, mobEyePosition);
        int holderLightLevel = ChainUtils.getBlockLightLevel(entityTo, holderEyePos);
        int mobBrightness = entityFrom.m_9236_().m_45517_(LightLayer.SKY, mobEyePosition);
        int holderBrightness = entityFrom.m_9236_().m_45517_(LightLayer.SKY, holderEyePos);
        for (int i = 0; i <= 24; ++i) {
            ChainUtils.addChainLink(vertexConsumer, pose, f, f1, f2, mobLightLevel, holderLightLevel, mobBrightness, holderBrightness, 0.025f, 0.025f, f5, f6, i, false, distance);
        }
        poseStack.m_85849_();
    }

    public static void renderHorizontalTo(Entity entityFrom, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, Entity entityTo, float distance) {
        if (entityTo == null) {
            return;
        }
        poseStack.m_85836_();
        Vec3 startPos = entityTo.m_7398_(partialTicks);
        double d0 = (double)(Mth.m_14179_((float)partialTicks, (float)entityFrom.f_19859_, (float)entityFrom.f_19859_) * ((float)Math.PI / 180)) + 1.5707963267948966;
        Vec3 endPosOffset = entityFrom.m_245894_(partialTicks);
        double d1 = org.joml.Math.cos((double)d0) * endPosOffset.f_82481_ + org.joml.Math.sin((double)d0) * endPosOffset.f_82479_;
        double d2 = org.joml.Math.sin((double)d0) * endPosOffset.f_82481_ - org.joml.Math.cos((double)d0) * endPosOffset.f_82479_;
        double ePosX = Mth.m_14139_((double)partialTicks, (double)entityFrom.f_19854_, (double)entityFrom.m_20185_()) + d1;
        double ePosY = Mth.m_14139_((double)partialTicks, (double)entityFrom.f_19855_, (double)entityFrom.m_20186_()) + endPosOffset.f_82480_;
        double ePosZ = Mth.m_14139_((double)partialTicks, (double)entityFrom.f_19856_, (double)entityFrom.m_20189_()) + d2;
        poseStack.m_85837_(d1, endPosOffset.f_82480_, d2);
        float x = (float)(startPos.f_82479_ - ePosX);
        float y = (float)(startPos.f_82480_ - ePosY);
        float z = (float)(startPos.f_82481_ - ePosZ);
        VertexConsumer vertexConsumer = bufferSource.m_6299_(RenderType.m_110475_());
        Matrix4f pose = poseStack.m_85850_().m_252922_();
        float f4 = Mth.m_264536_((float)(x * x + z * z)) * 0.025f / 2.0f;
        float f5 = z * f4;
        float f6 = x * f4;
        Vec3 _mEye = entityFrom.m_20299_(partialTicks);
        Vec3 _hEye = entityTo.m_20299_(partialTicks);
        BlockPos mobEyePosition = new BlockPos((int)org.joml.Math.floor((double)_mEye.f_82479_), (int)org.joml.Math.floor((double)_mEye.f_82480_), (int)org.joml.Math.floor((double)_mEye.f_82481_));
        BlockPos holderEyePos = new BlockPos((int)org.joml.Math.floor((double)_hEye.f_82479_), (int)org.joml.Math.floor((double)_hEye.f_82480_), (int)org.joml.Math.floor((double)_hEye.f_82481_));
        int mobLightLevel = ChainUtils.getBlockLightLevel(entityFrom, mobEyePosition);
        int holderLightLevel = ChainUtils.getBlockLightLevel(entityTo, holderEyePos);
        int mobBrightness = entityFrom.m_9236_().m_45517_(LightLayer.SKY, mobEyePosition);
        int holderBrightness = entityFrom.m_9236_().m_45517_(LightLayer.SKY, holderEyePos);
        for (int i = 0; i <= 24; ++i) {
            ChainUtils.addChainLink(vertexConsumer, pose, x, y, z, mobLightLevel, holderLightLevel, mobBrightness, holderBrightness, 0.025f, 0.0f, f5, f6, i, true, distance);
        }
        poseStack.m_85849_();
    }

    protected static int getBlockLightLevel(Entity mob, BlockPos pos) {
        return mob.m_6060_() ? 15 : mob.m_9236_().m_45517_(LightLayer.BLOCK, pos);
    }

    private static void addChainLink(VertexConsumer vertexConsumer, Matrix4f pose, float _x, float _y, float _z, int mobLightLevel, int holderLightLevel, int mobBrightness, int holderBrightness, float endHeight, float startHeight, float xWidth, float zWidth, int index, boolean alternate, float distance) {
        float leashProgress = (float)index / 24.0f;
        int segmentLight = (int)Mth.m_14179_((float)leashProgress, (float)mobLightLevel, (float)holderLightLevel);
        int segmentBrightness = (int)Mth.m_14179_((float)leashProgress, (float)mobBrightness, (float)holderBrightness);
        int lightmap = LightTexture.m_109885_((int)segmentLight, (int)segmentBrightness);
        float[] rr = new float[]{0.28627452f, 0.24313726f, 0.14509805f};
        float[] rg = new float[]{0.3137255f, 0.26666668f, 0.17254902f};
        float[] rb = new float[]{0.39607844f, 0.3254902f, 0.23921569f};
        Random random = new Random(index * 1000);
        int colorI = org.joml.Math.round((float)(random.nextFloat() * 2.49f));
        float r = rr[colorI];
        float g = rg[colorI];
        float b = rb[colorI];
        float vertX = _x * leashProgress;
        float vertY = (_y > 0.0f ? _y * leashProgress * leashProgress : _y - _y * (1.0f - leashProgress) * (1.0f - leashProgress)) - (float)org.joml.Math.sin((double)((double)leashProgress * Math.PI)) * (0.6f * -(distance - 1.0f));
        float vertZ = _z * leashProgress;
        float nextLeashProgress = (float)(index + 1) / 24.0f;
        float vertX1 = _x * nextLeashProgress;
        float vertY1 = (_y > 0.0f ? _y * nextLeashProgress * nextLeashProgress : _y - _y * (1.0f - nextLeashProgress) * (1.0f - nextLeashProgress)) - (float)org.joml.Math.sin((double)((double)leashProgress * Math.PI)) * (0.6f * -(distance - 1.0f));
        float vertZ1 = _z * nextLeashProgress;
        float xWidth1 = xWidth * 2.0f;
        float zWidth1 = zWidth * 2.0f;
        float height = startHeight * 2.0f;
        float eHeight = endHeight * 2.0f;
        vertexConsumer.m_252986_(pose, vertX - xWidth1, vertY + height, vertZ + zWidth1).m_85950_(r, g, b, 0.0f).m_85969_(lightmap).m_5752_();
        if (index % 2 == (alternate ? 1 : 0)) {
            vertexConsumer.m_252986_(pose, vertX - xWidth1, vertY + height, vertZ + zWidth1).m_85950_(r, g, b, 0.0f).m_85969_(lightmap).m_5752_();
            vertexConsumer.m_252986_(pose, vertX + xWidth1, vertY + eHeight - height, vertZ - zWidth1).m_85950_(r, g, b, 0.0f).m_85969_(lightmap).m_5752_();
            vertexConsumer.m_252986_(pose, vertX1 - xWidth1, vertY1 + height, vertZ1 + zWidth1).m_85950_(r, g, b, 0.0f).m_85969_(lightmap).m_5752_();
            vertexConsumer.m_252986_(pose, vertX1 + xWidth1, vertY1 + eHeight - height, vertZ1 - zWidth1).m_85950_(r, g, b, 0.0f).m_85969_(lightmap).m_5752_();
        } else {
            vertexConsumer.m_252986_(pose, vertX - xWidth1, vertY + height, vertZ + zWidth1).m_85950_(r, g, b, 0.0f).m_85969_(lightmap).m_5752_();
        }
    }
}

