/*
 * Decompiled with CFR 0.152.
 */
package com.lazrproductions.cuffed.packet;

import com.lazrproductions.cuffed.CuffedMod;
import com.lazrproductions.cuffed.api.CuffedAPI;
import com.lazrproductions.cuffed.cap.RestrainableCapability;
import com.lazrproductions.cuffed.restraints.RestraintAPI;
import com.lazrproductions.cuffed.restraints.base.AbstractArmRestraint;
import com.lazrproductions.cuffed.restraints.base.AbstractHeadRestraint;
import com.lazrproductions.cuffed.restraints.base.AbstractLegRestraint;
import com.lazrproductions.cuffed.restraints.base.RestraintType;
import com.lazrproductions.lazrslib.common.network.packet.ParameterizedLazrPacket;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.UUID;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class RestraintEquippedPacket
extends ParameterizedLazrPacket {
    int playerId;
    String playerUUID;
    int type;
    String oldData;
    String newData;
    String captorUUID;

    public RestraintEquippedPacket(int playerId, String playerUUID, @Nonnull RestraintType type, @Nullable CompoundTag oldData, @Nullable CompoundTag newData, String captorUUID) {
        super(new Object[]{playerId, playerUUID, type.toInteger(), oldData != null ? oldData.m_7916_() : "null", newData != null ? newData.m_7916_() : "null", captorUUID});
        this.playerId = playerId;
        this.playerUUID = playerUUID;
        this.type = type.toInteger();
        this.oldData = oldData != null ? oldData.m_7916_() : "null";
        this.newData = newData != null ? newData.m_7916_() : "null";
        this.captorUUID = captorUUID;
    }

    public RestraintEquippedPacket(FriendlyByteBuf buf) {
        super(buf);
    }

    public void loadValues(Object[] arg0) {
        this.playerId = (Integer)arg0[0];
        this.playerUUID = (String)arg0[1];
        this.type = (Integer)arg0[2];
        this.oldData = (String)arg0[3];
        this.newData = (String)arg0[4];
        this.captorUUID = (String)arg0[5];
    }

    public void handleClientside(Supplier<NetworkEvent.Context> ctx) {
        Clientside.handleClientside(ctx, this.playerId, this.playerUUID, this.type, this.oldData, this.newData, this.captorUUID);
    }

    public void handleServerside(Supplier<NetworkEvent.Context> ctx) {
    }

    static class Clientside {
        Clientside() {
        }

        public static void handleClientside(Supplier<NetworkEvent.Context> ctx, int playerId, String playerUUID, int type, String oldData, String newData, String captorUUID) {
            Minecraft inst = Minecraft.m_91087_();
            LocalPlayer arg0 = inst.f_91074_;
            if (arg0 != null) {
                RestrainableCapability cap = (RestrainableCapability)CuffedAPI.Capabilities.getRestrainableCapability((Player)arg0);
                try {
                    Player captor;
                    CompoundTag newTag = newData.toLowerCase().equals("null") ? null : TagParser.m_129359_((String)newData);
                    CompoundTag oldTag = oldData.toLowerCase().equals("null") ? null : TagParser.m_129359_((String)oldData);
                    Player player = captor = !captorUUID.equals("null") ? arg0.m_9236_().m_46003_(UUID.fromString(captorUUID)) : null;
                    if (type == RestraintType.Arm.toInteger()) {
                        if (!newData.toLowerCase().equals("null")) {
                            cap.armRestraint = (AbstractArmRestraint)RestraintAPI.getRestraintFromTag(newTag);
                            cap.armRestraint.onEquippedClient((Player)arg0, captor);
                        } else {
                            cap.armRestraint = null;
                        }
                        if (!oldData.toLowerCase().equals("null")) {
                            AbstractArmRestraint oldRestraint = (AbstractArmRestraint)RestraintAPI.getRestraintFromTag(oldTag);
                            oldRestraint.onUnequippedClient((Player)arg0);
                        }
                    } else if (type == RestraintType.Leg.toInteger()) {
                        if (!newData.toLowerCase().equals("null")) {
                            cap.legRestraint = (AbstractLegRestraint)RestraintAPI.getRestraintFromTag(newTag);
                            cap.legRestraint.onEquippedClient((Player)arg0, captor);
                        } else {
                            cap.legRestraint = null;
                        }
                        if (!oldData.toLowerCase().equals("null")) {
                            AbstractLegRestraint oldRestraint = (AbstractLegRestraint)RestraintAPI.getRestraintFromTag(oldTag);
                            oldRestraint.onUnequippedClient((Player)arg0);
                        }
                    } else if (type == RestraintType.Head.toInteger()) {
                        if (!newData.toLowerCase().equals("null")) {
                            cap.headRestraint = (AbstractHeadRestraint)RestraintAPI.getRestraintFromTag(newTag);
                            cap.headRestraint.onEquippedClient((Player)arg0, captor);
                        } else {
                            cap.headRestraint = null;
                        }
                        if (!oldData.toLowerCase().equals("null")) {
                            AbstractHeadRestraint oldRestraint = (AbstractHeadRestraint)RestraintAPI.getRestraintFromTag(oldTag);
                            oldRestraint.onUnequippedClient((Player)arg0);
                        }
                    }
                }
                catch (CommandSyntaxException exception) {
                    CuffedMod.LOGGER.warn("NBT was received in incorrect format!");
                }
            }
        }
    }
}

