/*
 * Decompiled with CFR 0.152.
 */
package com.lazrproductions.cuffed.entity.renderer;

import com.lazrproductions.cuffed.entity.CrumblingBlockEntity;
import com.lazrproductions.cuffed.entity.model.CrumblingBlockModel;
import com.lazrproductions.cuffed.init.ModModelLayers;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CrumblingBlockRenderer
extends EntityRenderer<CrumblingBlockEntity> {
    public static ResourceLocation TEXTURE_LOCATION_1 = new ResourceLocation("cuffed", "textures/entity/crumbling_block_1.png");
    public static ResourceLocation TEXTURE_LOCATION_2 = new ResourceLocation("cuffed", "textures/entity/crumbling_block_2.png");
    public static ResourceLocation TEXTURE_LOCATION_3 = new ResourceLocation("cuffed", "textures/entity/crumbling_block_3.png");
    public static ResourceLocation TEXTURE_LOCATION_4 = new ResourceLocation("cuffed", "textures/entity/crumbling_block_4.png");
    public CrumblingBlockModel<?> model;

    public CrumblingBlockRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
        this.model = new CrumblingBlockModel(ctx.m_174023_(ModModelLayers.CRUMBLING_BLOCK_LAYER));
    }

    public void render(@Nonnull CrumblingBlockEntity entity, float p_114486_, float deltaTick, @Nonnull PoseStack stack, @Nonnull MultiBufferSource buffer, int bakedLight) {
        super.m_7392_((Entity)entity, p_114486_, deltaTick, stack, buffer, bakedLight);
        this.model.m_7695_(stack, buffer.m_6299_(RenderType.m_110473_((ResourceLocation)this.getTextureLocation(entity))), 15, CrumblingBlockRenderer.getOverlayCoords(entity, 0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public ResourceLocation getTextureLocation(@Nonnull CrumblingBlockEntity entity) {
        switch (entity.getCrumbleProgress()) {
            case 1: {
                return TEXTURE_LOCATION_1;
            }
            case 2: {
                return TEXTURE_LOCATION_2;
            }
            case 3: {
                return TEXTURE_LOCATION_3;
            }
            case 4: {
                return TEXTURE_LOCATION_4;
            }
            case 5: {
                return TEXTURE_LOCATION_4;
            }
        }
        return TEXTURE_LOCATION_1;
    }

    public static int getOverlayCoords(CrumblingBlockEntity entity, float f) {
        return OverlayTexture.m_118093_((int)OverlayTexture.m_118088_((float)f), (int)OverlayTexture.m_118096_((boolean)false));
    }
}

