/*
 * Decompiled with CFR 0.152.
 */
package com.lazrproductions.cuffed.effect;

import com.lazrproductions.cuffed.init.ModEffects;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraftforge.common.ForgeMod;

public class RestrainedEffectInstance
extends MobEffectInstance {
    public static final UUID NEGATIVE_MINE_SPEED_UUID = UUID.fromString("bc5de830-355c-419e-9b16-a54b74e8ebe4");
    public static final UUID NEGATIVE_MOVE_SPEED_UUID = UUID.fromString("a42a112a-a81f-43be-8e00-a35c1e646494");
    public static final UUID NEGATIVE_SWIM_SPEED_UUID = UUID.fromString("7ccc7ac4-bc59-4467-ad64-fca99c9e0413");
    public boolean noMining;
    public boolean noItemUse;
    public boolean noMovement;
    public boolean noJumping;

    public RestrainedEffectInstance(int duration, int restraintType) {
        super((MobEffect)ModEffects.RESTRAINED_EFFECT.get(), duration, restraintType);
        boolean[] decodedValues = RestrainedEffectInstance.decodeRestraintProperties(restraintType);
        this.noMining = decodedValues[0];
        this.noItemUse = decodedValues[1];
        this.noMovement = decodedValues[2];
        this.noJumping = decodedValues[3];
    }

    private boolean m_267725_() {
        return this.m_267577_() || this.m_19557_() > 0;
    }

    public void m_19550_(@Nonnull LivingEntity entity) {
        if (this.m_267725_()) {
            super.m_19550_(entity);
            AttributeInstance attackSpeed = entity.m_21051_(Attributes.f_22283_);
            AttributeInstance moveSpeed = entity.m_21051_(Attributes.f_22279_);
            AttributeInstance swimSpeed = entity.m_21051_((Attribute)ForgeMod.SWIM_SPEED.get());
            if (this.noMining && !entity.m_21204_().m_22154_(Attributes.f_22283_, NEGATIVE_MINE_SPEED_UUID) && attackSpeed != null) {
                attackSpeed.m_22118_(new AttributeModifier(NEGATIVE_MINE_SPEED_UUID, "restrainMineSpeed", -9.0, AttributeModifier.Operation.MULTIPLY_TOTAL));
            }
            if (this.noMovement && !entity.m_21204_().m_22154_(Attributes.f_22279_, NEGATIVE_MOVE_SPEED_UUID) && moveSpeed != null) {
                moveSpeed.m_22118_(new AttributeModifier(NEGATIVE_MOVE_SPEED_UUID, "restrainMovementSpeed", -9.0, AttributeModifier.Operation.MULTIPLY_TOTAL));
            }
            if (this.noMovement && !entity.m_21204_().m_22154_((Attribute)ForgeMod.SWIM_SPEED.get(), NEGATIVE_SWIM_SPEED_UUID) && swimSpeed != null) {
                swimSpeed.m_22118_(new AttributeModifier(NEGATIVE_SWIM_SPEED_UUID, "restrainSwimSpeed", -9.0, AttributeModifier.Operation.MULTIPLY_TOTAL));
            }
        } else {
            AttributeInstance attackSpeed = entity.m_21051_(Attributes.f_22283_);
            AttributeInstance moveSpeed = entity.m_21051_(Attributes.f_22279_);
            AttributeInstance swimSpeed = entity.m_21051_((Attribute)ForgeMod.SWIM_SPEED.get());
            if (this.noMining && !entity.m_21204_().m_22154_(Attributes.f_22283_, NEGATIVE_MINE_SPEED_UUID) && attackSpeed != null) {
                attackSpeed.m_22118_(new AttributeModifier(NEGATIVE_MINE_SPEED_UUID, "restrainMineSpeed", -9.0, AttributeModifier.Operation.MULTIPLY_TOTAL));
            }
            if (this.noMovement && !entity.m_21204_().m_22154_(Attributes.f_22283_, NEGATIVE_MOVE_SPEED_UUID) && moveSpeed != null) {
                moveSpeed.m_22118_(new AttributeModifier(NEGATIVE_MOVE_SPEED_UUID, "restrainMovementSpeed", -9.0, AttributeModifier.Operation.MULTIPLY_TOTAL));
            }
            if (this.noMovement && !entity.m_21204_().m_22154_((Attribute)ForgeMod.SWIM_SPEED.get(), NEGATIVE_SWIM_SPEED_UUID) && swimSpeed != null) {
                swimSpeed.m_22118_(new AttributeModifier(NEGATIVE_SWIM_SPEED_UUID, "restrainSwimSpeed", -9.0, AttributeModifier.Operation.MULTIPLY_TOTAL));
            }
        }
    }

    public String m_19576_() {
        return "effect.cuffed.restrained";
    }

    public boolean m_19572_() {
        return false;
    }

    public static int encodeRestraintProperties(boolean noMining, boolean noItemUse, boolean noMovement, boolean noJumping) {
        int encodedValue = 0;
        if (noMining) {
            encodedValue |= 1;
        }
        if (noItemUse) {
            encodedValue |= 2;
        }
        if (noMovement) {
            encodedValue |= 4;
        }
        if (noJumping) {
            encodedValue |= 8;
        }
        return encodedValue;
    }

    public static boolean[] decodeRestraintProperties(int v) {
        boolean[] decodedValues = new boolean[]{(v & 1) != 0, (v & 2) != 0, (v & 4) != 0, (v & 8) != 0};
        return decodedValues;
    }

    public static boolean decodeNoMining(int v) {
        boolean[] decodedValues = RestrainedEffectInstance.decodeRestraintProperties(v);
        return decodedValues[0];
    }

    public static boolean decodeNoItemUse(int v) {
        boolean[] decodedValues = RestrainedEffectInstance.decodeRestraintProperties(v);
        return decodedValues[1];
    }

    public static boolean decodeNoMovement(int v) {
        boolean[] decodedValues = RestrainedEffectInstance.decodeRestraintProperties(v);
        return decodedValues[2];
    }

    public static boolean decodeNoJumping(int v) {
        boolean[] decodedValues = RestrainedEffectInstance.decodeRestraintProperties(v);
        return decodedValues[3];
    }
}

