/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.recipe;

import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.action.brewing.ActionAddBrewingRecipe;
import com.blamejared.crafttweaker.api.action.brewing.ActionRemoveBrewingRecipe;
import com.blamejared.crafttweaker.api.action.brewing.ActionRemoveBrewingRecipeByInput;
import com.blamejared.crafttweaker.api.action.brewing.ActionRemoveBrewingRecipeByPotionInput;
import com.blamejared.crafttweaker.api.action.brewing.ActionRemoveBrewingRecipeByPotionOutput;
import com.blamejared.crafttweaker.api.action.brewing.ActionRemoveBrewingRecipeByReagent;
import com.blamejared.crafttweaker.api.action.brewing.ActionRemovePotionBrewingRecipe;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.mixin.common.access.brewing.AccessBrewingRecipeRegistry;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraftforge.common.brewing.BrewingRecipe;
import org.openzen.zencode.java.ZenCodeGlobals;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.recipe.Brewing")
@Document(value="forge/api/recipe/brewing/Brewing")
public final class CTBrewing {
    @ZenCodeGlobals.Global(value="brewing")
    public static final CTBrewing INSTANCE = new CTBrewing();

    private CTBrewing() {
    }

    @ZenCodeType.Method
    public void addRecipe(IItemStack output, IIngredient reagent, IIngredient input) {
        BrewingRecipe recipe = new BrewingRecipe(input.asVanillaIngredient(), reagent.asVanillaIngredient(), output.getInternal());
        CraftTweakerAPI.apply(new ActionAddBrewingRecipe(AccessBrewingRecipeRegistry.crafttweaker$getRecipes(), recipe));
    }

    @ZenCodeType.Method
    public void removeRecipe(Potion output, IItemStack reagent, Potion input) {
        CraftTweakerAPI.apply(new ActionRemovePotionBrewingRecipe(AccessBrewingRecipeRegistry.crafttweaker$getRecipes(), output, reagent, input));
    }

    @ZenCodeType.Method
    public void removeRecipe(IItemStack output, IItemStack reagent, IItemStack input) {
        CraftTweakerAPI.apply(new ActionRemoveBrewingRecipe(AccessBrewingRecipeRegistry.crafttweaker$getRecipes(), output, reagent, input));
    }

    @ZenCodeType.Method
    public void removeRecipeByReagent(IItemStack reagent) {
        CraftTweakerAPI.apply(new ActionRemoveBrewingRecipeByReagent(AccessBrewingRecipeRegistry.crafttweaker$getRecipes(), reagent));
    }

    @ZenCodeType.Method
    public void removeRecipeByInput(IItemStack input) {
        CraftTweakerAPI.apply(new ActionRemoveBrewingRecipeByInput(AccessBrewingRecipeRegistry.crafttweaker$getRecipes(), input));
    }

    @ZenCodeType.Method
    public void removeRecipeByOutputPotion(Potion output) {
        CraftTweakerAPI.apply(new ActionRemoveBrewingRecipeByPotionOutput(AccessBrewingRecipeRegistry.crafttweaker$getRecipes(), output));
    }

    @ZenCodeType.Method
    public void removeRecipeByInputPotion(Potion input) {
        CraftTweakerAPI.apply(new ActionRemoveBrewingRecipeByPotionInput(AccessBrewingRecipeRegistry.crafttweaker$getRecipes(), input));
    }
}

