/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.ingredient.type;

import com.blamejared.crafttweaker.api.data.IData;
import com.blamejared.crafttweaker.api.data.converter.tag.TagToDataConverter;
import com.blamejared.crafttweaker.api.ingredient.serializer.IngredientPartialTagSerializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;

public class IngredientPartialTag
extends Ingredient {
    private final ItemStack stack;

    public IngredientPartialTag(ItemStack stack) {
        super(Stream.of(new Ingredient.ItemValue(stack)));
        this.stack = stack;
    }

    public boolean test(@Nullable ItemStack input) {
        if (input == null) {
            return false;
        }
        CompoundTag stack1Tag = this.stack.m_41783_();
        CompoundTag stack2Tag = input.m_41783_();
        if (stack1Tag == null && stack2Tag == null) {
            return true;
        }
        IData stack2Data = TagToDataConverter.convert((Tag)stack2Tag);
        IData stack1Data = TagToDataConverter.convert((Tag)stack1Tag);
        boolean contains = stack1Data == null ? true : stack2Data != null && stack2Data.contains(stack1Data);
        return this.stack.m_41720_() == input.m_41720_() && this.stack.m_41773_() == input.m_41773_() && contains;
    }

    public boolean isSimple() {
        return false;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return IngredientPartialTagSerializer.INSTANCE;
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public JsonElement m_43942_() {
        JsonObject json = new JsonObject();
        json.addProperty("type", CraftingHelper.getID((IIngredientSerializer)IngredientPartialTagSerializer.INSTANCE).toString());
        json.addProperty("item", BuiltInRegistries.f_257033_.m_7981_((Object)this.stack.m_41720_()).toString());
        json.addProperty("count", (Number)this.stack.m_41613_());
        if (this.stack.m_41782_()) {
            json.addProperty("nbt", this.stack.m_41783_().toString());
        }
        return json;
    }
}

