/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.action.misc;

import com.blamejared.crafttweaker.api.action.base.IUndoableAction;
import com.blamejared.crafttweaker.api.action.internal.CraftTweakerAction;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.zencode.IScriptLoadSource;
import net.minecraft.world.level.block.ComposterBlock;
import org.apache.logging.log4j.Logger;

public class ActionSetCompostable
extends CraftTweakerAction
implements IUndoableAction {
    private final IItemStack stack;
    private final float newValue;
    private final float oldValue;

    public ActionSetCompostable(IItemStack stack, float newValue) {
        this.stack = stack;
        this.newValue = newValue;
        this.oldValue = ComposterBlock.f_51914_.getOrDefault((Object)stack.getInternal().m_41720_(), -1.0f);
    }

    @Override
    public void apply() {
        if (this.newValue <= 0.0f) {
            ComposterBlock.f_51914_.remove((Object)this.stack.getInternal().m_41720_());
        } else {
            ComposterBlock.f_51914_.put((Object)this.stack.getInternal().m_41720_(), this.newValue);
        }
    }

    @Override
    public String describe() {
        return "Setting Composter value of: " + this.stack.getCommandString() + ", to: " + this.newValue + ", from: " + this.oldValue;
    }

    @Override
    public void undo() {
        if (this.oldValue <= 0.0f) {
            ComposterBlock.f_51914_.remove((Object)this.stack.getInternal().m_41720_());
        } else {
            ComposterBlock.f_51914_.put((Object)this.stack.getInternal().m_41720_(), this.oldValue);
        }
    }

    @Override
    public String describeUndo() {
        return "Undoing setting Composter value of: " + this.stack.getCommandString() + ", to: " + this.newValue + ", reverting to: " + this.oldValue;
    }

    @Override
    public boolean shouldApplyOn(IScriptLoadSource source, Logger logger) {
        return true;
    }
}

