/*
 * Decompiled with CFR 0.152.
 */
package com.wulian.chatimpressiveanimation.forge.mixin;

import com.llamalad7.mixinextras.sugar.Local;
import com.wulian.chatimpressiveanimation.ChatImpressiveAnimationExpectPlatform;
import com.wulian.chatimpressiveanimation.config.ConfigUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.GuiMessage;
import net.minecraft.client.GuiMessageTag;
import net.minecraft.client.gui.components.ChatComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MessageSignature;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={ChatComponent.class})
public class ChatHudMixin {
    @Shadow
    private int f_93763_;
    @Shadow
    @Final
    private List<GuiMessage.Line> f_93761_;
    @Unique
    private final ArrayList<Long> messageTimestamps = new ArrayList();
    @Unique
    private final int chatSendingAnimationFadeTime;
    @Unique
    private int chatLineIndex;
    @Unique
    private int chatDisplacementY;

    public ChatHudMixin() {
        this.chatSendingAnimationFadeTime = ConfigUtil.getConfig().chatSendingAnimationFadeTime;
        this.chatDisplacementY = 0;
    }

    @Shadow
    private int m_240691_() {
        return 0;
    }

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/hud/ChatHudLine$Visible;addedTime()I")})
    public void getChatLineIndex(CallbackInfo ci, @Local(ordinal=13) int chatLineIndex) {
        this.chatLineIndex = chatLineIndex;
    }

    @Unique
    private void calculateYOffset() {
        try {
            int lineHeight = this.m_240691_();
            float fadeOffsetYScale = 0.8f;
            float maxDisplacement = (float)lineHeight * fadeOffsetYScale;
            long timestamp = this.messageTimestamps.get(this.chatLineIndex);
            long timeAlive = System.currentTimeMillis() - timestamp;
            if (this.chatLineIndex == 0 && timeAlive < (long)this.chatSendingAnimationFadeTime && this.f_93763_ == 0) {
                this.chatDisplacementY = (int)(maxDisplacement - (float)timeAlive / (float)this.chatSendingAnimationFadeTime * maxDisplacement);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @ModifyArg(method={"render"}, index=1, at=@At(value="INVOKE", target="Lnet/minecraft/client/util/math/MatrixStack;translate(FFF)V", ordinal=1))
    private float applyYOffset(float y) {
        if (!ConfigUtil.getConfig().enableChatSendingAnimation) {
            return y;
        }
        this.calculateYOffset();
        Object object = ChatImpressiveAnimationExpectPlatform.getObjectShareItem("raised:hud");
        if (object instanceof Integer) {
            Integer distance = (Integer)object;
            y -= (float)distance.intValue();
        } else {
            object = ChatImpressiveAnimationExpectPlatform.getObjectShareItem("raised:distance");
            if (object instanceof Integer) {
                Integer distance = (Integer)object;
                y -= (float)distance.intValue();
            }
        }
        return y + (float)this.chatDisplacementY;
    }

    @Inject(method={"addMessage(Lnet/minecraft/text/Text;Lnet/minecraft/network/message/MessageSignatureData;ILnet/minecraft/client/gui/hud/MessageIndicator;Z)V"}, at={@At(value="TAIL")})
    private void addMessage(Component message, MessageSignature signature, int ticks, GuiMessageTag indicator, boolean refresh, CallbackInfo ci) {
        this.messageTimestamps.add(0, System.currentTimeMillis());
        while (this.messageTimestamps.size() > this.f_93761_.size()) {
            this.messageTimestamps.remove(this.messageTimestamps.size() - 1);
        }
    }
}

