/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.installertools;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import net.minecraftforge.installertools.Task;
import net.minecraftforge.installertools.util.ManifestJson;
import net.minecraftforge.installertools.util.VersionJson;
import net.minecraftforge.srgutils.IMappingFile;

public class DownloadMojmaps
extends Task {
    private static final String MANIFEST_URL = "https://launchermeta.mojang.com/mc/game/version_manifest.json";
    private static final Gson GSON = new GsonBuilder().create();

    @Override
    public void process(String[] args) throws IOException {
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec versionO = parser.accepts("version").withRequiredArg().ofType(String.class).required();
        ArgumentAcceptingOptionSpec sideO = parser.accepts("side").withRequiredArg().ofType(String.class).required();
        ArgumentAcceptingOptionSpec outputO = parser.accepts("output").withRequiredArg().ofType(File.class).required();
        OptionSpecBuilder sanitizeO = parser.accepts("sanitize");
        ArgumentAcceptingOptionSpec formatO = parser.accepts("format").withRequiredArg().ofType(IMappingFile.Format.class);
        OptionSpecBuilder skipIfExistsO = parser.accepts("skipIfExists");
        try {
            OptionSet options = parser.parse(args);
            String mcversion = (String)options.valueOf((OptionSpec)versionO);
            String side = (String)options.valueOf((OptionSpec)sideO);
            File output = ((File)options.valueOf((OptionSpec)outputO)).getAbsoluteFile();
            boolean sanitize = options.has((OptionSpec)sanitizeO);
            IMappingFile.Format format = !options.has((OptionSpec)formatO) ? IMappingFile.Format.TSRG : (IMappingFile.Format)options.valueOf((OptionSpec)formatO);
            boolean skip = options.has((OptionSpec)skipIfExistsO);
            this.log("MC Version: " + mcversion);
            this.log("Side:       " + side);
            this.log("Output:     " + output);
            this.log("Sanitize:   " + sanitize);
            this.log("Format:     " + format);
            this.log("Skip:       " + skip);
            if (output.exists() && skip) {
                this.log("Skipping as output file exists");
                return;
            }
            File parent = output.getParentFile();
            if (parent != null && !parent.exists() && !parent.mkdirs()) {
                this.error("Could not make output folders: " + parent);
            }
            try (InputStream manIn = new URL(MANIFEST_URL).openStream();){
                URL url = ((ManifestJson)GSON.fromJson((Reader)new InputStreamReader(manIn), ManifestJson.class)).getUrl(mcversion);
                if (url == null) {
                    this.error("Missing version from manifest: " + mcversion);
                }
                try (InputStream verIn = url.openStream();){
                    VersionJson.Download download;
                    VersionJson json = VersionJson.load(verIn);
                    if (json == null) {
                        this.error("Missing Minecraft version JSON from URL " + url);
                    }
                    if ((download = json.downloads.get(side + "_mappings")) == null || download.url == null) {
                        this.error("Missing download info for " + side + " mappings");
                    }
                    if (sanitize) {
                        try (InputStream is = download.url.openStream();){
                            IMappingFile map = IMappingFile.load((InputStream)is);
                            map.write(output.toPath(), format, false);
                        }
                    } else {
                        Files.copy(download.url.openStream(), output.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    }
                    this.log("Downloaded Mojang mappings for " + mcversion);
                }
            }
        }
        catch (OptionException e) {
            parser.printHelpOn((OutputStream)System.out);
            e.printStackTrace();
        }
    }
}

