/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.authlib.yggdrasil;

import com.google.common.collect.Iterables;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.mojang.authlib.AuthenticationService;
import com.mojang.authlib.Environment;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.authlib.exceptions.AuthenticationUnavailableException;
import com.mojang.authlib.minecraft.BaseMinecraftSessionService;
import com.mojang.authlib.minecraft.InsecurePublicKeyException;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import java.lang.reflect.Type;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.launcher.events.request.CheckServerRequestEvent;
import pro.gravit.launcher.events.request.JoinServerRequestEvent;
import pro.gravit.launcher.events.request.ProfileByUUIDRequestEvent;
import pro.gravit.launcher.profiles.PlayerProfile;
import pro.gravit.launcher.profiles.Texture;
import pro.gravit.launcher.request.RequestException;
import pro.gravit.launcher.request.auth.CheckServerRequest;
import pro.gravit.launcher.request.auth.JoinServerRequest;
import pro.gravit.launcher.request.uuid.ProfileByUUIDRequest;
import pro.gravit.utils.helper.SecurityHelper;

public class YggdrasilMinecraftSessionService
extends BaseMinecraftSessionService {
    public static final boolean NO_TEXTURES = Boolean.getBoolean("launcher.com.mojang.authlib.noTextures");
    private static final Type TEXTURES_TYPE_TOKEN = new TypeToken<Map<MinecraftProfileTexture.Type, MinecraftProfileTexture>>(){}.getType();
    private static final Gson GSON = new GsonBuilder().create();
    private static final Logger logger = LogManager.getLogger(YggdrasilMinecraftSessionService.class);

    public YggdrasilMinecraftSessionService(AuthenticationService service, Environment environment) {
        super(service);
        logger.debug("Patched MinecraftSessionService created");
    }

    public YggdrasilMinecraftSessionService(YggdrasilAuthenticationService service, Environment environment) {
        super(service);
        logger.debug("Patched MinecraftSessionService created");
    }

    public static void fillTextureProperties(GameProfile profile, PlayerProfile pp) {
        logger.debug("fillTextureProperties, Username: '{}'", (Object)profile.getName());
        if (NO_TEXTURES) {
            return;
        }
        HashMap<MinecraftProfileTexture.Type, MinecraftProfileTexture> textures = new HashMap<MinecraftProfileTexture.Type, MinecraftProfileTexture>();
        try {
            if (pp.assets != null) {
                for (MinecraftProfileTexture.Type type : MinecraftProfileTexture.Type.values()) {
                    String name = type.name();
                    Texture texture = (Texture)pp.assets.get(name);
                    if (texture == null) continue;
                    textures.put(type, YggdrasilMinecraftSessionService.makeMinecraftTexture(texture));
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        MinecraftTexturesProperty payload = new MinecraftTexturesProperty();
        payload.textures = textures;
        payload.isPublic = true;
        payload.profileId = pp.uuid.toString().replace("-", "");
        payload.profileName = pp.username;
        String serializedData = Base64.getEncoder().encodeToString(GSON.toJson((Object)payload).getBytes(StandardCharsets.UTF_8));
        logger.debug("Write textures {}", (Object)serializedData);
        Property textureProperty = new Property("textures", serializedData, "");
        profile.getProperties().put("textures", textureProperty);
    }

    private static MinecraftProfileTexture makeMinecraftTexture(Texture texture) {
        return new MinecraftProfileTexture(texture.url, SecurityHelper.toHex((byte[])texture.digest), texture.metadata);
    }

    public static GameProfile toGameProfile(PlayerProfile pp) {
        GameProfile profile = new GameProfile(pp.uuid, pp.username);
        try {
            if (pp.properties != null) {
                PropertyMap propertyMap = profile.getProperties();
                for (Map.Entry prop : pp.properties.entrySet()) {
                    propertyMap.put((String)prop.getKey(), new Property((String)prop.getKey(), (String)prop.getValue(), ""));
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        YggdrasilMinecraftSessionService.fillTextureProperties(profile, pp);
        return profile;
    }

    @Override
    public GameProfile fillProfileProperties(GameProfile profile, boolean requireSecure) {
        PlayerProfile pp;
        UUID uuid = profile.getId();
        logger.debug("fillProfileProperties, UUID: {}", (Object)uuid);
        if (uuid == null) {
            return profile;
        }
        try {
            pp = ((ProfileByUUIDRequestEvent)new ProfileByUUIDRequest((UUID)uuid).request()).playerProfile;
        }
        catch (Exception e) {
            logger.warn("Couldn't fetch profile properties for '{}': {}", (Object)profile, e instanceof RequestException ? e.getMessage() : e);
            return profile;
        }
        if (pp == null) {
            logger.warn("Couldn't fetch profile properties for '{}' as the profile does not exist", (Object)profile);
            return profile;
        }
        logger.debug("Successfully fetched profile properties for '{}'", (Object)profile);
        YggdrasilMinecraftSessionService.fillTextureProperties(profile, pp);
        return YggdrasilMinecraftSessionService.toGameProfile(pp);
    }

    @Override
    public String getSecurePropertyValue(Property property) throws InsecurePublicKeyException {
        return property.getValue();
    }

    @Override
    public Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> getTextures(GameProfile profile, boolean requireSecure) {
        logger.debug("getTextures, Username: '{}', UUID: '{}'", (Object)profile.getName(), (Object)profile.getId());
        EnumMap<MinecraftProfileTexture.Type, MinecraftProfileTexture> textures = new EnumMap<MinecraftProfileTexture.Type, MinecraftProfileTexture>(MinecraftProfileTexture.Type.class);
        if (!NO_TEXTURES) {
            try {
                Property texturesProperty = (Property)Iterables.getFirst((Iterable)profile.getProperties().get("textures"), null);
                if (texturesProperty != null) {
                    logger.trace("Read textures property {}", (Object)texturesProperty.getValue());
                    String serializedData = new String(Base64.getDecoder().decode(texturesProperty.getValue()), StandardCharsets.UTF_8);
                    MinecraftTexturesProperty payload = (MinecraftTexturesProperty)GSON.fromJson(serializedData, MinecraftTexturesProperty.class);
                    Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> texturesMap = payload.textures;
                    textures.putAll(texturesMap);
                }
            }
            catch (Throwable e) {
                logger.error((Object)e);
            }
        }
        for (Map.Entry entry : textures.entrySet()) {
            logger.trace("Found {}: {}", entry.getKey(), (Object)((MinecraftProfileTexture)entry.getValue()).getUrl());
        }
        logger.trace("Found {} textures", (Object)textures.size());
        return textures;
    }

    public GameProfile hasJoinedServer(GameProfile profile, String serverID) throws AuthenticationUnavailableException {
        PlayerProfile pp;
        String username = profile.getName();
        logger.debug("checkServer, Username: '{}', Server ID: {}", (Object)username, (Object)serverID);
        try {
            pp = ((CheckServerRequestEvent)new CheckServerRequest((String)username, (String)serverID).request()).playerProfile;
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new AuthenticationUnavailableException(e);
        }
        return pp == null ? null : YggdrasilMinecraftSessionService.toGameProfile(pp);
    }

    @Override
    public GameProfile hasJoinedServer(GameProfile profile, String serverID, InetAddress address) throws AuthenticationUnavailableException {
        return this.hasJoinedServer(profile, serverID);
    }

    @Override
    public YggdrasilAuthenticationService getAuthenticationService() {
        return (YggdrasilAuthenticationService)super.getAuthenticationService();
    }

    @Override
    public void joinServer(GameProfile profile, String accessToken, String serverID) throws AuthenticationException {
        boolean success;
        String username = profile.getName();
        logger.debug("joinServer, Username: '{}', Access token: {}, Server ID: {}", (Object)username, (Object)accessToken, (Object)serverID);
        try {
            success = ((JoinServerRequestEvent)new JoinServerRequest((String)username, (String)accessToken, (String)serverID).request()).allow;
        }
        catch (RequestException e) {
            throw new AuthenticationException(String.format("RequestException: '%s'. Please restart the launcher and client and try again", e.getMessage()));
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new AuthenticationUnavailableException(e);
        }
        if (!success) {
            throw new AuthenticationException("Failed to verify username (Clientside). Please restart the launcher and client");
        }
    }

    public static class MinecraftTexturesProperty {
        public long timestamp;
        public String profileId;
        public String profileName;
        public boolean isPublic;
        public Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> textures;

        public MinecraftTexturesProperty() {
        }

        public MinecraftTexturesProperty(long timestamp, String profileId, String profileName, boolean isPublic, Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> textures) {
            this.timestamp = timestamp;
            this.profileId = profileId;
            this.profileName = profileName;
            this.isPublic = isPublic;
            this.textures = textures;
        }
    }
}

