/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.client;

import com.mojang.blaze3d.systems.RenderSystem;
import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.gui.GameProfileUtils;
import de.maxhenkel.voicechat.voice.client.ClientManager;
import de.maxhenkel.voicechat.voice.client.ClientVoicechat;
import de.maxhenkel.voicechat.voice.client.GroupPlayerIconOrientation;
import de.maxhenkel.voicechat.voice.common.PlayerState;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;

public class GroupChatManager {
    private static final ResourceLocation TALK_OUTLINE = new ResourceLocation("voicechat", "textures/icons/talk_outline.png");
    private static final ResourceLocation SPEAKER_OFF_ICON = new ResourceLocation("voicechat", "textures/icons/speaker_small_off.png");

    public static void renderIcons(GuiGraphics guiGraphics) {
        ClientVoicechat client = ClientManager.getClient();
        if (client == null) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        List<PlayerState> groupMembers = GroupChatManager.getGroupMembers(VoicechatClient.CLIENT_CONFIG.showOwnGroupIcon.get());
        guiGraphics.m_280168_().m_85836_();
        int posX = VoicechatClient.CLIENT_CONFIG.groupPlayerIconPosX.get();
        int posY = VoicechatClient.CLIENT_CONFIG.groupPlayerIconPosY.get();
        if (posX < 0) {
            guiGraphics.m_280168_().m_85837_((double)mc.m_91268_().m_85445_(), 0.0, 0.0);
        }
        if (posY < 0) {
            guiGraphics.m_280168_().m_85837_(0.0, (double)mc.m_91268_().m_85446_(), 0.0);
        }
        guiGraphics.m_280168_().m_85837_((double)posX, (double)posY, 0.0);
        float scale = VoicechatClient.CLIENT_CONFIG.groupHudIconScale.get().floatValue();
        guiGraphics.m_280168_().m_85841_(scale, scale, 1.0f);
        boolean vertical = VoicechatClient.CLIENT_CONFIG.groupPlayerIconOrientation.get().equals((Object)GroupPlayerIconOrientation.VERTICAL);
        for (int i = 0; i < groupMembers.size(); ++i) {
            PlayerState state = groupMembers.get(i);
            guiGraphics.m_280168_().m_85836_();
            if (vertical) {
                if (posY < 0) {
                    guiGraphics.m_280168_().m_85837_(0.0, (double)i * -11.0, 0.0);
                } else {
                    guiGraphics.m_280168_().m_85837_(0.0, (double)i * 11.0, 0.0);
                }
            } else if (posX < 0) {
                guiGraphics.m_280168_().m_85837_((double)i * -11.0, 0.0, 0.0);
            } else {
                guiGraphics.m_280168_().m_85837_((double)i * 11.0, 0.0, 0.0);
            }
            if (client.getTalkCache().isTalking(state.getUuid())) {
                RenderSystem.setShader(GameRenderer::m_172817_);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                guiGraphics.m_280163_(TALK_OUTLINE, posX < 0 ? -10 : 0, posY < 0 ? -10 : 0, 0.0f, 0.0f, 10, 10, 16, 16);
            }
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            ResourceLocation skin = GameProfileUtils.getSkin(state.getUuid());
            guiGraphics.m_280163_(skin, posX < 0 ? -9 : 1, posY < 0 ? -9 : 1, 8.0f, 8.0f, 8, 8, 64, 64);
            guiGraphics.m_280163_(skin, posX < 0 ? -9 : 1, posY < 0 ? -9 : 1, 40.0f, 8.0f, 8, 8, 64, 64);
            if (state.isDisabled()) {
                guiGraphics.m_280168_().m_85836_();
                guiGraphics.m_280168_().m_85837_(posX < 0 ? -9.0 : 1.0, posY < 0 ? -9.0 : 1.0, 0.0);
                guiGraphics.m_280168_().m_85841_(0.5f, 0.5f, 1.0f);
                RenderSystem.setShader(GameRenderer::m_172817_);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                guiGraphics.m_280163_(SPEAKER_OFF_ICON, 0, 0, 0.0f, 0.0f, 16, 16, 16, 16);
                guiGraphics.m_280168_().m_85849_();
            }
            guiGraphics.m_280168_().m_85849_();
        }
        guiGraphics.m_280168_().m_85849_();
    }

    public static List<PlayerState> getGroupMembers() {
        return GroupChatManager.getGroupMembers(true);
    }

    public static List<PlayerState> getGroupMembers(boolean includeSelf) {
        ArrayList<PlayerState> entries = new ArrayList<PlayerState>();
        UUID group = ClientManager.getPlayerStateManager().getGroupID();
        if (group == null) {
            return entries;
        }
        for (PlayerState state : ClientManager.getPlayerStateManager().getPlayerStates(includeSelf)) {
            if (!state.hasGroup() || !state.getGroup().equals(group)) continue;
            entries.add(state);
        }
        entries.sort(Comparator.comparing(PlayerState::getName));
        return entries;
    }
}

