/*
 * Decompiled with CFR 0.152.
 */
package com.koenigstag.tfc_weight_bar;

import com.koenigstag.tfc_weight_bar.Config;
import com.koenigstag.tfc_weight_bar.Constants;
import com.koenigstag.tfc_weight_bar.WeightBarData;
import com.koenigstag.tfc_weight_bar.WeightBarHelpers;
import net.dries007.tfc.config.TFCConfig;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="tfc_weight_bar", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.DEDICATED_SERVER})
public final class ForgeServerEventHandler {
    public static void init() {
        IEventBus bus = MinecraftForge.EVENT_BUS;
        bus.register(ForgeServerEventHandler.class);
        Constants.LOGGER.info("Setup server event handler complete");
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (!Config.enableWeightCalculations) {
            return;
        }
        Player player = event.player;
        Level level = player.m_9236_();
        if (!level.m_5776_() && !player.m_150110_().f_35934_ && ((Boolean)TFCConfig.SERVER.enableOverburdening.get()).booleanValue() && level.m_46467_() % (long)Config.calculateWeightEachNTicks == 0L) {
            int playerInvWeight = WeightBarHelpers.calculatePlayerFullWeight(player);
            WeightBarData.serverChangeCurrentWeight(player, playerInvWeight);
        }
    }
}

