/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.stackrefill.forge.events;

import com.natamus.stackrefill_common_forge.events.RefillEvent;
import java.util.HashMap;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ForgeRefillEvent {
    private static final HashMap<String, InteractionHand> lasthandused = new HashMap();

    @SubscribeEvent
    public static void onWorldTick(TickEvent.ServerTickEvent e) {
        if (!e.phase.equals((Object)TickEvent.Phase.START)) {
            return;
        }
        RefillEvent.processTick(false);
    }

    @SubscribeEvent
    public static void onItemUse(LivingEntityUseItemEvent.Start e) {
        LivingEntity livingEntity = e.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        ItemStack mainstack = player.m_21205_();
        ItemStack used = e.getItem();
        InteractionHand hand = InteractionHand.MAIN_HAND;
        if (!mainstack.m_41720_().equals(used.m_41720_()) || mainstack.m_41613_() != used.m_41613_()) {
            hand = InteractionHand.OFF_HAND;
        }
        lasthandused.put(player.m_7755_().getString(), hand);
    }

    @SubscribeEvent
    public static void onItemUse(LivingEntityUseItemEvent.Finish e) {
        LivingEntity livingEntity = e.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        String playername = player.m_7755_().getString();
        if (!lasthandused.containsKey(playername)) {
            return;
        }
        RefillEvent.onItemUse(player, e.getItem(), null, lasthandused.get(playername));
    }

    @SubscribeEvent
    public static void onItemBreak(PlayerDestroyItemEvent e) {
        RefillEvent.onItemBreak(e.getEntity(), e.getOriginal(), e.getHand());
    }

    @SubscribeEvent
    public static void onItemToss(ItemTossEvent e) {
        RefillEvent.onItemToss(e.getPlayer(), e.getEntity().m_32055_());
    }

    @SubscribeEvent
    public static void onItemRightClick(PlayerInteractEvent.RightClickItem e) {
        RefillEvent.onItemRightClick(e.getEntity(), e.getLevel(), e.getHand());
    }

    @SubscribeEvent
    public static void onBlockRightClick(PlayerInteractEvent.RightClickBlock e) {
        RefillEvent.onBlockRightClick(e.getLevel(), e.getEntity(), e.getHand(), e.getPos(), e.getHitVec());
    }
}

