/*
 * Decompiled with CFR 0.152.
 */
package com.therighthon.rnr.compat.jade;

import com.therighthon.rnr.common.block.CrackingWetConcretePathBlock;
import com.therighthon.rnr.common.block.WetConcretePathBlock;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.dries007.tfc.common.blockentities.TickCounterBlockEntity;
import net.dries007.tfc.compat.jade.common.BlockEntityTooltip;
import net.dries007.tfc.compat.jade.common.RegisterCallback;
import net.dries007.tfc.util.calendar.Calendars;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockEntityTooltips {
    public static final BlockEntityTooltip WET_CONCRETE = (level, state, pos, entity, tooltip) -> {
        if (entity instanceof TickCounterBlockEntity) {
            TickCounterBlockEntity counter = (TickCounterBlockEntity)entity;
            if (state.m_60734_() instanceof WetConcretePathBlock) {
                BlockEntityTooltips.timeLeft(level, tooltip, 24000L - counter.getTicksSinceUpdate(), (Component)Component.m_237115_((String)"rnr.jade.wet_concrete"));
                if (state.m_60734_() instanceof CrackingWetConcretePathBlock) {
                    BlockEntityTooltips.willCrack(level, tooltip, Math.max((Integer)state.m_61143_((Property)CrackingWetConcretePathBlock.DISTANCE_X), (Integer)state.m_61143_((Property)CrackingWetConcretePathBlock.DISTANCE_Z)));
                }
            }
        }
    };

    public static void register(RegisterCallback<BlockEntityTooltip, Block> callback) {
        callback.register("wet_concrete", (Object)WET_CONCRETE, CrackingWetConcretePathBlock.class);
    }

    public static void timeLeft(Level level, Consumer<Component> tooltip, long ticks, @Nullable Component ifNegative) {
        if (ticks > 0L) {
            tooltip.accept((Component)Component.m_237110_((String)"tfc.jade.time_left", (Object[])new Object[]{Calendars.get((LevelReader)level).getTimeDelta(ticks)}));
        } else if (ifNegative != null) {
            tooltip.accept(ifNegative);
        }
    }

    public static void willCrack(Level level, Consumer<Component> tooltip, int distance) {
        if (distance > 2) {
            tooltip.accept((Component)Component.m_237115_((String)"rnr.jade.will_crack"));
        } else {
            tooltip.accept((Component)Component.m_237115_((String)"rnr.jade.will_not_crack"));
        }
    }
}

