/*
 * Decompiled with CFR 0.152.
 */
package com.therighthon.rnr.common.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.therighthon.rnr.common.recipe.RNRRecipeSerializers;
import com.therighthon.rnr.common.recipe.RNRRecipeTypes;
import javax.annotation.Nullable;
import net.dries007.tfc.common.recipes.SimpleBlockRecipe;
import net.dries007.tfc.common.recipes.ingredients.BlockIngredient;
import net.dries007.tfc.util.JsonHelpers;
import net.dries007.tfc.util.collections.IndirectHashCollection;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockModRecipe
extends SimpleBlockRecipe {
    private final ResourceLocation id;
    private final BlockIngredient inputBlock;
    private final BlockState outputBlock;
    private final Ingredient inputItem;
    private final Boolean consumesItem;
    public static final IndirectHashCollection<Block, BlockModRecipe> CACHE = IndirectHashCollection.createForRecipe(blockModRecipe -> blockModRecipe.getInputBlock().blocks(), RNRRecipeTypes.BLOCK_MOD_RECIPE);

    public BlockModRecipe(ResourceLocation id, Ingredient inputItem, BlockIngredient inputBlock, BlockState outputBlock, Boolean consumesItem) {
        super(id, inputBlock, outputBlock, false);
        this.id = id;
        this.inputItem = inputItem;
        this.inputBlock = inputBlock;
        this.outputBlock = outputBlock;
        this.consumesItem = consumesItem;
    }

    public static BlockModRecipe getRecipe(BlockState state, ItemStack item) {
        for (BlockModRecipe recipe : CACHE.getAll((Object)state.m_60734_())) {
            if (!recipe.matches(state, item)) continue;
            return recipe;
        }
        return null;
    }

    public boolean matches(BlockState state, ItemStack item) {
        return this.inputBlock.test(state) && this.inputItem.test(item);
    }

    public BlockIngredient getInputBlock() {
        return this.inputBlock;
    }

    public Ingredient getInputItem() {
        return this.inputItem;
    }

    public BlockState getOutputBlock() {
        return this.outputBlock;
    }

    public Boolean consumesItem() {
        return this.consumesItem;
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RNRRecipeSerializers.BLOCK_MOD_RECIPE.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)RNRRecipeTypes.BLOCK_MOD_RECIPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<BlockModRecipe> {
        public static final Serializer INSTANCE = new Serializer();
        public static final ResourceLocation ID = new ResourceLocation("rnr", "block_mod");

        public BlockModRecipe fromJson(ResourceLocation id, JsonObject json) {
            Ingredient inputItem = Ingredient.m_43917_((JsonElement)json.get("input_item"));
            BlockIngredient inputBlock = BlockIngredient.fromJson((JsonElement)JsonHelpers.get((JsonObject)json, (String)"input_block"));
            BlockState outputBlock = JsonHelpers.getBlockState((String)GsonHelper.m_13906_((JsonObject)json, (String)"output_block"));
            boolean consumeIngredient = json.has("consume_ingredient") ? JsonHelpers.m_13912_((JsonObject)json, (String)"consume_ingredient") : Boolean.TRUE;
            return new BlockModRecipe(id, inputItem, inputBlock, outputBlock, consumeIngredient);
        }

        @Nullable
        public BlockModRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buffer) {
            Ingredient inputItem = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            BlockIngredient inputBlock = BlockIngredient.fromNetwork((FriendlyByteBuf)buffer);
            BlockState outputBlock = ((Block)buffer.readRegistryIdUnsafe(ForgeRegistries.BLOCKS)).m_49966_();
            Boolean consumesItem = buffer.readBoolean();
            return new BlockModRecipe(id, inputItem, inputBlock, outputBlock, consumesItem);
        }

        public void toNetwork(FriendlyByteBuf buffer, BlockModRecipe recipe) {
            recipe.inputItem.m_43923_(buffer);
            recipe.inputBlock.toNetwork(buffer);
            buffer.writeRegistryIdUnsafe(ForgeRegistries.BLOCKS, (Object)recipe.outputBlock.m_60734_());
            buffer.writeBoolean(recipe.consumesItem.booleanValue());
        }
    }
}

