/*
 * Decompiled with CFR 0.152.
 */
package com.therighthon.rnr.common.block;

import com.therighthon.rnr.common.RNRTags;
import com.therighthon.rnr.common.block.RNRBlockStateProperties;
import com.therighthon.rnr.common.block.RNRBlocks;
import com.therighthon.rnr.common.block.WetConcretePathBlock;
import com.therighthon.rnr.common.block.WetConcretePathControlJointBlock;
import net.dries007.tfc.common.blockentities.TFCBlockEntities;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.util.Helpers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;

public class CrackingWetConcretePathBlock
extends WetConcretePathBlock {
    private final int maxJointDistance = 3;
    public static final IntegerProperty DISTANCE_X = RNRBlockStateProperties.DISTANCE_X;
    public static final IntegerProperty DISTANCE_Z = RNRBlockStateProperties.DISTANCE_Z;
    private final Block base;
    private final BlockState baseState;

    public CrackingWetConcretePathBlock(ExtendedProperties properties) {
        super(properties.speedFactor(CrackingWetConcretePathBlock.getDefaultSpeedFactor()).randomTicks());
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)DISTANCE_X, (Comparable)Integer.valueOf(1))).m_61124_((Property)DISTANCE_Z, (Comparable)Integer.valueOf(1)));
        this.base = Blocks.f_50016_;
        this.baseState = Blocks.f_50016_.m_49966_();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{DISTANCE_X}).m_61104_(new Property[]{DISTANCE_Z});
    }

    @Override
    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        int oldDistanceX = (Integer)state.m_61143_((Property)DISTANCE_X);
        int distanceX = this.updateDistanceX((LevelAccessor)level, pos);
        if (distanceX != oldDistanceX) {
            level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.TICK_COUNTER.get()).ifPresent(counter -> {
                long oldUpdateTick = counter.getLastUpdateTick();
                if ((double)counter.getTicksSinceUpdate() < 0.75 * (double)this.getTicksToDry()) {
                    level.m_46597_(pos, (BlockState)state.m_61124_((Property)DISTANCE_X, (Comparable)Integer.valueOf(Math.min(distanceX, 3))));
                    counter.setLastUpdateTick(oldUpdateTick);
                }
            });
        }
        int oldDistanceZ = (Integer)state.m_61143_((Property)DISTANCE_Z);
        int distanceZ = this.updateDistanceZ((LevelAccessor)level, pos);
        if (distanceZ != oldDistanceZ) {
            level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.TICK_COUNTER.get()).ifPresent(counter -> {
                long oldUpdateTick = counter.getLastUpdateTick();
                if ((double)counter.getTicksSinceUpdate() < 0.75 * (double)this.getTicksToDry()) {
                    level.m_46597_(pos, (BlockState)state.m_61124_((Property)DISTANCE_Z, (Comparable)Integer.valueOf(Math.min(distanceZ, 3))));
                    counter.setLastUpdateTick(oldUpdateTick);
                }
            });
        }
        level.m_141902_(pos, (BlockEntityType)TFCBlockEntities.TICK_COUNTER.get()).ifPresent(counter -> {
            if (counter.getTicksSinceUpdate() > (long)this.getTicksToDry()) {
                level.m_46597_(pos, Math.max((Integer)state.m_61143_((Property)DISTANCE_X), (Integer)state.m_61143_((Property)DISTANCE_Z)) >= 3 ? this.getOutputStateCracked(state) : this.getOutputState(state));
            }
            BlockPos.MutableBlockPos cursor = new BlockPos.MutableBlockPos();
            for (Direction d : Direction.Plane.HORIZONTAL) {
                cursor.m_122159_((Vec3i)pos, d);
                BlockState stateAt = level.m_8055_((BlockPos)cursor);
                if (!(state.m_60734_() instanceof CrackingWetConcretePathBlock) && !(stateAt.m_60734_() instanceof WetConcretePathControlJointBlock)) continue;
                level.m_186460_((BlockPos)cursor, stateAt.m_60734_(), 1);
            }
        });
    }

    public BlockState getOutputStateCracked(BlockState input) {
        if (input.m_60713_((Block)RNRBlocks.WET_CONCRETE_ROAD.get())) {
            return ((Block)RNRBlocks.CRACKED_CONCRETE_ROAD.get()).m_49966_();
        }
        if (input.m_60713_((Block)RNRBlocks.TRODDEN_WET_CONCRETE_ROAD.get())) {
            return ((Block)RNRBlocks.CRACKED_TRODDEN_CONCRETE_ROAD.get()).m_49966_();
        }
        return Blocks.f_50016_.m_49966_();
    }

    private int getDistanceX(BlockState neighbor) {
        Block block = neighbor.m_60734_();
        if (Helpers.isBlock((Block)block, RNRTags.Blocks.WET_CONCRETE_ROADS) && !Helpers.isBlock((Block)neighbor.m_60734_(), RNRTags.Blocks.CONCRETE_CONTROL_JOINTS)) {
            return (Integer)neighbor.m_61143_((Property)DISTANCE_X);
        }
        return 0;
    }

    private int getDistanceZ(BlockState neighbor) {
        Block block = neighbor.m_60734_();
        if (Helpers.isBlock((Block)block, RNRTags.Blocks.WET_CONCRETE_ROADS) && !Helpers.isBlock((Block)neighbor.m_60734_(), RNRTags.Blocks.CONCRETE_CONTROL_JOINTS)) {
            return (Integer)neighbor.m_61143_((Property)DISTANCE_Z);
        }
        return 0;
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        int distanceX = this.getDistanceX(facingState) + 1;
        int distanceZ = this.getDistanceZ(facingState) + 1;
        if (distanceX != 1 || (Integer)state.m_61143_((Property)DISTANCE_X) != distanceX || distanceZ != 1 || (Integer)state.m_61143_((Property)DISTANCE_Z) != distanceZ) {
            level.m_186460_(currentPos, (Block)this, 1);
        }
        return state;
    }

    private int updateDistanceX(LevelAccessor level, BlockPos pos) {
        int distance = 4;
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (Direction direction : new Direction[]{Direction.EAST, Direction.WEST}) {
            mutablePos.m_122190_((Vec3i)pos).m_122173_(direction);
            distance = Math.min(distance, this.getDistanceX(level.m_8055_((BlockPos)mutablePos)) + 1);
            if (distance == 1) break;
        }
        return distance;
    }

    private int updateDistanceZ(LevelAccessor level, BlockPos pos) {
        int distance = 4;
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
        for (Direction direction : new Direction[]{Direction.NORTH, Direction.SOUTH}) {
            mutablePos.m_122190_((Vec3i)pos).m_122173_(direction);
            distance = Math.min(distance, this.getDistanceZ(level.m_8055_((BlockPos)mutablePos)) + 1);
            if (distance == 1) break;
        }
        return distance;
    }
}

