/*
 * Decompiled with CFR 0.152.
 */
package com.therighthon.rnr.common.block;

import com.therighthon.afc.common.blocks.AFCWood;
import com.therighthon.rnr.common.item.RNRItems;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.dries007.tfc.common.blocks.ExtendedProperties;
import net.dries007.tfc.common.blocks.TFCBlocks;
import net.dries007.tfc.util.Helpers;
import net.dries007.tfc.util.registry.RegistrationHelpers;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class AFCCompatBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"rnr");
    public static final BlockBehaviour.Properties ROOF_PROPERTIES = ExtendedProperties.of((MapColor)MapColor.f_283825_).strength(1.0f, 0.6f).noOcclusion().isViewBlocking(TFCBlocks::never).sound(SoundType.f_56736_).flammable(50, 100).properties();
    public static final Map<AFCWood, RegistryObject<Block>> WOOD_SHINGLE_ROOFS = Helpers.mapOfKeys(AFCWood.class, wood -> AFCCompatBlocks.register("wood/shingles/" + wood.m_7912_(), () -> new Block(ROOF_PROPERTIES)));
    public static final Map<AFCWood, RegistryObject<Block>> WOOD_SHINGLE_ROOF_SLABS = Helpers.mapOfKeys(AFCWood.class, wood -> AFCCompatBlocks.register("wood/shingles/" + wood.m_7912_() + "_slab", () -> new SlabBlock(ROOF_PROPERTIES)));
    public static final Map<AFCWood, RegistryObject<Block>> WOOD_SHINGLE_ROOF_STAIRS = Helpers.mapOfKeys(AFCWood.class, wood -> AFCCompatBlocks.register("wood/shingles/" + wood.m_7912_() + "_stairs", () -> new StairBlock(((Block)WOOD_SHINGLE_ROOFS.get(wood).get()).m_49966_(), ROOF_PROPERTIES)));

    private static <T extends Block> RegistryObject<T> registerNoItem(String name, Supplier<T> blockSupplier) {
        return AFCCompatBlocks.register(name, blockSupplier, (Function)null);
    }

    private static <T extends Block> RegistryObject<T> register(String name, Supplier<T> blockSupplier) {
        return AFCCompatBlocks.register(name, blockSupplier, (T block) -> new BlockItem(block, new Item.Properties()));
    }

    private static <T extends Block> RegistryObject<T> register(String name, Supplier<T> blockSupplier, Item.Properties blockItemProperties) {
        return AFCCompatBlocks.register(name, blockSupplier, (T block) -> new BlockItem(block, blockItemProperties));
    }

    private static <T extends Block> RegistryObject<T> register(String name, Supplier<T> blockSupplier, @Nullable Function<T, ? extends BlockItem> blockItemFactory) {
        return RegistrationHelpers.registerBlock(BLOCKS, RNRItems.ITEMS, (String)name, blockSupplier, blockItemFactory);
    }
}

