/*
 * Decompiled with CFR 0.152.
 */
package com.recipeessentials.mixin.nbt;

import com.recipeessentials.nbt.IParentAwareTag;
import com.recipeessentials.nbt.IParentTag;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.Tag;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ByteArrayTag.class})
public class ByteArrayTagMixin
implements IParentAwareTag {
    @Unique
    private IParentTag parentTag = null;

    @Override
    public void setParent(IParentTag tag) {
        this.parentTag = tag;
    }

    @Override
    public IParentTag parent() {
        return this.parentTag;
    }

    @Inject(method={"set(ILnet/minecraft/nbt/ByteTag;)Lnet/minecraft/nbt/ByteTag;"}, at={@At(value="RETURN")})
    private void onSet(int p_128196_, ByteTag p_128197_, CallbackInfoReturnable<ByteTag> cir) {
        if (this.parentTag != null) {
            this.parentTag.markDirty();
        }
    }

    @Inject(method={"add(ILnet/minecraft/nbt/ByteTag;)V"}, at={@At(value="RETURN")})
    private void onAddByteTag(int p_128215_, ByteTag p_128216_, CallbackInfo ci) {
        if (this.parentTag != null) {
            this.parentTag.markDirty();
        }
    }

    @Inject(method={"setTag"}, at={@At(value="RETURN")})
    private void onSetTag(int p_128218_, Tag p_128219_, CallbackInfoReturnable<Boolean> cir) {
        if (this.parentTag != null) {
            this.parentTag.markDirty();
        }
    }

    @Inject(method={"addTag"}, at={@At(value="RETURN")})
    private void onAddTag(int p_128218_, Tag p_128219_, CallbackInfoReturnable<Boolean> cir) {
        if (this.parentTag != null) {
            this.parentTag.markDirty();
        }
    }

    @Inject(method={"remove(I)Lnet/minecraft/nbt/ByteTag;"}, at={@At(value="RETURN")})
    private void onRemove(int p_128213_, CallbackInfoReturnable<ByteTag> cir) {
        if (this.parentTag != null) {
            this.parentTag.markDirty();
        }
    }

    @Inject(method={"clear"}, at={@At(value="RETURN")})
    private void onClear(CallbackInfo ci) {
        if (this.parentTag != null) {
            this.parentTag.markDirty();
        }
    }
}

