/*
 * Decompiled with CFR 0.152.
 */
package com.talons.playershops.screen;

import com.talons.playershops.block.entity.custom.PlayerShopBlockEntity;
import com.talons.playershops.screen.ModMenuTypes;
import com.talons.playershops.screen.slot.ShopCoinSlot;
import com.talons.playershops.screen.slot.ShopStockSlot;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;

public class PlayerShopMenu
extends AbstractContainerMenu {
    private final PlayerShopBlockEntity blockEntity;
    private final Level level;
    private static final int HOTBAR_SLOT_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_SLOT_COUNT = 27;
    private static final int VANILLA_SLOT_COUNT = 36;
    private static final int VANILLA_FIRST_SLOT_INDEX = 0;
    private static final int TE_INVENTORY_FIRST_SLOT_INDEX = 36;
    private static final int TE_INVENTORY_SLOT_COUNT = 2;

    public PlayerShopMenu(int p_38852_, Inventory inv, FriendlyByteBuf extraData) {
        this(p_38852_, inv, inv.f_35978_.m_9236_().m_7702_(extraData.m_130135_()));
    }

    public PlayerShopMenu(int p_38852_, Inventory inv, BlockEntity entity) {
        super((MenuType)ModMenuTypes.PLAYER_SHOP_MENU.get(), p_38852_);
        PlayerShopMenu.m_38869_((Container)inv, (int)2);
        this.blockEntity = (PlayerShopBlockEntity)entity;
        this.level = inv.f_35978_.m_9236_();
        this.addPlayerInventory(inv);
        this.addPlayerHotbar(inv);
        this.blockEntity.getStockOptional().ifPresent(handler -> this.m_38897_((Slot)new ShopStockSlot((IItemHandler)handler, 0, 80, 12, this.blockEntity)));
        this.blockEntity.getCoinOptional().ifPresent(handler -> this.m_38897_((Slot)new ShopCoinSlot((IItemHandler)handler, 0, 80, 60)));
    }

    protected boolean moveItemStackToModifiedIn(ItemStack p_38904_, int p_38905_, int p_38906_, boolean p_38907_) {
        boolean flag = false;
        int i = p_38905_;
        if (p_38907_) {
            i = p_38906_ - 1;
        }
        while (!p_38904_.m_41619_() && !(!p_38907_ ? i >= p_38906_ : i < p_38905_)) {
            Slot slot = (Slot)this.f_38839_.get(i);
            ItemStack itemstack = slot.m_7993_();
            if (!itemstack.m_41619_() && ItemStack.m_150942_((ItemStack)p_38904_, (ItemStack)itemstack)) {
                int maxSize;
                int j = itemstack.m_41613_() + p_38904_.m_41613_();
                if (j <= (maxSize = Math.max(p_38904_.m_41741_() * 10, 64))) {
                    p_38904_.m_41764_(0);
                    itemstack.m_41764_(j);
                    slot.m_6654_();
                    flag = true;
                } else if (itemstack.m_41613_() < maxSize) {
                    p_38904_.m_41774_(maxSize - itemstack.m_41613_());
                    itemstack.m_41764_(maxSize);
                    slot.m_6654_();
                    flag = true;
                }
            }
            if (p_38907_) {
                --i;
                continue;
            }
            ++i;
        }
        if (!p_38904_.m_41619_()) {
            i = p_38907_ ? p_38906_ - 1 : p_38905_;
            while (!(!p_38907_ ? i >= p_38906_ : i < p_38905_)) {
                Slot slot1 = (Slot)this.f_38839_.get(i);
                ItemStack itemstack1 = slot1.m_7993_();
                if (itemstack1.m_41619_() && slot1.m_5857_(p_38904_)) {
                    if (p_38904_.m_41613_() > slot1.m_6641_()) {
                        slot1.m_5852_(p_38904_.m_41620_(Math.max(p_38904_.m_41741_() * 10, 64)));
                    } else {
                        slot1.m_5852_(p_38904_.m_41620_(p_38904_.m_41613_()));
                    }
                    slot1.m_6654_();
                    flag = true;
                    break;
                }
                if (p_38907_) {
                    --i;
                    continue;
                }
                ++i;
            }
        }
        return flag;
    }

    protected boolean moveItemStackToModifiedOut(ItemStack p_38904_, int p_38905_, int p_38906_, boolean p_38907_) {
        boolean flag = false;
        if (!p_38904_.m_41619_()) {
            int availableSpaceNotEmpty = this.lookForAvailableSpace(p_38905_, p_38906_, p_38907_, p_38904_, false);
            int availableSpaceEmpty = this.lookForAvailableSpace(p_38905_, p_38906_, p_38907_, p_38904_, true);
            if (availableSpaceNotEmpty > -1) {
                int maxSize;
                Slot slot = (Slot)this.f_38839_.get(availableSpaceNotEmpty);
                ItemStack itemstack = slot.m_7993_();
                int j = itemstack.m_41613_() + Math.min(p_38904_.m_41613_(), p_38904_.m_41741_());
                if (j <= (maxSize = Math.min(slot.m_6641_(), p_38904_.m_41741_()))) {
                    p_38904_.m_41774_(Math.max(p_38904_.m_41741_(), p_38904_.m_41613_()));
                    itemstack.m_41764_(j);
                    slot.m_6654_();
                    flag = true;
                } else {
                    int shiftClickAmount;
                    int shiftClickAmountC = shiftClickAmount = Math.min(p_38904_.m_41613_(), p_38904_.m_41741_());
                    while (shiftClickAmount > 0) {
                        int remove;
                        int nextAvailableSpaceEmpty = this.lookForAvailableSpace(p_38905_, p_38906_, p_38907_, p_38904_, true);
                        int nextAvailableSpaceNotEmpty = this.lookForAvailableSpace(p_38905_, p_38906_, p_38907_, p_38904_, false);
                        if (nextAvailableSpaceNotEmpty > -1) {
                            Slot slot1 = (Slot)this.f_38839_.get(nextAvailableSpaceNotEmpty);
                            ItemStack itemstack1 = slot1.m_7993_();
                            remove = itemstack1.m_41741_() - itemstack1.m_41613_();
                            if (remove <= shiftClickAmount) {
                                itemstack1.m_41764_(maxSize);
                                shiftClickAmount -= remove;
                            } else {
                                itemstack1.m_41769_(shiftClickAmount);
                                shiftClickAmount = 0;
                            }
                            slot1.m_6654_();
                            flag = true;
                            continue;
                        }
                        if (nextAvailableSpaceEmpty > -1) {
                            Slot slot2 = (Slot)this.f_38839_.get(nextAvailableSpaceEmpty);
                            remove = Math.min(shiftClickAmount, p_38904_.m_41741_());
                            slot2.m_5852_(p_38904_.m_41777_());
                            ItemStack itemstack2 = slot2.m_7993_();
                            itemstack2.m_41764_(remove);
                            shiftClickAmount -= remove;
                            slot2.m_6654_();
                            flag = true;
                            continue;
                        }
                        shiftClickAmountC -= shiftClickAmount;
                        shiftClickAmount = 0;
                    }
                    p_38904_.m_41774_(shiftClickAmountC);
                }
            } else if (availableSpaceEmpty > -1) {
                Slot slot = (Slot)this.f_38839_.get(availableSpaceEmpty);
                ItemStack out = p_38904_.m_41777_();
                out.m_41764_(Math.min(p_38904_.m_41613_(), p_38904_.m_41741_()));
                p_38904_.m_41764_(p_38904_.m_41613_() - Math.min(p_38904_.m_41613_(), p_38904_.m_41741_()));
                slot.m_5852_(out);
            }
        }
        return flag;
    }

    private int lookForAvailableSpace(int startPoint, int endPoint, boolean backwards, ItemStack item, boolean findEmpty) {
        int i = startPoint;
        if (backwards) {
            i = endPoint - 1;
        }
        while (!(backwards ? i < startPoint : i >= endPoint)) {
            Slot slot = (Slot)this.f_38839_.get(i);
            ItemStack itemstack = slot.m_7993_();
            if (findEmpty ? itemstack.m_41619_() && slot.m_5857_(item) : !itemstack.m_41619_() && ItemStack.m_150942_((ItemStack)item, (ItemStack)itemstack) && itemstack.m_41613_() < itemstack.m_41741_()) {
                return i;
            }
            if (backwards) {
                --i;
                continue;
            }
            ++i;
        }
        return -1;
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        this.blockEntity.m_187482_();
        Slot sourceSlot = (Slot)this.f_38839_.get(index);
        if (sourceSlot == null || !sourceSlot.m_6657_()) {
            return ItemStack.f_41583_;
        }
        ItemStack sourceStack = sourceSlot.m_7993_();
        ItemStack copyOfSourceStack = sourceStack.m_41777_();
        if (index < 36) {
            if (!this.moveItemStackToModifiedIn(sourceStack, 36, 38, false)) {
                return ItemStack.f_41583_;
            }
        } else if (index < 38) {
            if (!this.moveItemStackToModifiedOut(sourceStack, 0, 36, false)) {
                return ItemStack.f_41583_;
            }
        } else {
            System.out.println("Invalid slotIndex:" + index);
            return ItemStack.f_41583_;
        }
        if (sourceStack.m_41613_() == 0) {
            sourceSlot.m_5852_(ItemStack.f_41583_);
        } else {
            sourceSlot.m_6654_();
        }
        sourceSlot.m_142406_(playerIn, sourceStack);
        return ItemStack.f_41583_;
    }

    public boolean m_6875_(Player pPlayer) {
        return PlayerShopMenu.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.level, (BlockPos)this.blockEntity.m_58899_()), (Player)pPlayer, (Block)this.blockEntity.m_58900_().m_60734_());
    }

    private void addPlayerInventory(Inventory playerInventory) {
        for (int i = 0; i < 3; ++i) {
            for (int l = 0; l < 9; ++l) {
                this.m_38897_(new Slot((Container)playerInventory, l + i * 9 + 9, 8 + l * 18, 86 + i * 18));
            }
        }
    }

    private void addPlayerHotbar(Inventory playerInventory) {
        for (int i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)playerInventory, i, 8 + i * 18, 144));
        }
    }
}

