/*
 * Decompiled with CFR 0.152.
 */
package com.nebby1999.firmacivplus.datagen.recipe_builders;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Objects;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.ForgeRegistries;

public interface ItemStackModifier {
    public static ItemStackModifier simple(String modifierId) {
        return () -> {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("type", modifierId);
            return jsonObject;
        };
    }

    public static JsonObject writeItemStackProvider(Item item, int count, List<ItemStackModifier> itemStackModifiers) {
        JsonObject itemResult = new JsonObject();
        JsonObject stack = new JsonObject();
        stack.addProperty("item", Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)item)).toString());
        if (count > 1) {
            stack.addProperty("count", (Number)count);
        }
        itemResult.add("stack", (JsonElement)stack);
        JsonArray modifiers = new JsonArray();
        itemStackModifiers.forEach(stackModifier -> modifiers.add(stackModifier.toJson()));
        itemResult.add("modifiers", (JsonElement)modifiers);
        return itemResult;
    }

    public JsonElement toJson();
}

