/*
 * Decompiled with CFR 0.152.
 */
package com.nebby1999.firmacivplus.datagen.recipe_builders;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.nebby1999.firmacivplus.datagen.recipe_builders.CraftingRecipeBuilder;
import com.nebby1999.firmacivplus.datagen.recipe_builders.ItemStackModifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.dries007.tfc.common.recipes.TFCRecipeSerializers;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.RequirementsStrategy;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.data.recipes.CraftingRecipeBuilder;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public abstract class AdvancedCraftingRecipeBuilder<B extends AdvancedCraftingRecipeBuilder<B>>
extends CraftingRecipeBuilder
implements RecipeBuilder {
    protected final String folderName;
    protected final CraftingBookCategory craftingBookCategory;
    protected final Item result;
    protected final int count;
    protected final Advancement.Builder advancement = Advancement.Builder.m_285878_();
    protected final List<ItemStackModifier> modifiers = new ArrayList<ItemStackModifier>();
    @Nullable
    protected String group;
    protected boolean damageInputs;

    protected AdvancedCraftingRecipeBuilder(CraftingBookCategory craftingBookCategory, String folderName, ItemLike result, int count) {
        this.craftingBookCategory = craftingBookCategory;
        this.folderName = folderName;
        this.result = result.m_5456_();
        this.count = count;
    }

    public static AdvancedShapedRecipeBuilder shaped(ItemLike result) {
        return AdvancedCraftingRecipeBuilder.shaped("crafting", result);
    }

    public static AdvancedShapedRecipeBuilder shaped(ItemLike result, int count) {
        return AdvancedCraftingRecipeBuilder.shaped("crafting", result, count);
    }

    public static AdvancedShapedRecipeBuilder shaped(String folderName, ItemLike result) {
        return AdvancedCraftingRecipeBuilder.shaped(folderName, result, 1);
    }

    public static AdvancedShapedRecipeBuilder shaped(String folderName, ItemLike result, int count) {
        return AdvancedCraftingRecipeBuilder.shaped(folderName, result, count, CraftingBookCategory.MISC);
    }

    public static AdvancedShapedRecipeBuilder shaped(String folderName, ItemLike result, int count, CraftingBookCategory category) {
        return new AdvancedShapedRecipeBuilder(category, folderName, result, count);
    }

    public static AdvancedShapelessRecipeBuilder shapeless(ItemLike result) {
        return AdvancedCraftingRecipeBuilder.shapeless("crafting", result);
    }

    public static AdvancedShapelessRecipeBuilder shapeless(ItemLike result, int count) {
        return AdvancedCraftingRecipeBuilder.shapeless("crafting", result, count);
    }

    public static AdvancedShapelessRecipeBuilder shapeless(String folderName, ItemLike result) {
        return AdvancedCraftingRecipeBuilder.shapeless(folderName, result, 1);
    }

    public static AdvancedShapelessRecipeBuilder shapeless(String folderName, ItemLike result, int count) {
        return AdvancedCraftingRecipeBuilder.shapeless(folderName, result, count, CraftingBookCategory.MISC);
    }

    public static AdvancedShapelessRecipeBuilder shapeless(String folderName, ItemLike result, int count, CraftingBookCategory category) {
        return new AdvancedShapelessRecipeBuilder(category, folderName, result, count);
    }

    public B modifier(ItemStackModifier stackModifier) {
        this.modifiers.add(stackModifier);
        return this.self();
    }

    public B unlockedBy(String criterionName, CriterionTriggerInstance criterionTrigger) {
        this.advancement.m_138386_(criterionName, criterionTrigger);
        return this.self();
    }

    public B group(@Nullable String groupName) {
        this.group = groupName;
        return this.self();
    }

    public Item m_142372_() {
        return this.result;
    }

    public void m_126140_(Consumer<FinishedRecipe> finishedRecipeConsumer, ResourceLocation recipeId) {
        this.ensureValid(recipeId);
        this.advancement.m_138396_(f_236353_).m_138386_("has_the_recipe", (CriterionTriggerInstance)RecipeUnlockedTrigger.m_63728_((ResourceLocation)recipeId)).m_138354_(AdvancementRewards.Builder.m_10009_((ResourceLocation)recipeId)).m_138360_(RequirementsStrategy.f_15979_);
        finishedRecipeConsumer.accept(this.createRecipe(recipeId));
    }

    public void m_176498_(Consumer<FinishedRecipe> finishedRecipeConsumer) {
        this.m_126140_(finishedRecipeConsumer, RecipeBuilder.m_176493_((ItemLike)this.m_142372_()).m_246208_(this.folderName + "/"));
    }

    public B damageInputs() {
        this.damageInputs = true;
        return this.self();
    }

    protected void ensureValid(ResourceLocation recipeId) {
        if (this.advancement.m_138405_().isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + String.valueOf(recipeId));
        }
    }

    protected abstract B self();

    protected abstract FinishedRecipe createRecipe(ResourceLocation var1);

    public static final class AdvancedShapedRecipeBuilder
    extends AdvancedCraftingRecipeBuilder<AdvancedShapedRecipeBuilder> {
        private final List<String> rows = Lists.newArrayList();
        private final Map<Character, Ingredient> key = Maps.newLinkedHashMap();
        private boolean showNotification = true;
        private int inputRow;
        private int inputColumn;

        private AdvancedShapedRecipeBuilder(CraftingBookCategory craftingBookCategory, String folderName, ItemLike result, int count) {
            super(craftingBookCategory, folderName, result, count);
        }

        public AdvancedShapedRecipeBuilder inputItem(Character symbol, TagKey<Item> tag, int row, int column) {
            return this.inputItem(symbol, Ingredient.m_204132_(tag), row, column);
        }

        public AdvancedShapedRecipeBuilder inputItem(Character symbol, ItemLike item, int row, int column) {
            return this.inputItem(symbol, Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}), row, column);
        }

        public AdvancedShapedRecipeBuilder inputItem(Character symbol, Ingredient ingredient, int row, int column) {
            this.inputRow = row;
            this.inputColumn = column;
            return this.define(symbol, ingredient);
        }

        public AdvancedShapedRecipeBuilder define(Character symbol, TagKey<Item> tag) {
            return this.define(symbol, Ingredient.m_204132_(tag));
        }

        public AdvancedShapedRecipeBuilder define(Character symbol, ItemLike item) {
            return this.define(symbol, Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
        }

        public AdvancedShapedRecipeBuilder define(Character symbol, Ingredient ingredient) {
            if (this.key.containsKey(symbol)) {
                throw new IllegalArgumentException("Symbol '" + symbol + "' is already defined!");
            }
            if (symbol.charValue() == ' ') {
                throw new IllegalArgumentException("Symbol ' ' (whitespace) is reserved and cannot be defined");
            }
            this.key.put(symbol, ingredient);
            return this;
        }

        public AdvancedShapedRecipeBuilder pattern(String pattern) {
            if (!this.rows.isEmpty() && pattern.length() != this.rows.get(0).length()) {
                throw new IllegalArgumentException("Pattern must be the same width on every line!");
            }
            this.rows.add(pattern);
            return this;
        }

        public AdvancedShapedRecipeBuilder pattern(String ... pattern) {
            Arrays.stream(pattern).forEach(this::pattern);
            return this;
        }

        public AdvancedShapedRecipeBuilder showNotification(boolean showNotification) {
            this.showNotification = showNotification;
            return this;
        }

        @Override
        protected AdvancedShapedRecipeBuilder self() {
            return this;
        }

        @Override
        protected FinishedRecipe createRecipe(ResourceLocation recipeId) {
            AdvancedShapedResult recipe = new AdvancedShapedResult(recipeId, this.result, this.count, this.group == null ? "" : this.group, this.craftingBookCategory, this.rows, this.key, this.advancement, recipeId.m_246208_("recipes/" + this.folderName + "/"), this.showNotification, this.modifiers, this.inputRow, this.inputColumn);
            return this.damageInputs ? new CraftingRecipeBuilder.ShapedCraftingRecipeBuilder.DamageInputShaped((FinishedRecipe)recipe) : recipe;
        }

        private static final class AdvancedShapedResult
        extends CraftingRecipeBuilder.CraftingResult {
            private final ResourceLocation id;
            private final Item result;
            private final int count;
            private final String group;
            private final List<String> pattern;
            private final Map<Character, Ingredient> key;
            private final Advancement.Builder advancement;
            private final ResourceLocation advancementId;
            private final boolean showNotification;
            private final List<ItemStackModifier> modifiers;
            private final int inputRow;
            private final int inputColumn;

            public AdvancedShapedResult(ResourceLocation recipeId, Item result, int count, String group, CraftingBookCategory craftingBookCategory, List<String> pattern, Map<Character, Ingredient> key, Advancement.Builder advancement, ResourceLocation advancementId, boolean showNotification, List<ItemStackModifier> modifiers, int inputRow, int inputColumn) {
                super(craftingBookCategory);
                this.id = recipeId;
                this.result = result;
                this.count = count;
                this.group = group;
                this.pattern = pattern;
                this.key = key;
                this.advancement = advancement;
                this.advancementId = advancementId;
                this.showNotification = showNotification;
                this.modifiers = modifiers;
                this.inputRow = inputRow;
                this.inputColumn = inputColumn;
            }

            public void m_7917_(JsonObject jsonObject) {
                super.m_7917_(jsonObject);
                if (!this.group.isEmpty()) {
                    jsonObject.addProperty("group", this.group);
                }
                JsonArray pattern = new JsonArray();
                this.pattern.forEach(arg_0 -> ((JsonArray)pattern).add(arg_0));
                jsonObject.add("pattern", (JsonElement)pattern);
                JsonObject key = new JsonObject();
                this.key.forEach((character, ingredient) -> key.add(String.valueOf(character), ingredient.m_43942_()));
                jsonObject.add("key", (JsonElement)key);
                jsonObject.add("result", (JsonElement)ItemStackModifier.writeItemStackProvider(this.result, this.count, this.modifiers));
                jsonObject.addProperty("show_notification", Boolean.valueOf(this.showNotification));
                jsonObject.addProperty("input_row", (Number)this.inputRow);
                jsonObject.addProperty("input_column", (Number)this.inputColumn);
            }

            public ResourceLocation m_6445_() {
                return this.id;
            }

            public RecipeSerializer<?> m_6637_() {
                return (RecipeSerializer)TFCRecipeSerializers.ADVANCED_SHAPED_CRAFTING.get();
            }

            public JsonObject m_5860_() {
                return this.advancement.m_138400_();
            }

            public ResourceLocation m_6448_() {
                return this.advancementId;
            }
        }
    }

    public static final class AdvancedShapelessRecipeBuilder
    extends AdvancedCraftingRecipeBuilder<AdvancedShapelessRecipeBuilder> {
        private final List<Ingredient> ingredients = Lists.newArrayList();
        @Nullable
        private Ingredient primaryIngredient;

        private AdvancedShapelessRecipeBuilder(CraftingBookCategory craftingBookCategory, String folderName, ItemLike result, int count) {
            super(craftingBookCategory, folderName, result, count);
        }

        public AdvancedShapelessRecipeBuilder primaryIngredient(Ingredient primaryIngredient) {
            this.primaryIngredient = primaryIngredient;
            return this;
        }

        public AdvancedShapelessRecipeBuilder requires(TagKey<Item> tag) {
            return this.requires(Ingredient.m_204132_(tag));
        }

        public AdvancedShapelessRecipeBuilder requires(ItemLike item) {
            return this.requires(Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
        }

        public AdvancedShapelessRecipeBuilder requires(ItemLike item, int quantity) {
            for (int i = 0; i < quantity; ++i) {
                this.requires(item);
            }
            return this;
        }

        public AdvancedShapelessRecipeBuilder requires(Ingredient ingredient) {
            this.ingredients.add(ingredient);
            return this;
        }

        public AdvancedShapelessRecipeBuilder requires(Ingredient ingredient, int quantity) {
            for (int i = 0; i < quantity; ++i) {
                this.requires(ingredient);
            }
            return this;
        }

        @Override
        protected void ensureValid(ResourceLocation recipeId) {
            super.ensureValid(recipeId);
            if (this.primaryIngredient == null) {
                throw new IllegalStateException("No primary ingredient set");
            }
        }

        @Override
        protected AdvancedShapelessRecipeBuilder self() {
            return this;
        }

        @Override
        protected FinishedRecipe createRecipe(ResourceLocation recipeId) {
            assert (this.primaryIngredient != null) : "How has this happened?";
            AdvancedResult recipe = new AdvancedResult(recipeId, this.result, this.count, this.group == null ? "" : this.group, this.craftingBookCategory, this.ingredients, this.advancement, recipeId.m_246208_("recipes/" + this.folderName + "/"), this.modifiers, this.primaryIngredient);
            return this.damageInputs ? new CraftingRecipeBuilder.ShapelessCraftingRecipeBuilder.DamageInputShapeless((FinishedRecipe)recipe) : recipe;
        }

        public static final class AdvancedResult
        extends CraftingRecipeBuilder.CraftingResult {
            private final ResourceLocation id;
            private final Item result;
            private final int count;
            private final String group;
            private final List<Ingredient> ingredients;
            private final Advancement.Builder advancement;
            private final ResourceLocation advancementId;
            private final List<ItemStackModifier> modifiers;
            private final Ingredient primaryIngredient;

            public AdvancedResult(ResourceLocation id, Item result, int count, String group, CraftingBookCategory category, List<Ingredient> ingredients, Advancement.Builder advancement, ResourceLocation advancementId, List<ItemStackModifier> modifiers, Ingredient primaryIngredient) {
                super(category);
                this.id = id;
                this.result = result;
                this.count = count;
                this.group = group;
                this.ingredients = ingredients;
                this.advancement = advancement;
                this.advancementId = advancementId;
                this.modifiers = modifiers;
                this.primaryIngredient = primaryIngredient;
            }

            public void m_7917_(JsonObject jsonObject) {
                super.m_7917_(jsonObject);
                if (!this.group.isEmpty()) {
                    jsonObject.addProperty("group", this.group);
                }
                JsonArray ingredients = new JsonArray();
                this.ingredients.stream().map(Ingredient::m_43942_).forEach(arg_0 -> ((JsonArray)ingredients).add(arg_0));
                jsonObject.add("ingredients", (JsonElement)ingredients);
                JsonObject result = new JsonObject();
                JsonObject stack = new JsonObject();
                stack.addProperty("item", ForgeRegistries.ITEMS.getKey((Object)this.result).toString());
                if (this.count > 1) {
                    stack.addProperty("count", (Number)this.count);
                }
                result.add("stack", (JsonElement)stack);
                jsonObject.add("result", (JsonElement)result);
                JsonArray modifiers = new JsonArray();
                this.modifiers.forEach(stackModifier -> modifiers.add(stackModifier.toJson()));
                result.add("modifiers", (JsonElement)modifiers);
                jsonObject.add("result", (JsonElement)result);
                jsonObject.add("primary_ingredient", this.primaryIngredient.m_43942_());
            }

            public ResourceLocation m_6445_() {
                return this.id;
            }

            public RecipeSerializer<?> m_6637_() {
                return (RecipeSerializer)TFCRecipeSerializers.ADVANCED_SHAPELESS_CRAFTING.get();
            }

            public JsonObject m_5860_() {
                return this.advancement.m_138400_();
            }

            public ResourceLocation m_6448_() {
                return this.advancementId;
            }
        }
    }
}

