/*
 * Decompiled with CFR 0.152.
 */
package com.nebby1999.firmacivplus;

import com.alekiponi.alekiroofs.SquaredAngleBlock;
import com.alekiponi.alekiships.util.BoatMaterial;
import com.alekiponi.firmaciv.common.block.CanoeComponentBlock;
import com.alekiponi.firmaciv.common.block.FirmacivAngledWoodenBoatFrameBlock;
import com.alekiponi.firmaciv.common.block.FirmacivBlocks;
import com.alekiponi.firmaciv.common.block.FirmacivFlatWoodenBoatFrameBlock;
import com.alekiponi.firmaciv.util.CanoeMaterial;
import com.nebby1999.firmacivplus.FirmaCivPlusItems;
import com.nebby1999.firmacivplus.WatercraftMaterial;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.dries007.tfc.common.blocks.wood.Wood;
import net.dries007.tfc.util.registry.RegistryWood;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class FirmaCivPlusBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"firmacivplus");
    private static final Map<WatercraftMaterial, RegistryObject<CanoeComponentBlock>> _CANOE_COMPONENT_BLOCKS = new HashMap<WatercraftMaterial, RegistryObject<CanoeComponentBlock>>();
    private static final Map<WatercraftMaterial, RegistryObject<FirmacivAngledWoodenBoatFrameBlock>> _WOODEN_BOAT_FRAME_ANGLED = new HashMap<WatercraftMaterial, RegistryObject<FirmacivAngledWoodenBoatFrameBlock>>();
    private static final Map<WatercraftMaterial, RegistryObject<FirmacivFlatWoodenBoatFrameBlock>> _WOODEN_BOAT_FRAME_FLAT = new HashMap<WatercraftMaterial, RegistryObject<FirmacivFlatWoodenBoatFrameBlock>>();
    private static final Map<WatercraftMaterial, RegistryObject<SquaredAngleBlock>> _WOOD_ROOFING = new HashMap<WatercraftMaterial, RegistryObject<SquaredAngleBlock>>();

    public static Map<WatercraftMaterial, RegistryObject<CanoeComponentBlock>> getCanoeComponentBlocks() {
        return Collections.unmodifiableMap(_CANOE_COMPONENT_BLOCKS);
    }

    public static Map<WatercraftMaterial, RegistryObject<FirmacivAngledWoodenBoatFrameBlock>> getWoodenBoatFrameAngledBlocks() {
        return Collections.unmodifiableMap(_WOODEN_BOAT_FRAME_ANGLED);
    }

    public static Map<WatercraftMaterial, RegistryObject<FirmacivFlatWoodenBoatFrameBlock>> getWoodenBoatFrameFlatBlocks() {
        return Collections.unmodifiableMap(_WOODEN_BOAT_FRAME_FLAT);
    }

    public static Map<WatercraftMaterial, RegistryObject<SquaredAngleBlock>> getWoodRoofings() {
        return Collections.unmodifiableMap(_WOOD_ROOFING);
    }

    static void init(IEventBus eventBus) {
        for (WatercraftMaterial woodEntry : WatercraftMaterial._ALL_WATERCRAFT_MATERIALS) {
            FirmaCivPlusBlocks.putWoodRoofing(woodEntry);
            if (woodEntry.isSoftwood()) {
                FirmaCivPlusBlocks.putCanoeComponentBlock(woodEntry);
                continue;
            }
            FirmaCivPlusBlocks.putAngledBoatFrameBlock(woodEntry);
            FirmaCivPlusBlocks.putFlatBoatFrameBlock(woodEntry);
        }
        if (!BLOCKS.getEntries().isEmpty()) {
            BLOCKS.register(eventBus);
        }
    }

    private static void putWoodRoofing(WatercraftMaterial watercraftMaterial) {
        String name = "wood/" + watercraftMaterial.m_7912_() + "_roofing";
        Supplier<SquaredAngleBlock> supplier = () -> {
            Block stairs = (Block)watercraftMaterial.getWood().getBlock(Wood.BlockType.STAIRS).get();
            BlockState blockState = stairs.m_49966_();
            BlockBehaviour.Properties blockProperties = BlockBehaviour.Properties.m_60926_((BlockBehaviour)stairs).m_284180_(watercraftMaterial.getWood().woodColor()).m_60955_();
            return new SquaredAngleBlock(blockState, blockProperties);
        };
        RegistryObject entry = BLOCKS.register(name, supplier);
        _WOOD_ROOFING.put(watercraftMaterial, (RegistryObject<SquaredAngleBlock>)entry);
        FirmaCivPlusItems.ITEMS.register(name, () -> new BlockItem((Block)entry.get(), new Item.Properties()));
    }

    private static void putCanoeComponentBlock(WatercraftMaterial watercraftMaterial) {
        String name = "wood/canoe_component_block/" + watercraftMaterial.m_7912_();
        Supplier<CanoeComponentBlock> supplier = () -> {
            RegistryWood wood = watercraftMaterial.getWood();
            Block strippedLog = (Block)wood.getBlock(Wood.BlockType.STRIPPED_LOG).get();
            BlockBehaviour.Properties properties = BlockBehaviour.Properties.m_60926_((BlockBehaviour)strippedLog).m_284180_(wood.woodColor()).m_60955_();
            return new CanoeComponentBlock(properties, (CanoeMaterial)watercraftMaterial);
        };
        RegistryObject entry = BLOCKS.register(name, supplier);
        _CANOE_COMPONENT_BLOCKS.put(watercraftMaterial, (RegistryObject<CanoeComponentBlock>)entry);
    }

    private static void putAngledBoatFrameBlock(WatercraftMaterial watercraftMaterial) {
        String name = "wood/watercraft_frame/angled/" + watercraftMaterial.m_7912_();
        Supplier<FirmacivAngledWoodenBoatFrameBlock> supplier = () -> new FirmacivAngledWoodenBoatFrameBlock((BoatMaterial)watercraftMaterial, BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)FirmacivBlocks.BOAT_FRAME_ANGLED.get())));
        RegistryObject entry = BLOCKS.register(name, supplier);
        _WOODEN_BOAT_FRAME_ANGLED.put(watercraftMaterial, (RegistryObject<FirmacivAngledWoodenBoatFrameBlock>)entry);
    }

    private static void putFlatBoatFrameBlock(WatercraftMaterial watercraftMaterial) {
        String name = "wood/watercraft_frame/flat/" + watercraftMaterial.m_7912_();
        Supplier<FirmacivFlatWoodenBoatFrameBlock> supplier = () -> new FirmacivFlatWoodenBoatFrameBlock((BoatMaterial)watercraftMaterial, BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)FirmacivBlocks.BOAT_FRAME_FLAT.get())));
        RegistryObject entry = BLOCKS.register(name, supplier);
        _WOODEN_BOAT_FRAME_FLAT.put(watercraftMaterial, (RegistryObject<FirmacivFlatWoodenBoatFrameBlock>)entry);
    }
}

