/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium_integrity;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraftforge.fml.loading.LoadingModList;
import net.minecraftforge.fml.loading.moddiscovery.ModFileInfo;
import net.minecraftforge.forgespi.language.IModInfo;
import org.apache.maven.artifact.versioning.Restriction;
import org.objectweb.asm.tree.ClassNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.MixinEnvironment;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.mixin.transformer.ClassInfo;
import org.spongepowered.asm.mixin.transformer.IMixinTransformer;
import org.spongepowered.asm.mixin.transformer.ext.Extensions;
import org.spongepowered.asm.mixin.transformer.ext.IExtension;
import org.spongepowered.asm.mixin.transformer.ext.IExtensionRegistry;
import org.spongepowered.asm.mixin.transformer.ext.ITargetClassContext;

public class MixinTaintDetector
implements IExtension {
    private static final List<String> TARGET_PREFIXES = List.of("me.jellysquid.mods.sodium", "org.embeddedt.embeddium");
    private static final MethodHandle GET_MIXINS_ON_CLASS_INFO;
    private static final Logger LOGGER;
    private static final EnforceLevel DEFAULT_ENFORCE_LEVEL;
    public static final EnforceLevel ENFORCE_LEVEL;
    private static final Collection<String> MOD_ID_WHITELIST;
    private static final Set<String> TAINTING_MODS;
    private static final Map<String, String> packagePrefixToModCache;

    public static Collection<String> getTaintingMods() {
        return Collections.unmodifiableCollection(TAINTING_MODS);
    }

    public static void initialize() {
        IMixinTransformer transformer;
        IExtensionRegistry iExtensionRegistry;
        Object object = MixinEnvironment.getDefaultEnvironment().getActiveTransformer();
        if (object instanceof IMixinTransformer && (iExtensionRegistry = (transformer = (IMixinTransformer)object).getExtensions()) instanceof Extensions) {
            Extensions internalExtensions = (Extensions)iExtensionRegistry;
            MixinTaintDetector instance = new MixinTaintDetector();
            try {
                Field extensionsField = internalExtensions.getClass().getDeclaredField("extensions");
                extensionsField.setAccessible(true);
                ((List)extensionsField.get(internalExtensions)).add(instance);
                Field activeExtensionsField = internalExtensions.getClass().getDeclaredField("activeExtensions");
                activeExtensionsField.setAccessible(true);
                ArrayList<MixinTaintDetector> newActiveExtensions = new ArrayList<MixinTaintDetector>((List)activeExtensionsField.get(internalExtensions));
                newActiveExtensions.add(instance);
                activeExtensionsField.set(internalExtensions, Collections.unmodifiableList(newActiveExtensions));
            }
            catch (ReflectiveOperationException | RuntimeException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean checkActive(MixinEnvironment environment) {
        return true;
    }

    private static boolean isEmbeddiumClass(String className) {
        for (String prefix : TARGET_PREFIXES) {
            if (!className.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    private static Set<IMixinInfo> getPotentialMixinsForClass(ClassInfo info) {
        if (GET_MIXINS_ON_CLASS_INFO != null) {
            try {
                return GET_MIXINS_ON_CLASS_INFO.invokeExact(info);
            }
            catch (Throwable e) {
                LOGGER.error("Error encountered getting mixins for class info", e);
            }
        }
        return Collections.emptySet();
    }

    private static String getModIdByPackage(String pkg) {
        String id = packagePrefixToModCache.get(pkg);
        if (id != null) {
            return id;
        }
        id = "[unknown]";
        String[] components = pkg.split("\\.");
        for (ModFileInfo mfi : LoadingModList.get().getModFiles()) {
            Path path;
            if (mfi.getMods().isEmpty() || (path = mfi.getFile().findResource(components)) == null || !Files.exists(path, new LinkOption[0])) continue;
            id = ((IModInfo)mfi.getMods().get(0)).getModId();
            break;
        }
        packagePrefixToModCache.put(pkg, id);
        return id;
    }

    private static boolean isDepSingleVersion(IModInfo.ModVersion version) {
        List restrictions = version.getVersionRange().getRestrictions();
        if (restrictions.isEmpty()) {
            return false;
        }
        for (Restriction restriction : restrictions) {
            if (restriction.getLowerBound() != null && restriction.getUpperBound() != null && restriction.getLowerBound().equals((Object)restriction.getUpperBound())) continue;
            return false;
        }
        return true;
    }

    private static Map<String, List<IMixinInfo>> filterInvalidMixins(Collection<IMixinInfo> mixins) {
        HashMap<String, List<IMixinInfo>> map = new HashMap<String, List<IMixinInfo>>();
        for (IMixinInfo mixin : mixins) {
            List deps;
            List<IModInfo.ModVersion> embeddiumDeps;
            ModFileInfo file;
            String pkg = mixin.getConfig().getMixinPackage();
            String modId = MixinTaintDetector.getModIdByPackage(pkg);
            if (MOD_ID_WHITELIST.contains(modId) || (file = LoadingModList.get().getModFileById(modId)) == null || !(embeddiumDeps = (deps = ((IModInfo)file.getMods().get(0)).getDependencies()).stream().filter(dep -> dep.getModId().equals("embeddium")).toList()).isEmpty() && !embeddiumDeps.stream().anyMatch(d -> !MixinTaintDetector.isDepSingleVersion(d))) continue;
            map.computeIfAbsent(modId, k -> new ArrayList()).add(mixin);
        }
        return map;
    }

    public void preApply(ITargetClassContext context) {
        Map<String, List<IMixinInfo>> illegalMixinMap;
        Set<IMixinInfo> mixins;
        if (ENFORCE_LEVEL == EnforceLevel.IGNORE) {
            return;
        }
        ClassInfo classInfo = context.getClassInfo();
        String name = classInfo.getClassName();
        if (MixinTaintDetector.isEmbeddiumClass(name) && !(mixins = MixinTaintDetector.getPotentialMixinsForClass(classInfo)).isEmpty() && !(illegalMixinMap = MixinTaintDetector.filterInvalidMixins(mixins)).isEmpty()) {
            if (TAINTING_MODS.isEmpty()) {
                LOGGER.error("Mod mixin into Embeddium internals detected. This instance is now tainted. The Embeddium team does not provide any guarantee of support for issues encountered while such mods are installed.");
            }
            TAINTING_MODS.addAll(illegalMixinMap.keySet());
            String mixinList = "[" + String.join((CharSequence)", ", illegalMixinMap.keySet()) + "]";
            LOGGER.warn("Mod(s) {} are modifying Embeddium class {}, which may cause instability.", (Object)mixinList, (Object)name);
            if (ENFORCE_LEVEL == EnforceLevel.CRASH) {
                throw new IllegalStateException("Mods " + mixinList + " are mixing into internal Embeddium class " + name + ". This has potential to destabilize the game, and the taint detector is currently configured to crash.");
            }
        }
    }

    public void postApply(ITargetClassContext context) {
    }

    public void export(MixinEnvironment env, String name, boolean force, ClassNode classNode) {
    }

    static {
        LOGGER = LoggerFactory.getLogger((String)"Embeddium-MixinTaintDetector");
        DEFAULT_ENFORCE_LEVEL = EnforceLevel.WARN;
        MOD_ID_WHITELIST = Set.of("embeddium", "flywheel");
        TAINTING_MODS = ConcurrentHashMap.newKeySet();
        MethodHandle mh = null;
        try {
            Field m = ClassInfo.class.getDeclaredField("mixins");
            m.setAccessible(true);
            mh = MethodHandles.publicLookup().unreflectGetter(m).asType(MethodType.methodType(Set.class, ClassInfo.class));
        }
        catch (ReflectiveOperationException | RuntimeException e) {
            e.printStackTrace();
        }
        GET_MIXINS_ON_CLASS_INFO = mh;
        EnforceLevel propertyLevel = EnforceLevel.valueOf(System.getProperty("embeddium.mixinTaintEnforceLevel", DEFAULT_ENFORCE_LEVEL.name()));
        if (propertyLevel.ordinal() < DEFAULT_ENFORCE_LEVEL.ordinal()) {
            propertyLevel = DEFAULT_ENFORCE_LEVEL;
        }
        ENFORCE_LEVEL = propertyLevel;
        packagePrefixToModCache = new ConcurrentHashMap<String, String>();
    }

    public static enum EnforceLevel {
        IGNORE,
        WARN,
        CRASH;

    }
}

